/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.ByteSequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class DirectByteCharSink
implements Mutable,
ByteSequence,
Closeable {
    private final long initialCapacity;
    private long capacity;
    private long hi;
    private long lo;
    private long ptr;

    public DirectByteCharSink(long capacity) {
        this.ptr = Unsafe.malloc(capacity, 51);
        this.capacity = capacity;
        this.initialCapacity = capacity;
        this.lo = this.ptr;
        this.hi = this.ptr + capacity;
    }

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    @Override
    public void clear() {
        this.lo = this.ptr;
    }

    @Override
    public void close() {
        Unsafe.free(this.ptr, this.capacity, 51);
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return (int)(this.lo - this.ptr);
    }

    public DirectByteCharSink put(ByteSequence cs) {
        if (cs != null) {
            int l = cs.length();
            if (this.lo + (long)l >= this.hi) {
                this.resize(Math.max(this.capacity * 2L, (this.lo - this.ptr + (long)l) * 2L));
            }
            for (int i = 0; i < l; ++i) {
                Unsafe.getUnsafe().putByte(this.lo + (long)i, cs.byteAt(i));
            }
            this.lo += (long)l;
        }
        return this;
    }

    public DirectByteCharSink put(byte b) {
        if (this.lo == this.hi) {
            this.resize(this.capacity * 2L);
        }
        Unsafe.getUnsafe().putByte(this.lo++, b);
        return this;
    }

    public void resetCapacity() {
        this.resize(this.initialCapacity);
        this.clear();
    }

    @NotNull
    public String toString() {
        return Chars.stringFromUtf8Bytes(this);
    }

    private void resize(long cap) {
        long temp = Unsafe.realloc(this.ptr, this.capacity, cap, 51);
        int len = (int)(this.lo - this.ptr);
        this.ptr = temp;
        this.capacity = cap;
        this.lo = this.ptr + (long)len;
        this.hi = this.ptr + cap;
    }
}

