/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.microtime;

import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.StringSink;

public final class Timestamps {
    public static final long DAY_MICROS = 86400000000L;
    public static final long FIRST_CENTURY_MICROS = -62135596800000000L;
    public static final long HOUR_MICROS = 3600000000L;
    public static final long MILLI_MICROS = 1000L;
    public static final long MINUTE_MICROS = 60000000L;
    public static final long O3_MIN_TS = 0L;
    public static final long SECOND_MICROS = 1000000L;
    public static final int SECOND_MILLIS = 1000;
    public static final long STARTUP_TIMESTAMP;
    public static final int STATE_DELIM = 4;
    public static final int STATE_END = 6;
    public static final int STATE_GMT = 2;
    public static final int STATE_HOUR = 3;
    public static final int STATE_INIT = 0;
    public static final int STATE_MINUTE = 5;
    public static final int STATE_SIGN = 7;
    public static final int STATE_UTC = 1;
    public static final long WEEK_MICROS = 604800000000L;
    private static final char AFTER_NINE = ':';
    private static final long AVG_YEAR_MICROS = 31556952000000L;
    private static final long HALF_YEAR_MICROS = 15778476000000L;
    private static final long EPOCH_MICROS = 62167195440000000L;
    private static final long HALF_EPOCH_MICROS = 31083597720000000L;
    private static final char BEFORE_ZERO = '/';
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final int[] DAYS_PER_MONTH;
    private static final int DAY_HOURS = 24;
    private static final int HOUR_MINUTES = 60;
    private static final long LEAP_YEAR_MICROS = 31622400000000L;
    private static final long[] MAX_MONTH_OF_YEAR_MICROS;
    private static final int MINUTE_SECONDS = 60;
    private static final long[] MIN_MONTH_OF_YEAR_MICROS;
    private static final long YEAR_MICROS = 31536000000000L;

    private Timestamps() {
    }

    public static long addDays(long micros, int days) {
        return micros + (long)days * 86400000000L;
    }

    public static long addHours(long micros, int hours) {
        return micros + (long)hours * 3600000000L;
    }

    public static long addMinutes(long micros, int minutes) {
        return micros + (long)minutes * 60000000L;
    }

    public static long addMonths(long micros, int months) {
        int _y;
        boolean l;
        if (months == 0) {
            return micros;
        }
        int y = Timestamps.getYear(micros);
        int m = Timestamps.getMonthOfYear(micros, y, l = Timestamps.isLeapYear(y));
        int _m = m - 1 + months;
        if (_m > -1) {
            _y = y + _m / 12;
            _m = _m % 12 + 1;
        } else {
            _y = y + _m / 12 - 1;
            if ((_m = -_m % 12) == 0) {
                _m = 12;
            }
            if ((_m = 12 - _m + 1) == 1) {
                ++_y;
            }
        }
        int _d = Timestamps.getDayOfMonth(micros, y, m, l);
        int maxDay = Timestamps.getDaysPerMonth(_m, Timestamps.isLeapYear(_y));
        if (_d > maxDay) {
            _d = maxDay;
        }
        return Timestamps.toMicros(_y, _m, _d) + Timestamps.getTimeMicros(micros) + (long)(micros < 0L ? 1 : 0);
    }

    public static long addPeriod(long lo, char type, int period) {
        switch (type) {
            case 's': {
                return Timestamps.addSeconds(lo, period);
            }
            case 'm': {
                return Timestamps.addMinutes(lo, period);
            }
            case 'h': {
                return Timestamps.addHours(lo, period);
            }
            case 'd': {
                return Timestamps.addDays(lo, period);
            }
            case 'w': {
                return Timestamps.addWeeks(lo, period);
            }
            case 'M': {
                return Timestamps.addMonths(lo, period);
            }
            case 'y': {
                return Timestamps.addYear(lo, period);
            }
        }
        return Long.MIN_VALUE;
    }

    public static long addSeconds(long micros, int seconds) {
        return micros + (long)seconds * 1000000L;
    }

    public static long addWeeks(long micros, int weeks) {
        return micros + (long)weeks * 604800000000L;
    }

    public static long addYear(long micros, int years) {
        if (years == 0) {
            return micros;
        }
        int y = Timestamps.getYear(micros);
        boolean leap1 = Timestamps.isLeapYear(y);
        boolean leap2 = Timestamps.isLeapYear(y + years);
        int m = Timestamps.getMonthOfYear(micros, y, leap1);
        return Timestamps.yearMicros(y + years, leap2) + Timestamps.monthOfYearMicros(m, leap2) + (long)(Timestamps.getDayOfMonth(micros, y, m, leap1) - 1) * 86400000000L + Timestamps.getTimeMicros(micros) + (long)(micros < 0L ? 1 : 0);
    }

    public static long ceilDD(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(micros, y, l);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(m, l) + (long)Timestamps.getDayOfMonth(micros, y, m, l) * 86400000000L;
    }

    public static long ceilHH(long micros) {
        return Timestamps.floorHH(micros) + 3600000000L;
    }

    public static long ceilMI(long micros) {
        return Timestamps.floorMI(micros) + 60000000L;
    }

    public static long ceilMM(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(micros, y, l);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(m, l) + (long)Timestamps.getDaysPerMonth(m, l) * 86400000000L;
    }

    public static long ceilMS(long micros) {
        return Timestamps.floorMS(micros) + 1000L;
    }

    public static long ceilSS(long micros) {
        return Timestamps.floorSS(micros) + 1000000L;
    }

    public static long ceilWW(long micros) {
        return Timestamps.floorWW(micros) + 604800000000L;
    }

    public static long ceilYYYY(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(12, l) + (long)DAYS_PER_MONTH[11] * 86400000000L;
    }

    public static long endOfYear(int year) {
        return Timestamps.toMicros(year, 12, 31, 23, 59) + 59000L + 999999L;
    }

    public static long floorCentury(long micros) {
        int year = Timestamps.getYear(micros);
        int centuryFirstYear = (year + 99) / 100 * 100 - 99;
        boolean leapYear = Timestamps.isLeapYear(centuryFirstYear);
        return Timestamps.yearMicros(centuryFirstYear, leapYear);
    }

    public static long floorDD(long micros) {
        return Timestamps.floorDD(micros, 1);
    }

    public static long floorDD(long micros, int stride) {
        long result = micros - Timestamps.getTimeMicros(micros, stride);
        return Math.min(result, micros);
    }

    public static long floorDOW(long micros) {
        long l = Timestamps.previousOrSameDayOfWeek(micros, 1);
        return Timestamps.floorDD(l);
    }

    public static long floorDecade(long micros) {
        int year = Timestamps.getYear(micros);
        int decadeFirstYear = year / 10 * 10;
        boolean leapYear = Timestamps.isLeapYear(decadeFirstYear);
        return Timestamps.yearMicros(decadeFirstYear, leapYear);
    }

    public static long floorHH(long micros) {
        return Timestamps.floorHH(micros, 1);
    }

    public static long floorHH(long micros, int stride) {
        return micros - micros % ((long)stride * 3600000000L);
    }

    public static long floorMI(long micros) {
        return Timestamps.floorMI(micros, 1);
    }

    public static long floorMI(long micros, int stride) {
        return micros - micros % ((long)stride * 60000000L);
    }

    public static long floorMM(long micros) {
        int y = Timestamps.getYear(micros);
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(Timestamps.getMonthOfYear(micros, y, l), l);
    }

    public static long floorMM(long micros, int stride) {
        int origin = Timestamps.getYear(0L);
        long m = Timestamps.getMonthsBetween(0L, micros) / (long)stride * (long)stride;
        int y = (int)((long)origin + m / 12L);
        int mm = (int)(m % 12L);
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + (mm > 0 ? Timestamps.monthOfYearMicros(mm, l) : 0L);
    }

    public static long floorMS(long micros) {
        return Timestamps.floorMS(micros, 1);
    }

    public static long floorMS(long micros, int stride) {
        return micros - micros % ((long)stride * 1000L);
    }

    public static long floorMillennium(long micros) {
        int year = Timestamps.getYear(micros);
        int millenniumFirstYear = (year + 999) / 1000 * 1000 - 999;
        boolean leapYear = Timestamps.isLeapYear(millenniumFirstYear);
        return Timestamps.yearMicros(millenniumFirstYear, leapYear);
    }

    public static long floorQuarter(long micros) {
        int year = Timestamps.getYear(micros);
        boolean leapYear = Timestamps.isLeapYear(year);
        int monthOfYear = Timestamps.getMonthOfYear(micros, year, leapYear);
        int q = (monthOfYear - 1) / 3;
        int month = 3 * q + 1;
        return Timestamps.yearMicros(year, leapYear) + Timestamps.monthOfYearMicros(month, leapYear);
    }

    public static long floorSS(long micros) {
        return Timestamps.floorSS(micros, 1);
    }

    public static long floorSS(long micros, int stride) {
        return micros - micros % ((long)stride * 1000000L);
    }

    public static long floorWW(long micros) {
        return Timestamps.floorWW(micros, 1);
    }

    public static long floorWW(long micros, int stride) {
        long weekOffset = (micros + 259200000000L) % ((long)stride * 604800000000L);
        if (weekOffset < 0L) {
            weekOffset += (long)stride * 604800000000L;
        }
        return micros - weekOffset;
    }

    public static long floorYYYY(long micros) {
        int y = Timestamps.getYear(micros);
        return Timestamps.yearMicros(y, Timestamps.isLeapYear(y));
    }

    public static long floorYYYY(long micros, int stride) {
        int origin = Timestamps.getYear(0L);
        int y = origin + (Timestamps.getYear(micros) - origin) / stride * stride;
        return Timestamps.yearMicros(y, Timestamps.isLeapYear(y));
    }

    public static int getCentury(long micros) {
        int century;
        int year = Timestamps.getYear(micros);
        if (year > (century = year / 100) * 100) {
            ++century;
        }
        if (micros >= -62135596800000000L) {
            return century;
        }
        return century - 1;
    }

    public static int getDayOfMonth(long micros, int year, int month, boolean leap) {
        long yearMicros = Timestamps.yearMicros(year, leap);
        return (int)((micros - (yearMicros += Timestamps.monthOfYearMicros(month, leap))) / 86400000000L) + 1;
    }

    public static int getDayOfTheWeekOfEndOfYear(int year) {
        return (year + Math.abs(year / 4) - Math.abs(year / 100) + Math.abs(year / 400)) % 7;
    }

    public static int getDayOfWeek(long micros) {
        long d;
        if (micros > -1L) {
            d = micros / 86400000000L;
        } else {
            d = (micros - 86399999999L) / 86400000000L;
            if (d < -3L) {
                return 7 + (int)((d + 4L) % 7L);
            }
        }
        return 1 + (int)((d + 3L) % 7L);
    }

    public static int getDayOfWeekSundayFirst(long micros) {
        long d;
        if (micros > -1L) {
            d = micros / 86400000000L;
        } else {
            d = (micros - 86399999999L) / 86400000000L;
            if (d < -4L) {
                return 7 + (int)((d + 5L) % 7L);
            }
        }
        return 1 + (int)((d + 4L) % 7L);
    }

    public static int getDayOfYear(long micros) {
        int year = Timestamps.getYear(micros);
        boolean leap = Timestamps.isLeapYear(year);
        long yearStart = Timestamps.yearMicros(year, leap);
        return (int)((micros - yearStart) / 86400000000L) + 1;
    }

    public static long getDaysBetween(long a, long b) {
        return Math.abs(a - b) / 86400000000L;
    }

    public static int getDaysPerMonth(int m, boolean leap) {
        return leap & m == 2 ? 29 : DAYS_PER_MONTH[m - 1];
    }

    public static int getDecade(long micros) {
        return Timestamps.getYear(micros) / 10;
    }

    public static int getDow(long micros) {
        return Timestamps.getDayOfWeekSundayFirst(micros) - 1;
    }

    public static int getDoy(long micros) {
        int year = Timestamps.getYear(micros);
        boolean leap = Timestamps.isLeapYear(year);
        long yearStart = Timestamps.yearMicros(year, leap);
        return (int)((micros - yearStart) / 86400000000L) + 1;
    }

    public static int getHourOfDay(long micros) {
        if (micros > -1L) {
            return (int)(micros / 3600000000L % 24L);
        }
        return 23 + (int)((micros + 1L) / 3600000000L % 24L);
    }

    public static long getHoursBetween(long a, long b) {
        return Math.abs(a - b) / 3600000000L;
    }

    public static int getIsoYear(long micros) {
        int w = (10 + Timestamps.getDoy(micros) - Timestamps.getDayOfWeek(micros)) / 7;
        int y = Timestamps.getYear(micros);
        if (w < 1) {
            return y - 1;
        }
        if (w > Timestamps.getWeeks(y)) {
            return y + 1;
        }
        return y;
    }

    public static int getIsoYearDayOffset(int year) {
        int dayOfTheWeekOfEndOfPreviousYear = Timestamps.getDayOfTheWeekOfEndOfYear(year - 1);
        return (dayOfTheWeekOfEndOfPreviousYear <= 3 ? 0 : 7) - dayOfTheWeekOfEndOfPreviousYear;
    }

    public static int getMicrosOfMilli(long micros) {
        if (micros > -1L) {
            return (int)(micros % 1000L);
        }
        return (int)(999L + (micros + 1L) % 1000L);
    }

    public static long getMicrosOfMinute(long micros) {
        if (micros > -1L) {
            return micros % 60000000L;
        }
        return 59999999L + (micros + 1L) % 60000000L;
    }

    public static int getMicrosOfSecond(long micros) {
        if (micros > -1L) {
            return (int)(micros % 1000000L);
        }
        return (int)(999999L + (micros + 1L) % 1000000L);
    }

    public static int getMillennium(long micros) {
        int year = Timestamps.getYear(micros);
        int millenniumFirstYear = (year + 999) / 1000 * 1000 - 999;
        return millenniumFirstYear / 1000 + 1;
    }

    public static long getMillisOfMinute(long micros) {
        return Timestamps.getMicrosOfMinute(micros) / 1000L;
    }

    public static int getMillisOfSecond(long micros) {
        if (micros > -1L) {
            return (int)(micros / 1000L % 1000L);
        }
        return 999 + (int)((micros + 1L) / 1000L % 1000L);
    }

    public static int getMinuteOfHour(long micros) {
        if (micros > -1L) {
            return (int)(micros / 60000000L % 60L);
        }
        return 59 + (int)((micros + 1L) / 60000000L % 60L);
    }

    public static long getMinutesBetween(long a, long b) {
        return Math.abs(a - b) / 60000000L;
    }

    public static int getMonthOfYear(long micros) {
        int y = Timestamps.getYear(micros);
        boolean leap = Timestamps.isLeapYear(y);
        return Timestamps.getMonthOfYear(micros, y, leap);
    }

    public static int getMonthOfYear(long micros, int year, boolean leap) {
        int i = (int)((micros - Timestamps.yearMicros(year, leap)) / 1000L >> 10);
        return leap ? (i < 15356250 ? (i < 7678125 ? (i < 2615625 ? 1 : (i < 5062500 ? 2 : 3)) : (i < 10209375 ? 4 : (i < 12825000 ? 5 : 6))) : (i < 23118750 ? (i < 17971875 ? 7 : (i < 20587500 ? 8 : 9)) : (i < 25734375 ? 10 : (i < 28265625 ? 11 : 12)))) : (i < 15271875 ? (i < 7593750 ? (i < 2615625 ? 1 : (i < 4978125 ? 2 : 3)) : (i < 10125000 ? 4 : (i < 12740625 ? 5 : 6))) : (i < 23034375 ? (i < 17887500 ? 7 : (i < 20503125 ? 8 : 9)) : (i < 25650000 ? 10 : (i < 28181250 ? 11 : 12))));
    }

    public static long getMonthsBetween(long a, long b) {
        if (b < a) {
            return Timestamps.getMonthsBetween(b, a);
        }
        int aYear = Timestamps.getYear(a);
        int bYear = Timestamps.getYear(b);
        boolean aLeap = Timestamps.isLeapYear(aYear);
        boolean bLeap = Timestamps.isLeapYear(bYear);
        int aMonth = Timestamps.getMonthOfYear(a, aYear, aLeap);
        int bMonth = Timestamps.getMonthOfYear(b, bYear, bLeap);
        long aResidual = a - Timestamps.yearMicros(aYear, aLeap) - Timestamps.monthOfYearMicros(aMonth, aLeap);
        long bResidual = b - Timestamps.yearMicros(bYear, bLeap) - Timestamps.monthOfYearMicros(bMonth, bLeap);
        long months = 12L * (long)(bYear - aYear) + (long)(bMonth - aMonth);
        if (aResidual > bResidual) {
            return months - 1L;
        }
        return months;
    }

    public static long getPeriodBetween(char type, long start, long end) {
        switch (type) {
            case 's': {
                return Timestamps.getSecondsBetween(start, end);
            }
            case 'm': {
                return Timestamps.getMinutesBetween(start, end);
            }
            case 'h': {
                return Timestamps.getHoursBetween(start, end);
            }
            case 'd': {
                return Timestamps.getDaysBetween(start, end);
            }
            case 'w': {
                return Timestamps.getWeeksBetween(start, end);
            }
            case 'M': {
                return Timestamps.getMonthsBetween(start, end);
            }
            case 'y': {
                return Timestamps.getYearsBetween(start, end);
            }
        }
        return Long.MIN_VALUE;
    }

    public static int getQuarter(long micros) {
        int month = Timestamps.getMonthOfYear(micros);
        return (month - 1) / 3 + 1;
    }

    public static int getSecondOfMinute(long micros) {
        if (micros > -1L) {
            return (int)(micros / 1000000L % 60L);
        }
        return 59 + (int)((micros + 1L) / 1000000L % 60L);
    }

    public static long getSecondsBetween(long a, long b) {
        return Math.abs(a - b) / 1000000L;
    }

    public static int getWeek(long micros) {
        int w = (10 + Timestamps.getDoy(micros) - Timestamps.getDayOfWeek(micros)) / 7;
        int y = Timestamps.getYear(micros);
        if (w < 1) {
            return Timestamps.getWeeks(y - 1);
        }
        if (w > Timestamps.getWeeks(y)) {
            return 1;
        }
        return w;
    }

    public static int getWeekOfMonth(long micros) {
        int year = Timestamps.getYear(micros);
        boolean leap = Timestamps.isLeapYear(year);
        return Timestamps.getDayOfMonth(micros, year, Timestamps.getMonthOfYear(micros, year, leap), leap) / 7 + 1;
    }

    public static int getWeekOfYear(long micros) {
        return Timestamps.getDayOfYear(micros) / 7 + 1;
    }

    public static int getWeeks(int y) {
        if (Timestamps.getDayOfTheWeekOfEndOfYear(y) == 4 || Timestamps.getDayOfTheWeekOfEndOfYear(y - 1) == 3) {
            return 53;
        }
        return 52;
    }

    public static long getWeeksBetween(long a, long b) {
        return Math.abs(a - b) / 604800000000L;
    }

    public static int getYear(long micros) {
        boolean leap;
        int year;
        long yearStart;
        long diff;
        long mid = (micros >> 1) + 31083597720000000L;
        if (mid < 0L) {
            mid = mid - 15778476000000L + 1L;
        }
        if ((diff = micros - (yearStart = Timestamps.yearMicros(year = (int)(mid / 15778476000000L), leap = Timestamps.isLeapYear(year)))) < 0L) {
            --year;
        } else if (diff >= 31536000000000L && (yearStart += leap ? 31622400000000L : 31536000000000L) <= micros) {
            ++year;
        }
        return year;
    }

    public static long getYearsBetween(long a, long b) {
        return Timestamps.getMonthsBetween(a, b) / 12L;
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static long monthOfYearMicros(int month, boolean leap) {
        return leap ? MAX_MONTH_OF_YEAR_MICROS[month - 1] : MIN_MONTH_OF_YEAR_MICROS[month - 1];
    }

    public static long nextOrSameDayOfWeek(long millis, int dow) {
        int thisDow = Timestamps.getDayOfWeek(millis);
        if (thisDow == dow) {
            return millis;
        }
        if (thisDow < dow) {
            return millis + (long)(dow - thisDow) * 86400000000L;
        }
        return millis + (long)(7 - (thisDow - dow)) * 86400000000L;
    }

    public static long parseNanosAsMicrosGreedy(CharSequence sequence, int p, int lim) throws NumericException {
        char c;
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim || Numbers.notDigit(sequence.charAt(i))) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim && !Numbers.notDigit(c = sequence.charAt(i))) {
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        int len = i - p;
        if (len > 9 || val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        while (i - p < 9) {
            val *= 10;
            ++i;
        }
        return Numbers.encodeLowHighInts(negative ? val : -(val /= 1000), len);
    }

    public static long parseOffset(CharSequence in) {
        return Timestamps.parseOffset(in, 0, in.length());
    }

    public static long parseOffset(CharSequence in, int lo, int hi) {
        int minute;
        int hour;
        boolean negative;
        int state;
        int p;
        block34: {
            p = lo;
            state = 0;
            negative = false;
            hour = 0;
            minute = 0;
            try {
                while (p < hi) {
                    char c = in.charAt(p);
                    switch (state) {
                        case 0: {
                            switch (c) {
                                case 'U': 
                                case 'u': {
                                    state = 1;
                                    break;
                                }
                                case 'G': 
                                case 'g': {
                                    state = 2;
                                    break;
                                }
                                case 'Z': 
                                case 'z': {
                                    state = 6;
                                    break;
                                }
                                case '+': {
                                    state = 3;
                                    break;
                                }
                                case '-': {
                                    negative = true;
                                    state = 3;
                                    break;
                                }
                                default: {
                                    if (Timestamps.isDigit(c)) {
                                        state = 3;
                                        --p;
                                        break;
                                    }
                                    return Long.MIN_VALUE;
                                }
                            }
                            ++p;
                            break;
                        }
                        case 1: {
                            if (p > hi - 2 || Chars.noMatch(in, p, p + 2, "tc", 0, 2)) {
                                return Long.MIN_VALUE;
                            }
                            state = 7;
                            p += 2;
                            break;
                        }
                        case 2: {
                            if (p > hi - 2 || Chars.noMatch(in, p, p + 2, "mt", 0, 2)) {
                                return Long.MIN_VALUE;
                            }
                            state = 7;
                            p += 2;
                            break;
                        }
                        case 7: {
                            switch (c) {
                                case '+': {
                                    break;
                                }
                                case '-': {
                                    negative = true;
                                    break;
                                }
                                default: {
                                    return Long.MIN_VALUE;
                                }
                            }
                            ++p;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (!Timestamps.isDigit(c) || p >= hi - 1) {
                                return Long.MIN_VALUE;
                            }
                            hour = Numbers.parseInt(in, p, p + 2);
                            state = 4;
                            p += 2;
                            break;
                        }
                        case 4: {
                            if (c == ':') {
                                state = 5;
                                ++p;
                                break;
                            }
                            if (Timestamps.isDigit(c)) {
                                state = 5;
                                break;
                            }
                            return Long.MIN_VALUE;
                        }
                        case 5: {
                            if (!Timestamps.isDigit(c) || p >= hi - 1) {
                                return Long.MIN_VALUE;
                            }
                            minute = Numbers.parseInt(in, p, p + 2);
                            p += 2;
                            state = 6;
                            break block34;
                        }
                        default: {
                            return Long.MIN_VALUE;
                        }
                    }
                }
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
        switch (state) {
            case 4: 
            case 6: {
                if (hour > 23 || minute > 59) {
                    return Long.MIN_VALUE;
                }
                int min = hour * 60 + minute;
                return Numbers.encodeLowHighInts(negative ? -min : min, p - lo);
            }
        }
        return Long.MIN_VALUE;
    }

    public static long previousOrSameDayOfWeek(long micros, int dow) {
        int thisDow = Timestamps.getDayOfWeek(micros);
        if (thisDow == dow) {
            return micros;
        }
        if (thisDow < dow) {
            return micros - (long)(7 + (thisDow - dow)) * 86400000000L;
        }
        return micros - (long)(thisDow - dow) * 86400000000L;
    }

    public static long toMicros(int y, int m, int d, int h, int mi) {
        return Timestamps.toMicros(y, Timestamps.isLeapYear(y), m, d, h, mi);
    }

    public static long toMicros(int y, boolean leap, int m, int d, int h, int mi) {
        return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)(d - 1) * 86400000000L + (long)h * 3600000000L + (long)mi * 60000000L;
    }

    public static long toMicros(int y, boolean leap, int day, int month, int hour, int min, int sec, int millis, int micros) {
        int maxDay = Math.min(day, Timestamps.getDaysPerMonth(month, leap)) - 1;
        return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(month, leap) + (long)maxDay * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + (long)millis * 1000L + (long)micros;
    }

    public static long toMicros(int y, int m, int d) {
        boolean l = Timestamps.isLeapYear(y);
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(m, l) + (long)(d - 1) * 86400000000L;
    }

    public static String toString(long micros) {
        StringSink sink = Misc.getThreadLocalBuilder();
        TimestampFormatUtils.appendDateTime(sink, micros);
        return ((Object)sink).toString();
    }

    public static long toTimezone(long utcTimestamp, DateLocale locale, CharSequence timezone) throws NumericException {
        return Timestamps.toTimezone(utcTimestamp, locale, timezone, 0, timezone.length());
    }

    public static long toTimezone(long utc, DateLocale locale, CharSequence timezone, int lo, int hi) throws NumericException {
        long l = Timestamps.parseOffset(timezone, lo, hi);
        if (l == Long.MIN_VALUE) {
            return utc + locale.getZoneRules(Numbers.decodeLowInt(locale.matchZone(timezone, lo, hi)), 1).getOffset(utc);
        }
        long offset = (long)Numbers.decodeLowInt(l) * 60000000L;
        return utc + offset;
    }

    public static String toUSecString(long micros) {
        StringSink sink = Misc.getThreadLocalBuilder();
        TimestampFormatUtils.appendDateTimeUSec(sink, micros);
        return ((Object)sink).toString();
    }

    public static long toUTC(long timestampWithTimezone, DateLocale locale, CharSequence timezone) throws NumericException {
        return Timestamps.toUTC(timestampWithTimezone, locale, timezone, 0, timezone.length());
    }

    public static long toUTC(long timestampWithTimezone, DateLocale locale, CharSequence timezone, int lo, int hi) throws NumericException {
        long l = Timestamps.parseOffset(timezone, lo, hi);
        if (l == Long.MIN_VALUE) {
            TimeZoneRules zoneRules = locale.getZoneRules(Numbers.decodeLowInt(locale.matchZone(timezone, lo, hi)), 1);
            long offset = zoneRules.getOffset(timestampWithTimezone);
            offset = zoneRules.getOffset(timestampWithTimezone - offset);
            return timestampWithTimezone - offset;
        }
        long offset = (long)Numbers.decodeLowInt(l) * 60000000L;
        return timestampWithTimezone - offset;
    }

    public static long yearMicros(int year, boolean leap) {
        int leapYears = year / 100;
        if (year < 0) {
            leapYears = (year + 3 >> 2) - leapYears + (leapYears + 3 >> 2) - 1;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (leap) {
                --leapYears;
            }
        }
        long days = (long)year * 365L + (long)(leapYears - 719527);
        long micros = days * 86400000000L;
        if (days < 0L & micros > 0L) {
            return Long.MIN_VALUE;
        }
        return micros;
    }

    private static long getTimeMicros(long micros) {
        return micros < 0L ? 86399999999L + micros % 86400000000L : micros % 86400000000L;
    }

    private static long getTimeMicros(long micros, int stride) {
        long us = (long)stride * 86400000000L;
        return micros < 0L ? us - 1L + micros % us : micros % us;
    }

    private static boolean isDigit(char c) {
        return c > '/' && c < ':';
    }

    static {
        DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        MAX_MONTH_OF_YEAR_MICROS = new long[12];
        MIN_MONTH_OF_YEAR_MICROS = new long[12];
        STARTUP_TIMESTAMP = Os.currentTimeMicros();
        long minSum = 0L;
        long maxSum = 0L;
        for (int i = 0; i < 11; ++i) {
            Timestamps.MIN_MONTH_OF_YEAR_MICROS[i + 1] = minSum += (long)DAYS_PER_MONTH[i] * 86400000000L;
            Timestamps.MAX_MONTH_OF_YEAR_MICROS[i + 1] = maxSum += (long)Timestamps.getDaysPerMonth(i + 1, true) * 86400000000L;
        }
    }
}

