/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class ObjectPool<T extends Mutable>
implements Mutable {
    private static final Log LOG = LogFactory.getLog(ObjectPool.class);
    private final ObjectFactory<T> factory;
    private final ObjList<T> list;
    private int pos = 0;
    private int size;

    public ObjectPool(@NotNull ObjectFactory<T> factory, int size) {
        this.list = new ObjList(size);
        this.factory = factory;
        this.size = size;
        this.fill();
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public T next() {
        if (this.pos == this.size) {
            this.expand();
        }
        Mutable o = (Mutable)this.list.getQuick(this.pos++);
        o.clear();
        return (T)o;
    }

    private void expand() {
        this.fill();
        this.size <<= 1;
        LOG.info().$("pool resize [class=").$(this.factory.getClass().getName()).$(", size=").$(this.size).$(']').$();
    }

    private void fill() {
        for (int i = 0; i < this.size; ++i) {
            this.list.add((Mutable)this.factory.newInstance());
        }
    }
}

