/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import java.util.Arrays;

public final class LongLongHashSet
implements Mutable,
Sinkable {
    public static final SinkStrategy LONG_LONG_STRATEGY = (key1, key2, sink) -> {
        sink.put('[');
        Numbers.append(sink, key1, false);
        sink.put(',');
        Numbers.append(sink, key2, false);
        sink.put(']');
    };
    public static final SinkStrategy UUID_STRATEGY = (key1, key2, sink) -> {
        sink.put('\'');
        Numbers.appendUuid(key1, key2, sink);
        sink.put('\'');
    };
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final double loadFactor;
    private final long noEntryKeyValue;
    private final SinkStrategy sinkStrategy;
    private int capacity;
    private int mask;
    private int size;
    private long[] values;

    public LongLongHashSet(int initialCapacity, double loadFactor, long noEntryValue, SinkStrategy sinkStrategy) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < load factor < 1");
        }
        this.noEntryKeyValue = noEntryValue;
        this.loadFactor = loadFactor;
        this.capacity = Math.max(initialCapacity, 16);
        int slots = Numbers.ceilPow2((int)((double)this.capacity / loadFactor));
        this.values = new long[2 * slots];
        this.mask = slots - 1;
        this.sinkStrategy = sinkStrategy;
        Arrays.fill(this.values, this.noEntryKeyValue);
    }

    public boolean add(long key1, long key2) {
        if (key1 == this.noEntryKeyValue && key2 == this.noEntryKeyValue) {
            throw new IllegalArgumentException("keys cannot be NO_ENTRY_KEY (" + this.noEntryKeyValue + ")");
        }
        int slot = this.keySlot(key1, key2);
        if (slot < 0) {
            return false;
        }
        this.addAt(slot, key1, key2);
        return true;
    }

    public void addAt(int slot, long key1, long key2) {
        this.set(slot, key1, key2);
        if (++this.size == this.capacity) {
            this.rehash();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, this.noEntryKeyValue);
        this.size = 0;
    }

    public boolean contains(long key1, long key2) {
        return this.keySlot(key1, key2) < 0;
    }

    public int keySlot(long key1, long key2) {
        int hash = Hash.hash(key1, key2);
        int slot = hash & this.mask;
        return this.probe(key1, key2, slot);
    }

    public int size() {
        return this.size;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[');
        boolean pastFirst = false;
        int n = this.values.length;
        for (int i = 0; i < n; i += 2) {
            long key1 = this.values[i];
            long key2 = this.values[i + 1];
            if (key1 == this.noEntryKeyValue && key2 == this.noEntryKeyValue) continue;
            if (pastFirst) {
                sink.put(',');
            }
            this.sinkStrategy.put(key1, key2, sink);
            pastFirst = true;
        }
        sink.put(']');
    }

    private static long firstValue(long[] val, int slot) {
        return val[slot * 2];
    }

    private static long secondValue(long[] val, int slot) {
        return val[slot * 2 + 1];
    }

    private int probe(long key1, long key2, int slot) {
        while (LongLongHashSet.firstValue(this.values, slot) != this.noEntryKeyValue || LongLongHashSet.secondValue(this.values, slot) != this.noEntryKeyValue) {
            if (LongLongHashSet.firstValue(this.values, slot) == key1 && LongLongHashSet.secondValue(this.values, slot) == key2) {
                return -slot - 1;
            }
            slot = slot + 1 & this.mask;
        }
        return slot;
    }

    private void rehash() {
        int newCapacity = this.capacity * 2;
        int slots = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        if (slots < 0 || slots * 2 < 0) {
            throw new IllegalStateException("cannot rehash, required capacity is too large. [current-capacity=" + this.capacity + ", load-factor=" + this.loadFactor + "]");
        }
        long[] newValues = new long[2 * slots];
        Arrays.fill(newValues, this.noEntryKeyValue);
        this.mask = slots - 1;
        long[] oldKeys = this.values;
        this.values = newValues;
        int oldSlots = oldKeys.length / 2;
        for (int i = 0; i < oldSlots; ++i) {
            long key1 = LongLongHashSet.firstValue(oldKeys, i);
            long key2 = LongLongHashSet.secondValue(oldKeys, i);
            if (key1 == this.noEntryKeyValue && key2 == this.noEntryKeyValue) continue;
            int slot = this.keySlot(key1, key2);
            this.set(slot, key1, key2);
        }
        this.capacity = newCapacity;
    }

    private void set(int slot, long key1, long key2) {
        this.values[slot * 2] = key1;
        this.values[slot * 2 + 1] = key2;
    }

    public static interface SinkStrategy {
        public void put(long var1, long var3, CharSink var5);
    }
}

