/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import java.util.Arrays;

public class DoubleList
implements Mutable,
Sinkable {
    public static final double DEFAULT_NO_ENTRY_VALUE = -1.0;
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final double noEntryValue;
    private double[] data;
    private int pos = 0;

    public DoubleList() {
        this(16);
    }

    public DoubleList(int capacity) {
        this(capacity, -1.0);
    }

    public DoubleList(int capacity, double noEntryValue) {
        this.data = new double[capacity];
        this.noEntryValue = noEntryValue;
    }

    public DoubleList(DoubleList other) {
        this.data = new double[Math.max(other.size(), 16)];
        this.setPos(other.size());
        System.arraycopy(other.data, 0, this.data, 0, this.pos);
        this.noEntryValue = other.noEntryValue;
    }

    public DoubleList(double[] other) {
        this.data = new double[other.length];
        this.setPos(other.length);
        System.arraycopy(other, 0, this.data, 0, this.pos);
        this.noEntryValue = -1.0;
    }

    public void add(double value) {
        this.ensureCapacity(this.pos + 1);
        this.data[this.pos++] = value;
    }

    public void add(int index, double element) {
        this.ensureCapacity(++this.pos);
        System.arraycopy(this.data, index, this.data, index + 1, this.pos - index - 1);
        this.data[index] = element;
    }

    public int binarySearch(double value, int scanDir) {
        int low = 0;
        int high = this.pos - 1;
        while (high - low > 65) {
            int mid = (low + high) / 2;
            double midVal = this.data[mid];
            int cmp = Numbers.compare(midVal, value);
            if (cmp < 0) {
                low = mid;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return scanDir == -1 ? this.scrollUp(mid, midVal) : this.scrollDown(mid, high, midVal);
        }
        return scanDir == -1 ? this.scanUp(value, low, high + 1) : this.scanDown(value, low, high + 1);
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative capacity. Integer overflow may be?");
        }
        int l = this.data.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            double[] buf = new double[newCap];
            System.arraycopy(this.data, 0, buf, 0, l);
            this.data = buf;
        }
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DoubleList && this.equals((DoubleList)that);
    }

    public void erase() {
        this.pos = 0;
        Arrays.fill(this.data, this.noEntryValue);
    }

    public void extendAndSet(int index, double value) {
        this.ensureCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.data[index] = value;
    }

    public void fill(int from, int to, double value) {
        Arrays.fill(this.data, from, to, value);
    }

    public double get(int index) {
        if (index < this.pos) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public double getLast() {
        if (this.pos > 0) {
            return this.data[this.pos - 1];
        }
        return this.noEntryValue;
    }

    public double getQuick(int index) {
        return this.data[index];
    }

    public int hashCode() {
        long hashCode = 1L;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            double v = this.getQuick(i);
            hashCode = 31L * hashCode + (v == this.noEntryValue ? 0L : Double.doubleToLongBits(v));
        }
        return (int)hashCode;
    }

    public int indexOf(double o) {
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (!Numbers.equals(o, this.getQuick(i))) continue;
            return i;
        }
        return -1;
    }

    public void remove(double v) {
        int index = this.indexOf(v);
        if (index > -1) {
            this.removeIndex(index);
        }
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, move);
        }
        this.data[--this.pos] = this.noEntryValue;
    }

    public void reverse() {
        int n = this.size();
        int m = n / 2;
        for (int i = 0; i < m; ++i) {
            double tmp = this.data[i];
            this.data[i] = this.data[n - i - 1];
            this.data[n - i - 1] = tmp;
        }
    }

    public void set(int index, double element) {
        if (index < this.pos) {
            this.data[index] = element;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, double value) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.data, value);
    }

    public void setLast(double value) {
        if (this.pos > 0) {
            this.data[this.pos - 1] = value;
        }
    }

    public final void setPos(int pos) {
        this.ensureCapacity(pos);
        this.pos = pos;
    }

    public void setQuick(int index, double value) {
        assert (index < this.pos);
        this.data[index] = value;
    }

    public int size() {
        return this.pos;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size());
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[');
        int k = this.pos;
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sink.put(',');
            }
            sink.put(this.get(i));
        }
        sink.put(']');
    }

    public void toSink(CharSink sink, double exceptValue) {
        sink.put('[');
        boolean pastFirst = false;
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            double val = this.get(i);
            if (Numbers.equals(val, exceptValue)) continue;
            if (pastFirst) {
                sink.put(',');
            }
            sink.put(val);
            pastFirst = true;
        }
        sink.put(']');
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalBuilder();
        this.toSink(sb);
        return ((Object)sb).toString();
    }

    private boolean equals(DoubleList that) {
        if (this.pos != that.pos) {
            return false;
        }
        if (Numbers.compare(this.noEntryValue, that.noEntryValue) != 0) {
            return false;
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (Numbers.compare(this.getQuick(i), that.getQuick(i)) == 0) continue;
            return false;
        }
        return true;
    }

    private int scanDown(double value, int low, int high) {
        for (int i = high - 1; i >= low; --i) {
            double that = this.data[i];
            int cmp = Numbers.compare(that, value);
            if (cmp == 0) {
                return i;
            }
            if (cmp >= 0) continue;
            return -(i + 2);
        }
        return -(low + 1);
    }

    private int scanUp(double value, int low, int high) {
        for (int i = low; i < high; ++i) {
            double that = this.data[i];
            int cmp = Numbers.compare(that, value);
            if (cmp == 0) {
                return i;
            }
            if (cmp <= 0) continue;
            return -(i + 1);
        }
        return -(high + 1);
    }

    private int scrollDown(int low, int high, double value) {
        do {
            if (low < high) continue;
            return low;
        } while (Numbers.compare(this.data[++low], value) == 0);
        return low - 1;
    }

    private int scrollUp(int high, double value) {
        do {
            if (high > 0) continue;
            return 0;
        } while (Numbers.compare(this.data[--high], value) == 0);
        return high + 1;
    }
}

