/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.metrics.LongGauge;
import io.questdb.metrics.NullLongGauge;
import io.questdb.std.Chars;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.io.Closeable;

public class AssociativeCache<V>
implements Closeable,
Mutable {
    private static final int MIN_BLOCKS = 1;
    private static final int MIN_ROWS = 1;
    private static final int NOT_FOUND = -1;
    private final int blocks;
    private final int bmask;
    private final int bshift;
    private final LongGauge cachedGauge;
    private final CharSequence[] keys;
    private final int rmask;
    private final V[] values;

    public AssociativeCache(int blocks, int rows) {
        this(blocks, rows, NullLongGauge.INSTANCE);
    }

    public AssociativeCache(int blocks, int rows, LongGauge cachedGauge) {
        this.blocks = Math.max(1, Numbers.ceilPow2(blocks));
        rows = Math.max(1, Numbers.ceilPow2(rows));
        int size = rows * this.blocks;
        if (size < 0) {
            throw new OutOfMemoryError();
        }
        this.keys = new CharSequence[size];
        this.values = new Object[size];
        this.rmask = rows - 1;
        this.bmask = this.blocks - 1;
        this.bshift = Numbers.msb(this.blocks);
        this.cachedGauge = cachedGauge;
    }

    @Override
    public void clear() {
        long freed = 0L;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == null) continue;
            this.keys[i] = null;
            if (this.values[i] == null) continue;
            this.values[i] = Misc.freeIfCloseable(this.values[i]);
            ++freed;
        }
        this.cachedGauge.add(-freed);
    }

    @Override
    public void close() {
        this.clear();
    }

    public V peek(CharSequence key) {
        int index = this.getIndex(key);
        if (index != -1) {
            return this.values[index];
        }
        return null;
    }

    public V poll(CharSequence key) {
        int index = this.getIndex(key);
        if (index == -1) {
            return null;
        }
        V value = this.values[index];
        this.values[index] = null;
        if (value != null) {
            this.cachedGauge.dec();
        }
        return value;
    }

    public CharSequence put(CharSequence key, V value) {
        int lo = this.lo(key);
        if (Chars.equalsNc(key, this.keys[lo])) {
            if (this.values[lo] != value) {
                if (this.values[lo] == null) {
                    this.cachedGauge.inc();
                } else {
                    Misc.freeIfCloseable(this.values[lo]);
                }
                this.values[lo] = value;
            }
            return null;
        }
        CharSequence outgoingKey = this.keys[lo + this.bmask];
        if (outgoingKey != null) {
            int idx = lo + this.bmask;
            if (this.values[idx] == null) {
                this.cachedGauge.inc();
            } else {
                this.values[idx] = Misc.freeIfCloseable(this.values[idx]);
            }
        } else {
            this.cachedGauge.inc();
        }
        System.arraycopy(this.keys, lo, this.keys, lo + 1, this.bmask);
        System.arraycopy(this.values, lo, this.values, lo + 1, this.bmask);
        this.keys[lo] = value == null ? null : Chars.toString(key);
        this.values[lo] = value;
        return outgoingKey;
    }

    private int getIndex(CharSequence key) {
        int lo;
        int hi = lo + this.blocks;
        for (int i = lo = this.lo(key); i < hi; ++i) {
            CharSequence k = this.keys[i];
            if (k == null) {
                return -1;
            }
            if (!Chars.equals(k, key)) continue;
            return i;
        }
        return -1;
    }

    private int lo(CharSequence key) {
        return (Hash.spread(Chars.hashCode(key)) & this.rmask) << this.bshift;
    }
}

