/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IODispatcherLinux;
import io.questdb.network.IODispatcherOsx;
import io.questdb.network.IODispatcherWindows;
import io.questdb.std.Os;

public class IODispatchers {
    private IODispatchers() {
    }

    public static <C extends IOContext<C>> IODispatcher<C> create(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        switch (Os.type) {
            case 2: 
            case 4: {
                return new IODispatcherLinux<C>(configuration, ioContextFactory);
            }
            case 1: 
            case 5: 
            case 6: {
                return new IODispatcherOsx<C>(configuration, ioContextFactory);
            }
            case 3: {
                return new IODispatcherWindows<C>(configuration, ioContextFactory);
            }
        }
        throw new RuntimeException();
    }
}

