/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.EpollFacade;
import io.questdb.network.KqueueFacade;
import io.questdb.network.NetworkFacade;
import io.questdb.network.SelectFacade;
import io.questdb.std.Numbers;
import io.questdb.std.Os;
import io.questdb.std.datetime.millitime.MillisecondClock;

public interface IODispatcherConfiguration {
    public static final int BIAS_READ = 1;
    public static final int BIAS_WRITE = 2;

    public int getBindIPv4Address();

    public int getBindPort();

    public MillisecondClock getClock();

    default public String getDispatcherLogName() {
        return "IODispatcher";
    }

    public EpollFacade getEpollFacade();

    default public int getEventCapacity() {
        return Numbers.ceilPow2(this.getLimit());
    }

    default public boolean getHint() {
        return false;
    }

    default public int getIOQueueCapacity() {
        return Numbers.ceilPow2(this.getLimit());
    }

    public int getInitialBias();

    default public int getInterestQueueCapacity() {
        return Numbers.ceilPow2(this.getLimit());
    }

    public KqueueFacade getKqueueFacade();

    public int getLimit();

    default public int getListenBacklog() {
        if (Os.isWindows() && this.getHint()) {
            return -this.getLimit();
        }
        return this.getLimit();
    }

    public NetworkFacade getNetworkFacade();

    default public boolean getPeerNoLinger() {
        return false;
    }

    public long getQueueTimeout();

    public int getRcvBufSize();

    public SelectFacade getSelectFacade();

    public int getSndBufSize();

    public int getTestConnectionBufferSize();

    public long getTimeout();

    public long getHeartbeatInterval();
}

