/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.IODispatcher;
import io.questdb.network.SuspendEvent;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;

public abstract class IOContext<T extends IOContext<T>>
implements Mutable,
QuietCloseable {
    protected IODispatcher<T> dispatcher;
    protected int fd = -1;
    protected long heartbeatId = -1L;

    @Override
    public void clear() {
        this.heartbeatId = -1L;
        this.fd = -1;
        this.dispatcher = null;
    }

    public void clearSuspendEvent() {
    }

    public long getAndResetHeartbeatId() {
        long id = this.heartbeatId;
        this.heartbeatId = -1L;
        return id;
    }

    public IODispatcher<T> getDispatcher() {
        return this.dispatcher;
    }

    public int getFd() {
        return this.fd;
    }

    public SuspendEvent getSuspendEvent() {
        return null;
    }

    public boolean invalid() {
        return this.fd == -1;
    }

    public T of(int fd, IODispatcher<T> dispatcher) {
        this.fd = fd;
        this.dispatcher = dispatcher;
        return (T)this;
    }

    public void setHeartbeatId(long heartbeatId) {
        this.heartbeatId = heartbeatId;
    }
}

