/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.LongGauge;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.MemoryTag;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;

public class MemoryTagLongGauge
implements LongGauge {
    private static final String MEMORY_TAG_PREFIX = "memory_tag_";
    private final int memoryTag;

    public MemoryTagLongGauge(int memoryTag) {
        assert (memoryTag >= 0 && memoryTag < 54);
        this.memoryTag = memoryTag;
    }

    @Override
    public void add(long value) {
    }

    @Override
    public void dec() {
    }

    public String getName() {
        return MemoryTag.nameOf(this.memoryTag);
    }

    @Override
    public long getValue() {
        return Unsafe.getMemUsedByTag(this.memoryTag);
    }

    @Override
    public void inc() {
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        this.appendType(sink);
        this.appendMetricName(sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, this.getValue());
        PrometheusFormatUtils.appendNewLine(sink);
    }

    @Override
    public void setValue(long value) {
    }

    private void appendMetricName(CharSink sink) {
        sink.put(PrometheusFormatUtils.METRIC_NAME_PREFIX);
        sink.put(MEMORY_TAG_PREFIX);
        sink.put(this.getName());
    }

    private void appendType(CharSink sink) {
        sink.put(PrometheusFormatUtils.TYPE_PREFIX);
        sink.put(MEMORY_TAG_PREFIX);
        sink.put(this.getName());
        sink.put(" gauge\n");
    }
}

