/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.DoubleGauge;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.metrics.Scrapable;
import io.questdb.std.str.CharSink;

public class DoubleGaugeImpl
implements Scrapable,
DoubleGauge {
    private final CharSequence name;
    private volatile double value;

    public DoubleGaugeImpl(CharSequence name) {
        this.name = name;
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        this.appendType(sink);
        this.appendMetricName(sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, this.value);
        PrometheusFormatUtils.appendNewLine(sink);
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    private void appendMetricName(CharSink sink) {
        sink.put(PrometheusFormatUtils.METRIC_NAME_PREFIX);
        sink.put(this.name);
    }

    private void appendType(CharSink sink) {
        sink.put(PrometheusFormatUtils.TYPE_PREFIX);
        sink.put(this.name);
        sink.put(" gauge\n");
    }
}

