/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.str.SizePrettyFunctionFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.util.Comparator;

public class ShowPartitionsRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final Comparator<String> CHAR_COMPARATOR = Chars::compare;
    private static final Log LOG = LogFactory.getLog(ShowPartitionsRecordCursor.class);
    private static final RecordMetadata METADATA;
    private final ShowPartitionsRecordCursor cursor = new ShowPartitionsRecordCursor();
    private final Path path = new Path();
    private final TableToken tableToken;
    private CairoConfiguration cairoConfig;
    private SqlExecutionContext executionContext;
    private FilesFacade ff;

    public ShowPartitionsRecordCursorFactory(TableToken tableToken) {
        super(METADATA);
        this.tableToken = tableToken;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.cairoConfig = executionContext.getCairoEngine().getConfiguration();
        this.ff = this.cairoConfig.getFilesFacade();
        return this.cursor.initialize();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("show_partitions").meta("of").val(this.tableToken);
    }

    @Override
    protected void _close() {
        Misc.free(this.path);
        Misc.free(this.cursor);
        this.executionContext = null;
        this.cairoConfig = null;
        this.ff = null;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(Column.PARTITION_INDEX.metadata());
        metadata.add(Column.PARTITION_BY.metadata());
        metadata.add(Column.PARTITION_NAME.metadata());
        metadata.add(Column.MIN_TIMESTAMP.metadata());
        metadata.add(Column.MAX_TIMESTAMP.metadata());
        metadata.add(Column.NUM_ROWS.metadata());
        metadata.add(Column.DISK_SIZE.metadata());
        metadata.add(Column.DISK_SIZE_HUMAN.metadata());
        metadata.add(Column.IS_READ_ONLY.metadata());
        metadata.add(Column.IS_ACTIVE.metadata());
        metadata.add(Column.IS_ATTACHED.metadata());
        metadata.add(Column.IS_DETACHED.metadata());
        metadata.add(Column.IS_ATTACHABLE.metadata());
        METADATA = metadata;
    }

    private class ShowPartitionsRecordCursor
    implements NoRandomAccessRecordCursor {
        private final ObjList<String> attachablePartitions = new ObjList(4);
        private final ObjList<String> detachedPartitions = new ObjList(8);
        private final StringSink partitionName = new StringSink();
        private final PartitionsRecord partitionRecord = new PartitionsRecord();
        private final StringSink partitionSizeSink = new StringSink();
        private TableReaderMetadata detachedMetaReader;
        private TxReader detachedTxReader;
        private int dynamicPartitionIndex = -1;
        private boolean isActive;
        private boolean isAttachable;
        private boolean isDetached;
        private boolean isReadOnly;
        private int limit;
        private long maxTimestamp = Long.MIN_VALUE;
        private long minTimestamp = Long.MIN_VALUE;
        private long numRows = -1L;
        private int partitionBy = -1;
        private int partitionIndex = -1;
        private long partitionSize = -1L;
        private int rootLen;
        private TableReader tableReader;
        private CharSequence tsColName;

        private ShowPartitionsRecordCursor() {
        }

        @Override
        public void close() {
            this.detachedMetaReader = Misc.free(this.detachedMetaReader);
            this.detachedTxReader = Misc.free(this.detachedTxReader);
            this.attachablePartitions.clear();
            this.detachedPartitions.clear();
            this.partitionName.clear();
            this.partitionRecord.close();
            this.tableReader = Misc.free(this.tableReader);
            this.partitionSizeSink.clear();
        }

        @Override
        public Record getRecord() {
            return this.partitionRecord;
        }

        @Override
        public boolean hasNext() {
            if (++this.partitionIndex < this.limit) {
                this.loadNextPartition();
                return true;
            }
            --this.partitionIndex;
            return false;
        }

        @Override
        public long size() {
            return this.limit;
        }

        @Override
        public void toTop() {
            this.partitionIndex = -1;
        }

        private ShowPartitionsRecordCursor initialize() {
            if (this.tableReader != null) {
                return this;
            }
            this.tsColName = null;
            this.tableReader = ShowPartitionsRecordCursorFactory.this.executionContext.getReader(ShowPartitionsRecordCursorFactory.this.tableToken);
            this.partitionBy = this.tableReader.getPartitionedBy();
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                TableReaderMetadata meta = this.tableReader.getMetadata();
                this.tsColName = meta.getColumnName(meta.getTimestampIndex());
            }
            ShowPartitionsRecordCursorFactory.this.path.of(ShowPartitionsRecordCursorFactory.this.cairoConfig.getRoot()).concat(ShowPartitionsRecordCursorFactory.this.tableToken).$();
            this.rootLen = ShowPartitionsRecordCursorFactory.this.path.length();
            this.scanDetachedAndAttachablePartitions();
            this.limit = this.tableReader.getTxFile().getPartitionCount() + this.attachablePartitions.size() + this.detachedPartitions.size();
            this.toTop();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void loadNextPartition() {
            this.isReadOnly = false;
            this.isActive = false;
            this.isDetached = false;
            this.isAttachable = false;
            this.minTimestamp = -9223372036854775808L;
            this.maxTimestamp = -9223372036854775808L;
            this.numRows = -1L;
            this.partitionSize = -1L;
            this.partitionName.clear();
            this.dynamicPartitionIndex = this.partitionIndex;
            dynamicTsColName = this.tsColName;
            ShowPartitionsRecordCursorFactory.this.path.trimTo(this.rootLen).$();
            tableTxReader = this.tableReader.getTxFile();
            partitionCount = tableTxReader.getPartitionCount();
            if (this.partitionIndex < partitionCount) {
                this.isReadOnly = tableTxReader.isPartitionReadOnly(this.partitionIndex);
                timestamp = tableTxReader.getPartitionTimestampByIndex(this.partitionIndex);
                this.isActive = timestamp == tableTxReader.getLastPartitionTimestamp();
                PartitionBy.setSinkForPartition(this.partitionName, this.partitionBy, timestamp);
                TableUtils.setPathForPartition(ShowPartitionsRecordCursorFactory.this.path, this.partitionBy, timestamp, tableTxReader.getPartitionNameTxn(this.partitionIndex));
                this.numRows = tableTxReader.getPartitionSize(this.partitionIndex);
            } else {
                this.isDetached = true;
                idx = this.partitionIndex - partitionCount;
                n = this.detachedPartitions.size();
                if (idx < n) {
                    this.partitionName.put(this.detachedPartitions.get(idx));
                } else if ((idx -= n) < this.attachablePartitions.size()) {
                    this.partitionName.put(this.attachablePartitions.get(idx));
                    this.isAttachable = true;
                }
                if (!ShowPartitionsRecordCursor.$assertionsDisabled && this.partitionName.length() == 0) {
                    throw new AssertionError();
                }
                this.dynamicPartitionIndex = -2147483648;
                if (ShowPartitionsRecordCursorFactory.this.ff.exists(ShowPartitionsRecordCursorFactory.this.path.concat(this.partitionName).concat("_meta").$())) {
                    try {
                        if (this.detachedMetaReader == null) {
                            this.detachedMetaReader = new TableReaderMetadata(ShowPartitionsRecordCursorFactory.this.cairoConfig);
                        }
                        this.detachedMetaReader.load(ShowPartitionsRecordCursorFactory.this.path);
                        if (ShowPartitionsRecordCursorFactory.this.tableToken.getTableId() == this.detachedMetaReader.getTableId() && this.partitionBy == this.detachedMetaReader.getPartitionBy()) {
                            if (ShowPartitionsRecordCursorFactory.this.ff.exists(ShowPartitionsRecordCursorFactory.this.path.parent().concat("_txn").$())) {
                                try {
                                    if (this.detachedTxReader == null) {
                                        this.detachedTxReader = new TxReader(FilesFacadeImpl.INSTANCE);
                                    }
                                    this.detachedTxReader.ofRO(ShowPartitionsRecordCursorFactory.this.path, this.partitionBy);
                                    this.detachedTxReader.unsafeLoadAll();
                                    length = this.partitionName.indexOf(".");
                                    if (length < 0) {
                                        length = this.partitionName.length();
                                    }
                                    timestamp = PartitionBy.parsePartitionDirName(this.partitionName, this.partitionBy, 0, length);
                                    pIndex = this.detachedTxReader.getPartitionIndex(timestamp);
                                    this.numRows = this.detachedTxReader.getPartitionSize(pIndex);
                                    if (!PartitionBy.isPartitioned(this.partitionBy) || this.numRows <= 0L) ** GOTO lbl75
                                    tsIndex = this.detachedMetaReader.getTimestampIndex();
                                    dynamicTsColName = this.detachedMetaReader.getColumnName(tsIndex);
                                }
                                finally {
                                    if (this.detachedTxReader != null) {
                                        this.detachedTxReader.clear();
                                    }
                                }
                            }
                            ShowPartitionsRecordCursorFactory.LOG.error().$("detached partition does not have meta file [path=").$(ShowPartitionsRecordCursorFactory.this.path).I$();
                        }
                        ShowPartitionsRecordCursorFactory.LOG.error().$("detached partition meta does not match [path=").$(ShowPartitionsRecordCursorFactory.this.path).I$();
                    }
                    finally {
                        if (this.detachedMetaReader != null) {
                            this.detachedMetaReader.clear();
                        }
                    }
                } else {
                    ShowPartitionsRecordCursorFactory.LOG.error().$("detached partition does not have meta file [path=").$(ShowPartitionsRecordCursorFactory.this.path).I$();
                }
lbl75:
                // 5 sources

                ShowPartitionsRecordCursorFactory.this.path.parent();
            }
            this.partitionSize = ShowPartitionsRecordCursorFactory.this.ff.getDirSize(ShowPartitionsRecordCursorFactory.this.path.$());
            this.partitionSizeSink.clear();
            SizePrettyFunctionFactory.toSizePretty(this.partitionSizeSink, this.partitionSize);
            if (PartitionBy.isPartitioned(this.partitionBy) && this.numRows > 0L) {
                TableUtils.dFile(ShowPartitionsRecordCursorFactory.this.path.slash$(), dynamicTsColName, -1L);
                fd = -1;
                try {
                    fd = TableUtils.openRO(ShowPartitionsRecordCursorFactory.this.ff, ShowPartitionsRecordCursorFactory.this.path, ShowPartitionsRecordCursorFactory.LOG);
                    lastOffset = (this.numRows - 1L) * (long)ColumnType.sizeOf(8);
                    this.minTimestamp = ShowPartitionsRecordCursorFactory.this.ff.readNonNegativeLong(fd, 0L);
                    this.maxTimestamp = ShowPartitionsRecordCursorFactory.this.ff.readNonNegativeLong(fd, lastOffset);
                }
                catch (CairoException e) {
                    this.dynamicPartitionIndex = -2147483648;
                    ShowPartitionsRecordCursorFactory.LOG.error().$("no file found for designated timestamp column [path=").$(ShowPartitionsRecordCursorFactory.this.path).I$();
                }
                finally {
                    if (fd != -1) {
                        ShowPartitionsRecordCursorFactory.this.ff.close(fd);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanDetachedAndAttachablePartitions() {
            long pFind = ShowPartitionsRecordCursorFactory.this.ff.findFirst(ShowPartitionsRecordCursorFactory.this.path);
            if (pFind > 0L) {
                try {
                    this.attachablePartitions.clear();
                    this.detachedPartitions.clear();
                    do {
                        this.partitionName.clear();
                        long name = ShowPartitionsRecordCursorFactory.this.ff.findName(pFind);
                        Chars.utf8ToUtf16Z(name, this.partitionName);
                        int type = ShowPartitionsRecordCursorFactory.this.ff.findType(pFind);
                        if ((type == 10 || type == 4) && Chars.endsWith((CharSequence)this.partitionName, ".attachable")) {
                            this.attachablePartitions.add(Chars.toString(this.partitionName));
                            continue;
                        }
                        if (type != 4 || !CairoKeywords.isDetachedDirMarker(name)) continue;
                        this.detachedPartitions.add(Chars.toString(this.partitionName));
                    } while (ShowPartitionsRecordCursorFactory.this.ff.findNext(pFind) > 0);
                    this.attachablePartitions.sort(CHAR_COMPARATOR);
                    this.detachedPartitions.sort(CHAR_COMPARATOR);
                }
                finally {
                    ShowPartitionsRecordCursorFactory.this.ff.findClose(pFind);
                }
            }
        }

        private class PartitionsRecord
        implements Record,
        Closeable {
            private PartitionsRecord() {
            }

            @Override
            public void close() {
            }

            @Override
            public boolean getBool(int col) {
                switch (col) {
                    case 8: {
                        return ShowPartitionsRecordCursor.this.isReadOnly;
                    }
                    case 9: {
                        return ShowPartitionsRecordCursor.this.isActive;
                    }
                    case 10: {
                        return ShowPartitionsRecordCursor.this.isReadOnly || !ShowPartitionsRecordCursor.this.isDetached;
                    }
                    case 11: {
                        return ShowPartitionsRecordCursor.this.isDetached;
                    }
                    case 12: {
                        return ShowPartitionsRecordCursor.this.isAttachable;
                    }
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public int getInt(int col) {
                if (Column.PARTITION_INDEX.is(col)) {
                    return ShowPartitionsRecordCursor.this.dynamicPartitionIndex;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public long getLong(int col) {
                switch (col) {
                    case 3: {
                        return ShowPartitionsRecordCursor.this.minTimestamp;
                    }
                    case 4: {
                        return ShowPartitionsRecordCursor.this.maxTimestamp;
                    }
                    case 5: {
                        return ShowPartitionsRecordCursor.this.numRows;
                    }
                    case 6: {
                        return ShowPartitionsRecordCursor.this.partitionSize;
                    }
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getStr(int col) {
                switch (col) {
                    case 1: {
                        return PartitionBy.toString(ShowPartitionsRecordCursor.this.partitionBy);
                    }
                    case 2: {
                        return ShowPartitionsRecordCursor.this.partitionName;
                    }
                    case 7: {
                        return ShowPartitionsRecordCursor.this.partitionSizeSink;
                    }
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                CharSequence s = this.getStr(col);
                return s != null ? s.length() : -1;
            }

            @Override
            public long getTimestamp(int col) {
                switch (col) {
                    case 3: {
                        return ShowPartitionsRecordCursor.this.minTimestamp;
                    }
                    case 4: {
                        return ShowPartitionsRecordCursor.this.maxTimestamp;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    private static enum Column {
        PARTITION_INDEX(0, "index", 5),
        PARTITION_BY(1, "partitionBy", 11),
        PARTITION_NAME(2, "name", 11),
        MIN_TIMESTAMP(3, "minTimestamp", 8),
        MAX_TIMESTAMP(4, "maxTimestamp", 8),
        NUM_ROWS(5, "numRows", 6),
        DISK_SIZE(6, "diskSize", 6),
        DISK_SIZE_HUMAN(7, "diskSizeHuman", 11),
        IS_READ_ONLY(8, "readOnly", 1),
        IS_ACTIVE(9, "active", 1),
        IS_ATTACHED(10, "attached", 1),
        IS_DETACHED(11, "detached", 1),
        IS_ATTACHABLE(12, "attachable", 1);

        private final int idx;
        private final TableColumnMetadata metadata;

        private Column(int idx, String name, int type) {
            this.idx = idx;
            this.metadata = new TableColumnMetadata(name, type);
        }

        boolean is(int idx) {
            return this.idx == idx;
        }

        TableColumnMetadata metadata() {
            return this.metadata;
        }
    }
}

