/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.SelectedRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.Nullable;

public class SelectedRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final IntList columnCrossIndex;
    private final SelectedRecordCursor cursor;
    private SelectedPageFrameCursor pageFrameCursor;

    public SelectedRecordCursorFactory(RecordMetadata metadata, IntList columnCrossIndex, RecordCursorFactory base) {
        super(metadata);
        this.base = base;
        this.columnCrossIndex = columnCrossIndex;
        this.cursor = new SelectedRecordCursor(columnCrossIndex, base.recordCursorSupportsRandomAccess());
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.base.followedLimitAdvice();
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(this.base.getCursor(executionContext));
        return this.cursor;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        PageFrameCursor baseCursor = this.base.getPageFrameCursor(executionContext, order);
        if (baseCursor == null) {
            return null;
        }
        if (this.pageFrameCursor == null) {
            this.pageFrameCursor = new SelectedPageFrameCursor(this.columnCrossIndex);
        }
        return this.pageFrameCursor.of(baseCursor);
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean implementsLimit() {
        return this.base.implementsLimit();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean supportPageFrameCursor() {
        return this.base.supportPageFrameCursor();
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.base.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("SelectedRecord");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    private static class SelectedPageFrameCursor
    implements PageFrameCursor {
        private final IntList columnCrossIndex;
        private final SelectedPageFrame pageFrame;
        private PageFrameCursor baseCursor;

        private SelectedPageFrameCursor(IntList columnCrossIndex) {
            this.columnCrossIndex = columnCrossIndex;
            this.pageFrame = new SelectedPageFrame(columnCrossIndex);
        }

        @Override
        public void close() {
            this.baseCursor.close();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getUpdateRowId(long rowIndex) {
            return this.baseCursor.getUpdateRowId(rowIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        @Nullable
        public PageFrame next() {
            PageFrame baseFrame = this.baseCursor.next();
            return baseFrame != null ? this.pageFrame.of(baseFrame) : null;
        }

        public SelectedPageFrameCursor of(PageFrameCursor baseCursor) {
            this.baseCursor = baseCursor;
            return this;
        }

        @Override
        public long size() {
            return this.baseCursor.size();
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
        }
    }

    private static class SelectedPageFrame
    implements PageFrame {
        private final IntList columnCrossIndex;
        private PageFrame baseFrame;

        private SelectedPageFrame(IntList columnCrossIndex) {
            this.columnCrossIndex = columnCrossIndex;
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int dirForward) {
            return this.baseFrame.getBitmapIndexReader(this.columnCrossIndex.getQuick(columnIndex), dirForward);
        }

        @Override
        public int getColumnShiftBits(int columnIndex) {
            return this.baseFrame.getColumnShiftBits(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getIndexPageAddress(int columnIndex) {
            return this.baseFrame.getIndexPageAddress(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return this.baseFrame.getPageAddress(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getPageSize(int columnIndex) {
            return this.baseFrame.getPageSize(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getPartitionHi() {
            return this.baseFrame.getPartitionHi();
        }

        @Override
        public int getPartitionIndex() {
            return this.baseFrame.getPartitionIndex();
        }

        @Override
        public long getPartitionLo() {
            return this.baseFrame.getPartitionLo();
        }

        public SelectedPageFrame of(PageFrame basePageFrame) {
            this.baseFrame = basePageFrame;
            return this;
        }
    }
}

