/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValuesIndexedRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final IntHashSet deferredSymbolKeys;
    private final IntHashSet found = new IntHashSet();
    private final DirectLongList rows;
    private final IntHashSet symbolKeys;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private long index = 0L;
    private boolean isTreeMapBuilt;
    private int keyCount;

    public LatestByValuesIndexedRecordCursor(int columnIndex, @NotNull IntHashSet symbolKeys, @Nullable IntHashSet deferredSymbolKeys, DirectLongList rows, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.isTreeMapBuilt = true;
        }
        if (this.index > -1L) {
            long rowId = this.rows.get(this.index);
            this.recordA.jumpTo(Rows.toPartitionIndex(rowId), Rows.toLocalRowID(rowId));
            --this.index;
            return true;
        }
        return false;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.keyCount = -1;
        this.rows.clear();
        this.found.clear();
        this.isTreeMapBuilt = false;
    }

    @Override
    public long size() {
        return this.rows.size();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
    }

    @Override
    public void toTop() {
        this.index = this.rows.size() - 1L;
    }

    private void addFoundKey(int symbolKey, BitmapIndexReader indexReader, DataFrame frame, long rowLo, long rowHi) {
        RowCursor cursor;
        int index = this.found.keyIndex(symbolKey);
        if (index > -1 && (cursor = indexReader.getCursor(false, symbolKey, rowLo, rowHi)).hasNext()) {
            long row = Rows.toRowID(frame.getPartitionIndex(), cursor.next());
            this.rows.add(row);
            this.found.addAt(index, symbolKey);
        }
    }

    private void buildTreeMap() {
        DataFrame frame;
        if (this.keyCount < 0) {
            this.keyCount = this.symbolKeys.size();
            if (this.deferredSymbolKeys != null) {
                this.keyCount += this.deferredSymbolKeys.size();
            }
        }
        int frameColumnIndex = this.columnIndexes.getQuick(this.columnIndex);
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < this.keyCount) {
            int symbolKey;
            int i;
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(frameColumnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            int n = this.symbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.symbolKeys.get(i);
                this.addFoundKey(symbolKey, indexReader, frame, rowLo, rowHi);
            }
            if (this.deferredSymbolKeys == null) continue;
            n = this.deferredSymbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.deferredSymbolKeys.get(i);
                if (this.symbolKeys.contains(symbolKey)) continue;
                this.addFoundKey(symbolKey, indexReader, frame, rowLo, rowHi);
            }
        }
        this.index = this.rows.size() - 1L;
    }
}

