/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValuesIndexedFilteredRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final IntHashSet deferredSymbolKeys;
    private final Function filter;
    private final IntHashSet found = new IntHashSet();
    private final DirectLongList rows;
    private final IntHashSet symbolKeys;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private long index;
    private boolean isTreeMapBuilt;
    private int keyCount;
    private long lim;

    public LatestByValuesIndexedFilteredRecordCursor(int columnIndex, DirectLongList rows, @NotNull IntHashSet symbolKeys, @Nullable IntHashSet deferredSymbolKeys, Function filter, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.isTreeMapBuilt = true;
        }
        if (this.index < this.lim) {
            long row = this.rows.get(this.index++);
            this.recordA.jumpTo(Rows.toPartitionIndex(row), Rows.toLocalRowID(row));
            return true;
        }
        return false;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.filter.init(this, executionContext);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.rows.clear();
        this.found.clear();
        this.keyCount = -1;
        this.isTreeMapBuilt = false;
    }

    @Override
    public long size() {
        return this.isTreeMapBuilt ? this.lim : -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.optAttr((CharSequence)"filter", this.filter);
    }

    @Override
    public void toTop() {
        this.index = 0L;
        this.filter.toTop();
    }

    private void addFoundKey(int symbolKey, BitmapIndexReader indexReader, int partitionIndex, long rowLo, long rowHi) {
        int index = this.found.keyIndex(symbolKey);
        if (index > -1) {
            RowCursor cursor = indexReader.getCursor(false, symbolKey, rowLo, rowHi);
            while (cursor.hasNext()) {
                long row = cursor.next();
                this.recordA.setRecordIndex(row);
                if (!this.filter.getBool(this.recordA)) continue;
                this.rows.add(Rows.toRowID(partitionIndex, row));
                this.found.addAt(index, symbolKey);
                break;
            }
        }
    }

    private void buildTreeMap() {
        DataFrame frame;
        if (this.keyCount < 0) {
            this.keyCount = this.symbolKeys.size();
            if (this.deferredSymbolKeys != null) {
                this.keyCount += this.deferredSymbolKeys.size();
            }
        }
        int frameColumnIndex = this.columnIndexes.getQuick(this.columnIndex);
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < this.keyCount) {
            int symbolKey;
            int i;
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int partitionIndex = frame.getPartitionIndex();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(frameColumnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(partitionIndex, 0L);
            int n = this.symbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.symbolKeys.get(i);
                this.addFoundKey(symbolKey, indexReader, partitionIndex, rowLo, rowHi);
            }
            if (this.deferredSymbolKeys == null) continue;
            n = this.deferredSymbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.deferredSymbolKeys.get(i);
                if (this.symbolKeys.contains(symbolKey)) continue;
                this.addFoundKey(symbolKey, indexReader, partitionIndex, rowLo, rowHi);
            }
        }
        this.rows.sortAsUnsigned();
        this.index = 0L;
        this.lim = this.rows.size();
    }
}

