/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValueListRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final Function filter;
    private final boolean restrictedByExcludedValues;
    private final boolean restrictedByIncludedValues;
    private final int shrinkToCapacity;
    private boolean areRecordsFound;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private int currentRow;
    private IntHashSet excludedSymbolKeys;
    private IntHashSet foundKeys;
    private int foundSize;
    private IntHashSet includedSymbolKeys;
    private DirectLongList rowIds;

    public LatestByValueListRecordCursor(int columnIndex, @Nullable Function filter, @NotNull IntList columnIndexes, int shrinkToCapacity, boolean restrictedByIncludedValues, boolean restrictedByExcludedValues) {
        super(columnIndexes);
        this.shrinkToCapacity = shrinkToCapacity;
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.restrictedByIncludedValues = restrictedByIncludedValues;
        this.restrictedByExcludedValues = restrictedByExcludedValues;
        if (restrictedByIncludedValues || restrictedByExcludedValues) {
            this.includedSymbolKeys = new IntHashSet(shrinkToCapacity);
            this.excludedSymbolKeys = new IntHashSet(shrinkToCapacity);
        }
        this.foundKeys = new IntHashSet(shrinkToCapacity);
        this.rowIds = new DirectLongList(shrinkToCapacity, 21);
    }

    @Override
    public void close() {
        super.close();
        if (this.rowIds.getCapacity() > (long)this.shrinkToCapacity) {
            this.rowIds = Misc.free(this.rowIds);
            this.rowIds = new DirectLongList(this.shrinkToCapacity, 21);
            this.foundKeys = new IntHashSet(this.shrinkToCapacity);
        }
    }

    public void destroy() {
        this.rowIds = Misc.free(this.rowIds);
    }

    @Override
    public boolean hasNext() {
        if (!this.areRecordsFound) {
            this.findRecords();
            this.toTop();
            this.areRecordsFound = true;
        }
        if (this.currentRow-- > 0) {
            long rowId = this.rowIds.get(this.currentRow);
            this.recordAt(this.recordA, rowId);
            return true;
        }
        return false;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.circuitBreaker = executionContext.getCircuitBreaker();
        dataFrameCursor.toTop();
        this.foundSize = 0;
        this.foundKeys.clear();
        this.rowIds.clear();
        if (this.filter != null) {
            this.filter.init(this, executionContext);
            this.filter.toTop();
        }
        if (this.restrictedByIncludedValues) {
            if (this.includedSymbolKeys.size() > 0) {
                this.rowIds.setCapacity(this.includedSymbolKeys.size());
            }
        } else if (this.restrictedByExcludedValues) {
            StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.columnIndexes.getQuick(this.columnIndex));
            int distinctSymbols = symbolTable.getSymbolCount();
            if (symbolTable.containsNullValue()) {
                ++distinctSymbols;
            } else if (this.excludedSymbolKeys.contains(Integer.MIN_VALUE)) {
                ++distinctSymbols;
            }
            distinctSymbols = Math.max(0, distinctSymbols - this.excludedSymbolKeys.size());
            this.rowIds.setCapacity(distinctSymbols);
        } else {
            StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.columnIndexes.getQuick(this.columnIndex));
            int distinctSymbols = symbolTable.getSymbolCount();
            if (symbolTable.containsNullValue()) {
                ++distinctSymbols;
            }
            this.rowIds.setCapacity(distinctSymbols);
        }
        this.areRecordsFound = false;
    }

    @Override
    public long size() {
        return this.areRecordsFound ? this.rowIds.size() : -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("FilterOnValueList").meta("on").putColumnName(this.columnIndex);
    }

    @Override
    public void toTop() {
        this.currentRow = (int)this.rowIds.size();
    }

    private void findAllNoFilter(int distinctCount) {
        DataFrame frame;
        assert (this.filter == null);
        while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findAllWithFilter(int distinctCount) {
        DataFrame frame;
        assert (this.filter != null);
        while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.filter.getBool(this.recordA) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findRecords() {
        if (this.restrictedByIncludedValues) {
            if (this.includedSymbolKeys.size() > 0) {
                if (this.filter != null) {
                    this.findRestrictedWithFilter();
                } else {
                    this.findRestrictedNoFilter();
                }
            }
        } else if (this.restrictedByExcludedValues) {
            int distinctSymbols = (int)this.rowIds.getCapacity();
            if (this.filter != null) {
                this.findRestrictedExcludedOnlyWithFilter(distinctSymbols);
            } else {
                this.findRestrictedExcludedOnlyNoFilter(distinctSymbols);
            }
        } else {
            int distinctSymbols = (int)this.rowIds.getCapacity();
            if (distinctSymbols > 0) {
                if (this.filter != null) {
                    this.findAllWithFilter(distinctSymbols);
                } else {
                    this.findAllNoFilter(distinctSymbols);
                }
            }
        }
    }

    private void findRestrictedExcludedOnlyNoFilter(int distinctCount) {
        DataFrame frame;
        assert (this.filter == null);
        while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findRestrictedExcludedOnlyWithFilter(int distinctCount) {
        DataFrame frame;
        assert (this.filter != null);
        while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.filter.getBool(this.recordA) || !this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findRestrictedNoFilter() {
        DataFrame frame;
        assert (this.filter == null);
        int searchSize = this.includedSymbolKeys.size();
        while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.includedSymbolKeys.contains(key) || !this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++this.foundSize != searchSize) continue;
                return;
            }
        }
    }

    private void findRestrictedWithFilter() {
        DataFrame frame;
        assert (this.filter != null);
        int searchSize = this.includedSymbolKeys.size();
        while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.filter.getBool(this.recordA) || !this.includedSymbolKeys.contains(key) || !this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++this.foundSize != searchSize) continue;
                return;
            }
        }
    }

    IntHashSet getExcludedSymbolKeys() {
        return this.excludedSymbolKeys;
    }

    IntHashSet getIncludedSymbolKeys() {
        return this.includedSymbolKeys;
    }
}

