/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValueRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByValueFilteredRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final Function filter;

    public LatestByValueFilteredRecordCursorFactory(RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, int symbolKey, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        this.cursor = filter == null ? new LatestByValueRecordCursor(columnIndex, symbolKey, columnIndexes) : new LatestByValueFilteredRecordCursor(columnIndex, symbolKey, filter, columnIndexes);
        this.filter = filter;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByValueFiltered");
        sink.child(this.cursor);
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }
}

