/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.table.AbstractDescendingRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByAllSymbolsFilteredRecordCursor
extends AbstractDescendingRecordListCursor {
    private static final Function NO_OP_FILTER = BooleanConstant.TRUE;
    private final Function filter;
    private final Map map;
    private final IntList partitionByColumnIndexes;
    private final IntList partitionBySymbolCounts;
    private final RecordSink recordSink;
    private long possibleCombinations;

    public LatestByAllSymbolsFilteredRecordCursor(@NotNull Map map, @NotNull DirectLongList rows, @NotNull RecordSink recordSink, @Nullable Function filter, @NotNull IntList columnIndexes, @NotNull IntList partitionByColumnIndexes, @Nullable IntList partitionBySymbolCounts) {
        super(rows, columnIndexes);
        this.map = map;
        this.recordSink = recordSink;
        this.filter = filter != null ? filter : NO_OP_FILTER;
        this.partitionByColumnIndexes = partitionByColumnIndexes;
        this.partitionBySymbolCounts = partitionBySymbolCounts;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            Misc.free(this.filter);
            Misc.free(this.map);
            super.close();
        }
    }

    public Function getFilter() {
        return this.filter;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isOpen()) {
            this.map.reopen();
        }
        super.of(dataFrameCursor, executionContext);
        this.filter.init(this, executionContext);
        this.possibleCombinations = -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
        sink.attr("expectedSymbolsCount").val(this.countSymbolCombinationsSimple());
    }

    private long countSymbolCombinations() {
        long combinations = 1L;
        int n = this.partitionByColumnIndexes.size();
        for (int i = 0; i < n; ++i) {
            int symbolCount;
            int n2 = symbolCount = this.partitionBySymbolCounts != null ? this.partitionBySymbolCounts.getQuick(i) : Integer.MAX_VALUE;
            assert (symbolCount > 0);
            int columnIndex = this.partitionByColumnIndexes.getQuick(i);
            StaticSymbolTable symbolMapReader = this.dataFrameCursor.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
            int distinctSymbols = symbolMapReader.getSymbolCount();
            if (symbolMapReader.containsNullValue()) {
                ++distinctSymbols;
            }
            try {
                combinations = Math.multiplyExact(combinations, Math.min(symbolCount, distinctSymbols));
                continue;
            }
            catch (ArithmeticException ignore) {
                return Long.MAX_VALUE;
            }
        }
        return combinations;
    }

    private long countSymbolCombinationsSimple() {
        long combinations = 1L;
        int n = this.partitionByColumnIndexes.size();
        for (int i = 0; i < n; ++i) {
            int symbolCount = this.partitionBySymbolCounts != null ? this.partitionBySymbolCounts.getQuick(i) : Integer.MAX_VALUE;
            try {
                combinations = Math.multiplyExact(combinations, symbolCount);
                continue;
            }
            catch (ArithmeticException ignore) {
                return Long.MAX_VALUE;
            }
        }
        return combinations;
    }

    @Override
    protected void buildTreeMap() {
        DataFrame frame;
        if (this.possibleCombinations < 0L) {
            this.possibleCombinations = this.countSymbolCombinations();
        }
        block0: while ((frame = this.dataFrameCursor.next()) != null) {
            int partitionIndex = frame.getPartitionIndex();
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                if (!this.filter.getBool(this.recordA)) continue;
                MapKey key = this.map.withKey();
                key.put(this.recordA, this.recordSink);
                if (!key.create()) continue;
                this.rows.add(Rows.toRowID(partitionIndex, row));
                if (this.rows.size() == this.possibleCombinations) break block0;
            }
        }
        this.map.clear();
    }
}

