/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.DataFrameRecordCursorImpl;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnSubQueryRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final int columnIndex;
    private final IntList columnIndexes;
    private final DataFrameRecordCursorWrapper cursor;
    private final ObjList<RowCursorFactory> cursorFactories;
    private final int[] cursorFactoriesIdx;
    private final IntObjHashMap<RowCursorFactory> factoriesA = new IntObjHashMap(64, 0.5, -5);
    private final IntObjHashMap<RowCursorFactory> factoriesB = new IntObjHashMap(64, 0.5, -5);
    private final Function filter;
    private final Record.CharSequenceFunction func;
    private final RecordCursorFactory recordCursorFactory;

    public FilterOnSubQueryRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull RecordCursorFactory recordCursorFactory, int columnIndex, @Nullable Function filter, @NotNull Record.CharSequenceFunction func, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        this.recordCursorFactory = recordCursorFactory;
        this.filter = filter;
        this.func = func;
        this.cursorFactories = new ObjList();
        this.cursorFactoriesIdx = new int[]{0};
        DataFrameRecordCursorImpl dataFrameRecordCursor = new DataFrameRecordCursorImpl(new HeapRowCursorFactory(this.cursorFactories, this.cursorFactoriesIdx), false, filter, columnIndexes);
        this.cursor = new DataFrameRecordCursorWrapper(dataFrameRecordCursor);
        this.columnIndex = columnIndex;
        this.columnIndexes = columnIndexes;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("FilterOnSubQuery");
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.child(this.recordCursorFactory);
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        this.recordCursorFactory.close();
        this.factoriesA.clear();
        this.factoriesB.clear();
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }

    private class DataFrameRecordCursorWrapper
    implements RecordCursor {
        private final DataFrameRecordCursor delegate;
        private RecordCursor baseCursor;
        private IntObjHashMap<RowCursorFactory> factories;
        private IntObjHashMap<RowCursorFactory> targetFactories;

        private DataFrameRecordCursorWrapper(DataFrameRecordCursor delegate) {
            this.delegate = delegate;
            this.factories = FilterOnSubQueryRecordCursorFactory.this.factoriesA;
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            this.delegate.close();
        }

        @Override
        public Record getRecord() {
            return this.delegate.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.delegate.getRecordB();
        }

        @Override
        public StaticSymbolTable getSymbolTable(int columnIndex) {
            return this.delegate.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.baseCursor != null) {
                this.buildFactories();
                this.baseCursor = Misc.free(this.baseCursor);
            }
            return this.delegate.hasNext();
        }

        @Override
        public boolean isUsingIndex() {
            return this.delegate.isUsingIndex();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.delegate.newSymbolTable(columnIndex);
        }

        public void of(DataFrameCursor cursor, SqlExecutionContext executionContext) throws SqlException {
            if (this.baseCursor != null) {
                this.baseCursor = Misc.free(this.baseCursor);
            }
            this.baseCursor = FilterOnSubQueryRecordCursorFactory.this.recordCursorFactory.getCursor(executionContext);
            this.targetFactories = this.factories == FilterOnSubQueryRecordCursorFactory.this.factoriesA ? FilterOnSubQueryRecordCursorFactory.this.factoriesB : FilterOnSubQueryRecordCursorFactory.this.factoriesA;
            FilterOnSubQueryRecordCursorFactory.this.cursorFactories.clear();
            this.targetFactories.clear();
            this.delegate.of(cursor, executionContext);
            if (FilterOnSubQueryRecordCursorFactory.this.filter != null) {
                FilterOnSubQueryRecordCursorFactory.this.filter.init(this.delegate, executionContext);
            }
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.delegate.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public boolean skipTo(long rowCount) {
            return this.delegate.skipTo(rowCount);
        }

        @Override
        public void toTop() {
            this.delegate.toTop();
        }

        private void buildFactories() {
            StaticSymbolTable symbolTable = this.delegate.getDataFrameCursor().getSymbolTable(FilterOnSubQueryRecordCursorFactory.this.columnIndex);
            Record record = this.baseCursor.getRecord();
            while (this.baseCursor.hasNext()) {
                int targetIndex;
                CharSequence symbol = FilterOnSubQueryRecordCursorFactory.this.func.get(record, 0);
                int symbolKey = symbolTable.keyOf(symbol);
                if (symbolKey == -2 || (targetIndex = this.targetFactories.keyIndex(symbolKey)) <= -1) continue;
                int index = this.factories.keyIndex(symbolKey);
                RowCursorFactory rowCursorFactory = index < 0 ? this.factories.valueAtQuick(index) : (FilterOnSubQueryRecordCursorFactory.this.filter == null ? new SymbolIndexRowCursorFactory(FilterOnSubQueryRecordCursorFactory.this.columnIndex, symbolKey, false, 1, null) : new SymbolIndexFilteredRowCursorFactory(FilterOnSubQueryRecordCursorFactory.this.columnIndex, symbolKey, FilterOnSubQueryRecordCursorFactory.this.filter, false, 1, FilterOnSubQueryRecordCursorFactory.this.columnIndexes, null));
                this.targetFactories.putAt(targetIndex, symbolKey, rowCursorFactory);
                FilterOnSubQueryRecordCursorFactory.this.cursorFactories.add(rowCursorFactory);
            }
            this.factories.clear();
            this.factories = this.targetFactories;
            FilterOnSubQueryRecordCursorFactory.this.cursorFactoriesIdx[0] = FilterOnSubQueryRecordCursorFactory.this.cursorFactories.size();
        }
    }
}

