/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.SingleSymbolFilter;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.DataFrameRecordCursorFactory;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;

public class DeferredSingleSymbolFilterDataFrameRecordCursorFactory
extends DataFrameRecordCursorFactory {
    private final int symbolColumnIndex;
    private final SingleSymbolFilter symbolFilter;
    private final Function symbolFunc;
    private boolean convertedToFrame;
    private int symbolKey;

    public DeferredSingleSymbolFilterDataFrameRecordCursorFactory(@NotNull CairoConfiguration configuration, int tableSymColIndex, Function symbolFunc, RowCursorFactory rowCursorFactory, RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, boolean followsOrderByAdvice, @NotNull IntList columnIndexes, @NotNull IntList columnSizes, boolean supportsRandomAccess) {
        super(configuration, metadata, dataFrameCursorFactory, rowCursorFactory, followsOrderByAdvice, null, false, columnIndexes, columnSizes, supportsRandomAccess);
        this.symbolFunc = symbolFunc;
        this.symbolKey = -2;
        this.symbolColumnIndex = columnIndexes.indexOf(tableSymColIndex, 0, columnIndexes.size());
        this.symbolFilter = new SingleSymbolFilter(){

            @Override
            public int getColumnIndex() {
                return DeferredSingleSymbolFilterDataFrameRecordCursorFactory.this.symbolColumnIndex;
            }

            @Override
            public int getSymbolFilterKey() {
                return DeferredSingleSymbolFilterDataFrameRecordCursorFactory.this.symbolKey;
            }
        };
    }

    @Override
    public SingleSymbolFilter convertToSampleByIndexDataFrameCursorFactory() {
        this.convertedToFrame = true;
        return this.symbolFilter;
    }

    @Override
    public String getBaseColumnName(int idx) {
        return this.dataFrameCursorFactory.getMetadata().getColumnName(idx);
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        assert (this.convertedToFrame);
        DataFrameCursor dataFrameCursor = this.dataFrameCursorFactory.getCursor(executionContext, order);
        this.initFwdPageFrameCursor(executionContext, dataFrameCursor);
        if (this.symbolKey == -2) {
            CharSequence symbol = this.symbolFunc.getStr(null);
            StaticSymbolTable symbolMapReader = this.fwdPageFrameCursor.getSymbolTable(this.symbolColumnIndex);
            this.symbolKey = symbolMapReader.keyOf(symbol);
            if (this.symbolKey != -2) {
                this.symbolKey = TableUtils.toIndexKey(this.symbolKey);
            }
        }
        return this.fwdPageFrameCursor;
    }

    @Override
    public void revertFromSampleByIndexDataFrameCursorFactory() {
        this.convertedToFrame = false;
    }

    @Override
    public boolean supportPageFrameCursor() {
        return this.convertedToFrame;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("DeferredSingleSymbolFilterDataFrame");
        super.toPlanInner(sink);
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        assert (!this.convertedToFrame);
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }
}

