/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRandomRecordCursor;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDeferredValueRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    protected final int columnIndex;
    protected final IntList columnIndexes;
    protected final Function filter;
    private final Function symbolFunc;
    private DataFrameRecordCursor cursor;

    public AbstractDeferredValueRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, Function symbolFunc, @Nullable Function filter, IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        this.columnIndex = columnIndex;
        this.symbolFunc = symbolFunc;
        this.filter = filter;
        this.columnIndexes = columnIndexes;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val('=').val(this.symbolFunc);
        sink.child(this.dataFrameCursorFactory);
    }

    private boolean lookupDeferredSymbol(DataFrameCursor dataFrameCursor) {
        CharSequence symbol = this.symbolFunc.getStr(null);
        int symbolKey = dataFrameCursor.getSymbolTable(this.columnIndexes.get(this.columnIndex)).keyOf(symbol);
        if (symbolKey == -2) {
            dataFrameCursor.close();
            return true;
        }
        this.cursor = this.createDataFrameCursorFor(symbolKey);
        return false;
    }

    @Override
    protected void _close() {
        super._close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    protected abstract DataFrameRecordCursor createDataFrameCursorFor(int var1);

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        if (this.cursor == null && this.lookupDeferredSymbol(dataFrameCursor)) {
            if (this.recordCursorSupportsRandomAccess()) {
                return EmptyTableRandomRecordCursor.INSTANCE;
            }
            return EmptyTableRecordCursor.INSTANCE;
        }
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }
}

