/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.orderby.RecordTreeChain;
import io.questdb.std.Misc;

class SortedRecordCursor
implements DelegatingRecordCursor {
    private final RecordTreeChain chain;
    private RecordCursor base;
    private RecordTreeChain.TreeCursor chainCursor;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean isChainBuilt;
    private boolean isOpen;

    public SortedRecordCursor(RecordTreeChain chain) {
        this.chain = chain;
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.free(this.chainCursor);
            Misc.free(this.chain);
            this.base = null;
        }
    }

    @Override
    public Record getRecord() {
        return this.chainCursor.getRecord();
    }

    @Override
    public Record getRecordB() {
        return this.chainCursor.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.chainCursor.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.isChainBuilt) {
            this.buildChain();
            this.isChainBuilt = true;
        }
        return this.chainCursor.hasNext();
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.chainCursor.newSymbolTable(columnIndex);
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) {
        if (!this.isOpen) {
            this.chain.reopen();
            this.isOpen = true;
        }
        this.base = base;
        this.chainCursor = this.chain.getCursor(base);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isChainBuilt = false;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.chainCursor.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.base.size();
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
    }

    private void buildChain() {
        Record record = this.base.getRecord();
        while (this.base.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            this.chain.put(record);
        }
        this.toTop();
    }
}

