/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlTimeoutException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.FanOut;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.std.AbstractSelfReturningObject;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.WeakSelfReturningObjectPool;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.tasks.TableWriterTask;

class OperationFutureImpl
extends AbstractSelfReturningObject<OperationFutureImpl>
implements OperationFuture {
    private static final Log LOG = LogFactory.getLog(OperationFutureImpl.class);
    private final long busyWaitTimeout;
    private final CairoEngine engine;
    private long affectedRowsCount;
    private AsyncWriterCommand asyncWriterCommand;
    private boolean closing;
    private long correlationId;
    private SCSequence eventSubSeq;
    private QueryFutureUpdateListener queryFutureUpdateListener;
    private int status;
    private int tableNamePositionInSql;
    private TableToken tableToken;

    OperationFutureImpl(CairoEngine engine, WeakSelfReturningObjectPool<OperationFutureImpl> pool) {
        super(pool);
        this.engine = engine;
        this.busyWaitTimeout = engine.getConfiguration().getWriterAsyncCommandBusyWaitTimeout();
    }

    @Override
    public void await() throws SqlException {
        this.await(this.busyWaitTimeout);
        if (this.status == 1) {
            this.await(this.engine.getConfiguration().getWriterAsyncCommandMaxTimeout() - this.busyWaitTimeout);
        }
        if (this.status != 2) {
            throw SqlTimeoutException.timeout("Timeout expired on waiting for the async command execution result [instance=").put(this.correlationId).put(']');
        }
    }

    @Override
    public int await(long timeout) throws SqlException {
        return this.await0(timeout > 0L ? timeout : this.busyWaitTimeout);
    }

    @Override
    public void close() {
        if (this.eventSubSeq != null) {
            this.engine.getMessageBus().getTableWriterEventFanOut().remove(this.eventSubSeq);
            this.eventSubSeq.clear();
            this.eventSubSeq = null;
            this.correlationId = -1L;
            this.tableToken = null;
        }
        this.asyncWriterCommand = Misc.free(this.asyncWriterCommand);
        if (!this.closing) {
            this.closing = true;
            super.close();
            this.closing = false;
        }
    }

    @Override
    public long getAffectedRowsCount() {
        return this.affectedRowsCount;
    }

    @Override
    public long getInstanceId() {
        return this.correlationId;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void of(AsyncWriterCommand asyncWriterCommand, SqlExecutionContext executionContext, SCSequence eventSubSeq, int tableNamePositionInSql, boolean closeOnDone) throws AlterTableContextException {
        assert (eventSubSeq != null) : "event subscriber sequence must be provided";
        this.queryFutureUpdateListener = executionContext.getQueryFutureUpdateListener();
        this.tableNamePositionInSql = tableNamePositionInSql;
        FanOut writerEventFanOut = this.engine.getMessageBus().getTableWriterEventFanOut();
        writerEventFanOut.and(eventSubSeq);
        this.eventSubSeq = eventSubSeq;
        this.asyncWriterCommand = closeOnDone ? asyncWriterCommand : null;
        try {
            String cmdName = asyncWriterCommand.getCommandName();
            this.tableToken = asyncWriterCommand.getTableToken();
            this.correlationId = this.engine.getCommandCorrelationId();
            asyncWriterCommand.setCommandCorrelationId(this.correlationId);
            try (TableWriter writer = this.engine.getWriterOrPublishCommand(asyncWriterCommand.getTableToken(), asyncWriterCommand);){
                if (writer != null) {
                    LOG.info().$("published SYNC writer command [name=").$(cmdName).$(",tableName=").$(this.tableToken).$(",instance=").$(this.correlationId).I$();
                    this.affectedRowsCount = asyncWriterCommand.apply(writer, true);
                    this.status = 2;
                } else {
                    LOG.info().$("published ASYNC writer command [name=").$(cmdName).$(",tableName=").$(this.tableToken).$(",instance=").$(this.correlationId).I$();
                    this.affectedRowsCount = 0L;
                    this.status = 0;
                }
            }
            this.queryFutureUpdateListener.reportStart(asyncWriterCommand.getTableToken(), this.correlationId);
        }
        catch (Throwable ex) {
            this.close();
            throw ex;
        }
    }

    private int await0(long timeout) throws SqlException {
        if (this.status == 2) {
            return this.status;
        }
        this.status = Math.max(this.status, this.awaitWriterEvent(timeout));
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int awaitWriterEvent(long timeout) throws SqlException {
        assert (this.eventSubSeq != null) : "No sequence to wait on";
        assert (this.correlationId > -1L) : "No command id to wait for";
        assert (timeout > 0L);
        MillisecondClock clock = this.engine.getConfiguration().getMillisecondClock();
        long start = clock.getTicks();
        RingQueue<TableWriterTask> tableWriterEventQueue = this.engine.getMessageBus().getTableWriterEventQueue();
        int status = this.status;
        while (true) {
            long seq;
            if ((seq = this.eventSubSeq.next()) < 0L) {
                if (seq == -1L) {
                    if (clock.getTicks() - start <= timeout) continue;
                    this.queryFutureUpdateListener.reportBusyWaitExpired(this.tableToken, this.correlationId);
                    return status;
                }
                Os.pause();
                continue;
            }
            try {
                TableWriterTask event = tableWriterEventQueue.get(seq);
                int type = event.getType();
                if (event.getInstance() != this.correlationId || type != 64 && type != 65) {
                    LOG.info().$("writer command response received and ignored [instance=").$(event.getInstance()).$(", type=").$(type).$(", expectedInstance=").$(this.correlationId).I$();
                    Os.pause();
                    continue;
                }
                if (type == 65) {
                    LOG.info().$("writer command response received [instance=").$(this.correlationId).I$();
                    int code = Unsafe.getUnsafe().getInt(event.getData());
                    switch (code) {
                        case 0: {
                            this.affectedRowsCount = Unsafe.getUnsafe().getInt(event.getData() + 4L);
                            this.queryFutureUpdateListener.reportProgress(this.correlationId, 2);
                            int n = 2;
                            return n;
                        }
                        case -1: {
                            throw TableReferenceOutOfDateException.of(this.tableToken);
                        }
                    }
                    LOG.error().$("error writer command response [instance=").$(this.correlationId).$(", errorCode=").$(code).I$();
                    int strLen = Unsafe.getUnsafe().getInt(event.getData() + 4L);
                    long strLo = event.getData() + 8L;
                    if (strLen == 0) {
                        throw SqlException.$(this.tableNamePositionInSql, "statement execution failed");
                    }
                    throw SqlException.$(this.tableNamePositionInSql, strLo, strLo + 2L * (long)strLen);
                }
                status = 1;
                this.queryFutureUpdateListener.reportProgress(this.correlationId, 1);
                LOG.info().$("writer command QUERY_STARTED response received [instance=").$(this.correlationId).I$();
                continue;
            }
            finally {
                this.eventSubSeq.done(seq);
                continue;
            }
            break;
        }
    }
}

