/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.join.OuterJoinRecord;

public final class SymbolWrapOverJoinRecord
extends OuterJoinRecord {
    private final ColumnFilter keyColumnsToMaster;
    private final int slaveValuesKeysSplit;

    public SymbolWrapOverJoinRecord(int masterSlaveSplit, Record nullRecord, int slaveValuesKeysSplit, ColumnFilter keyColumnsToMaster) {
        super(masterSlaveSplit, nullRecord);
        this.keyColumnsToMaster = keyColumnsToMaster;
        this.slaveValuesKeysSplit = slaveValuesKeysSplit;
    }

    @Override
    public int getInt(int col) {
        if (col < this.split) {
            return this.master.getInt(col);
        }
        int slaveCol = col - this.split;
        if (this.shouldWrapOver(slaveCol)) {
            int masterCol = this.keyColumnsToMaster.getColumnIndexFactored(slaveCol -= this.slaveValuesKeysSplit);
            return this.master.getInt(masterCol);
        }
        return this.slave.getInt(slaveCol);
    }

    @Override
    public CharSequence getSym(int col) {
        if (col < this.split) {
            return this.master.getSym(col);
        }
        int slaveCol = col - this.split;
        if (this.isSlaveKeyColumn(slaveCol)) {
            return this.slave.getStr(slaveCol);
        }
        return this.slave.getSym(slaveCol);
    }

    @Override
    public CharSequence getSymB(int col) {
        if (col < this.split) {
            return this.master.getSymB(col);
        }
        int slaveCol = col - this.split;
        if (this.isSlaveKeyColumn(slaveCol)) {
            return this.slave.getStrB(slaveCol);
        }
        return this.slave.getSymB(slaveCol);
    }

    private boolean isSlaveKeyColumn(int col) {
        return col >= this.slaveValuesKeysSplit;
    }

    private boolean shouldWrapOver(int slaveCol) {
        return slaveCol >= this.slaveValuesKeysSplit && this.slave != this.nullRecord;
    }
}

