/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class NestedLoopLeftJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final NestedLoopLeftRecordCursor cursor;
    private final Function filter;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;

    public NestedLoopLeftJoinRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit, @NotNull Function filter, @NotNull Record nullRecord) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.filter = filter;
        this.cursor = new NestedLoopLeftRecordCursor(columnSplit, filter, nullRecord);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable ex) {
            Misc.free(masterCursor);
            Misc.free(slaveCursor);
            throw ex;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.masterFactory.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Nested Loop Left Join");
        sink.attr("filter").val(this.filter);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.filter.close();
    }

    private static class NestedLoopLeftRecordCursor
    extends AbstractJoinCursor {
        private final Function filter;
        private final OuterJoinRecord record;
        private boolean isMasterHasNextPending;
        private boolean isMatch;
        private boolean masterHasNext;

        public NestedLoopLeftRecordCursor(int columnSplit, Function filter, Record nullRecord) {
            super(columnSplit);
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.filter = filter;
            this.isMatch = false;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.isMasterHasNextPending) {
                    this.masterHasNext = this.masterCursor.hasNext();
                    this.isMasterHasNextPending = false;
                }
                if (!this.masterHasNext) {
                    return false;
                }
                while (this.slaveCursor.hasNext()) {
                    if (!this.filter.getBool(this.record)) continue;
                    this.isMatch = true;
                    return true;
                }
                if (!this.isMatch) {
                    this.isMatch = true;
                    this.record.hasSlave(false);
                    return true;
                }
                this.isMatch = false;
                this.slaveCursor.toTop();
                this.record.hasSlave(true);
                this.isMasterHasNextPending = true;
            }
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.filter.toTop();
            this.isMatch = false;
            this.isMasterHasNextPending = true;
            this.record.hasSlave(true);
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionContext executionContext) throws SqlException {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.filter.init(this, executionContext);
            this.record.of(masterCursor.getRecord(), slaveCursor.getRecord());
            this.isMasterHasNextPending = true;
        }
    }
}

