/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;

public class HashJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final HashJoinRecordCursor cursor;
    private final JoinContext joinContext;
    private final RecordCursorFactory masterFactory;
    private final RecordSink masterSink;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink slaveKeySink;

    public HashJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, RecordSink slaveChainSink, int columnSplit, JoinContext joinContext) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        Map joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        RecordChain slaveChain = new RecordChain(slaveFactory.getMetadata(), slaveChainSink, configuration.getSqlHashJoinValuePageSize(), configuration.getSqlHashJoinValueMaxPages());
        this.masterSink = masterSink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashJoinRecordCursor(columnSplit, joinKeyMap, slaveChain);
        this.joinContext = joinContext;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.masterFactory.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Join");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
    }

    private class HashJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final JoinRecord recordA;
        private final RecordChain slaveChain;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private Record masterRecord;
        private boolean useSlaveCursor;

        public HashJoinRecordCursor(int columnSplit, Map joinKeyMap, RecordChain slaveChain) {
            super(columnSplit);
            this.recordA = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                this.buildMapOfSlaveRecords();
                this.isMapBuilt = true;
            }
            if (this.useSlaveCursor && this.slaveChain.hasNext()) {
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChain.of(value.getLong(0));
                this.slaveChain.hasNext();
                this.useSlaveCursor = true;
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.useSlaveCursor = false;
            if (!this.isMapBuilt) {
                this.slaveCursor.toTop();
                this.joinKeyMap.clear();
                this.slaveChain.clear();
            }
        }

        private void buildMapOfSlaveRecords() {
            Record record = this.slaveCursor.getRecord();
            while (this.slaveCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.joinKeyMap.withKey();
                key.put(record, HashJoinRecordCursorFactory.this.slaveKeySink);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    long offset = this.slaveChain.put(record, -1L);
                    value.putLong(0, offset);
                    value.putLong(1, offset);
                    continue;
                }
                value.putLong(1, this.slaveChain.put(record, value.getLong(1)));
            }
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
                this.slaveChain.reopen();
            }
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.circuitBreaker = circuitBreaker;
            this.masterRecord = masterCursor.getRecord();
            Record slaveRecord = this.slaveChain.getRecord();
            this.recordA.of(this.masterRecord, slaveRecord);
            this.slaveChain.setSymbolTableResolver(slaveCursor);
            this.useSlaveCursor = false;
            this.isMapBuilt = false;
        }
    }
}

