/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.mp.Sequence;
import io.questdb.std.Mutable;
import io.questdb.std.Rosti;
import io.questdb.std.RostiAllocFacade;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class VectorAggregateEntry
implements Mutable {
    private ExecutionCircuitBreaker circuitBreaker;
    private int columnSizeShr;
    private CountDownLatchSPI doneLatch;
    private VectorAggregateFunction func;
    private long keyAddress;
    private AtomicInteger oomCounter;
    private long[] pRosti;
    private PerWorkerLocks perWorkerLocks;
    private RostiAllocFacade raf;
    private long valueAddress;
    private long valueCount;

    @Override
    public void clear() {
        this.valueAddress = 0L;
        this.valueCount = 0L;
        this.func = null;
    }

    public void run(int workerId, Sequence seq, long cursor) {
        long keyAddress = this.keyAddress;
        long valueAddress = this.valueAddress;
        long valueCount = this.valueCount;
        int columnSizeShr = this.columnSizeShr;
        AtomicInteger oomCounter = this.oomCounter;
        long[] pRosti = this.pRosti;
        RostiAllocFacade raf = this.raf;
        VectorAggregateFunction func = this.func;
        ExecutionCircuitBreaker circuitBreaker = this.circuitBreaker;
        CountDownLatchSPI doneLatch = this.doneLatch;
        PerWorkerLocks perWorkerLocks = this.perWorkerLocks;
        seq.done(cursor);
        VectorAggregateEntry.run(workerId, keyAddress, valueAddress, valueCount, columnSizeShr, oomCounter, pRosti, raf, func, perWorkerLocks, circuitBreaker, doneLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(int workerId, long keyAddress, long valueAddress, long valueCount, int columnSizeShr, AtomicInteger oomCounter, long[] pRosti, RostiAllocFacade raf, VectorAggregateFunction func, PerWorkerLocks perWorkerLocks, ExecutionCircuitBreaker circuitBreaker, CountDownLatchSPI doneLatch) {
        if (circuitBreaker.checkIfTripped() || oomCounter != null && oomCounter.get() > 0) {
            doneLatch.countDown();
            return;
        }
        int slot = perWorkerLocks.acquireSlot(workerId, circuitBreaker);
        try {
            if (pRosti != null) {
                long oldSize = Rosti.getAllocMemory(pRosti[slot]);
                if (!func.aggregate(pRosti[slot], keyAddress, valueAddress, valueCount, columnSizeShr, slot) && oomCounter != null) {
                    oomCounter.incrementAndGet();
                }
                raf.updateMemoryUsage(pRosti[slot], oldSize);
            } else {
                func.aggregate(valueAddress, valueCount, columnSizeShr, slot);
            }
        }
        finally {
            perWorkerLocks.releaseSlot(slot);
            doneLatch.countDown();
        }
    }

    void of(VectorAggregateFunction vaf, long[] pRosti, long keyPageAddress, long valuePageAddress, long valuePageCount, int columnSizeShr, CountDownLatchSPI doneLatch, @Nullable AtomicInteger oomCounter, RostiAllocFacade raf, PerWorkerLocks perWorkerLocks, ExecutionCircuitBreaker circuitBreaker) {
        this.pRosti = pRosti;
        this.keyAddress = keyPageAddress;
        this.valueAddress = valuePageAddress;
        this.valueCount = valuePageCount;
        this.func = vaf;
        this.columnSizeShr = columnSizeShr;
        this.doneLatch = doneLatch;
        this.oomCounter = oomCounter;
        this.raf = raf;
        this.perWorkerLocks = perWorkerLocks;
        this.circuitBreaker = circuitBreaker;
    }
}

