/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.mp.Worker;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.tasks.VectorAggregateTask;

public class GroupByNotKeyedVectorRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final Log LOG = LogFactory.getLog(GroupByNotKeyedVectorRecordCursorFactory.class);
    private final RecordCursorFactory base;
    private final GroupByNotKeyedVectorRecordCursor cursor;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final ObjectPool<VectorAggregateEntry> entryPool;
    private final PerWorkerLocks perWorkerLocks;
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker;
    private final ObjList<VectorAggregateFunction> vafList;
    private final int workerCount;

    public GroupByNotKeyedVectorRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, int workerCount, ObjList<VectorAggregateFunction> vafList) {
        super(metadata);
        this.entryPool = new ObjectPool<VectorAggregateEntry>(VectorAggregateEntry::new, configuration.getGroupByPoolCapacity());
        this.base = base;
        this.vafList = new ObjList(vafList.size());
        this.vafList.addAll(vafList);
        this.cursor = new GroupByNotKeyedVectorRecordCursor(this.vafList);
        this.perWorkerLocks = new PerWorkerLocks(configuration, workerCount);
        this.sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
        this.workerCount = workerCount;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int n = this.vafList.size();
        for (int i = 0; i < n; ++i) {
            this.vafList.getQuick(i).clear();
        }
        PageFrameCursor pageFrameCursor = this.base.getPageFrameCursor(executionContext, 0);
        return this.cursor.of(pageFrameCursor, executionContext.getMessageBus(), executionContext.getCircuitBreaker());
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(true);
        sink.optAttr("values", this.vafList, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    static int getRunWhatsLeft(Sequence subSeq, RingQueue<VectorAggregateTask> queue, int queuedCount, int reclaimed, int workerId, SOUnboundedCountDownLatch doneLatch, Log log, SqlExecutionCircuitBreaker circuitBreaker, AtomicBooleanCircuitBreaker sharedCB) {
        while (!doneLatch.done(queuedCount)) {
            long cursor;
            if (circuitBreaker.checkIfTripped()) {
                sharedCB.cancel();
            }
            if ((cursor = subSeq.next()) > -1L) {
                VectorAggregateTask task = queue.get(cursor);
                task.entry.run(workerId, subSeq, cursor);
                ++reclaimed;
                continue;
            }
            Os.pause();
        }
        return reclaimed;
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.vafList);
        Misc.free(this.base);
    }

    private class GroupByNotKeyedVectorRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Record recordA;
        private boolean areFunctionsBuilt;
        private MessageBus bus;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private int countDown = 1;
        private PageFrameCursor pageFrameCursor;

        public GroupByNotKeyedVectorRecordCursor(ObjList<? extends Function> functions) {
            this.recordA = new VirtualRecordNoRowid(functions);
        }

        @Override
        public void close() {
            Misc.free(this.pageFrameCursor);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            if (!this.areFunctionsBuilt) {
                this.buildFunctions();
                this.areFunctionsBuilt = true;
            }
            return this.countDown-- > 0;
        }

        public GroupByNotKeyedVectorRecordCursor of(PageFrameCursor pageFrameCursor, MessageBus bus, SqlExecutionCircuitBreaker circuitBreaker) {
            this.pageFrameCursor = pageFrameCursor;
            this.bus = bus;
            this.circuitBreaker = circuitBreaker;
            this.areFunctionsBuilt = false;
            return this;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.countDown = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildFunctions() {
            int vafCount = GroupByNotKeyedVectorRecordCursorFactory.this.vafList.size();
            RingQueue<VectorAggregateTask> queue = this.bus.getVectorAggregateQueue();
            Sequence pubSeq = this.bus.getVectorAggregatePubSeq();
            GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker.reset();
            GroupByNotKeyedVectorRecordCursorFactory.this.entryPool.clear();
            int queuedCount = 0;
            int ownCount = 0;
            int reclaimed = 0;
            int total = 0;
            GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch.reset();
            Thread thread = Thread.currentThread();
            int workerId = thread instanceof Worker ? ((Worker)thread).getWorkerId() % GroupByNotKeyedVectorRecordCursorFactory.this.workerCount : -1;
            try {
                PageFrame frame;
                while ((frame = this.pageFrameCursor.next()) != null) {
                    for (int i = 0; i < vafCount; ++i) {
                        VectorAggregateFunction vaf = GroupByNotKeyedVectorRecordCursorFactory.this.vafList.getQuick(i);
                        int columnIndex = vaf.getColumnIndex();
                        long pageAddress = columnIndex > -1 ? frame.getPageAddress(columnIndex) : 0L;
                        long pageSize = columnIndex > -1 ? frame.getPageSize(columnIndex) : frame.getPageSize(0);
                        int colSizeShr = columnIndex > -1 ? frame.getColumnShiftBits(columnIndex) : frame.getColumnShiftBits(0);
                        long seq = pubSeq.next();
                        if (seq < 0L) {
                            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                            int slot = GroupByNotKeyedVectorRecordCursorFactory.this.perWorkerLocks.acquireSlot(workerId, this.circuitBreaker);
                            try {
                                vaf.aggregate(pageAddress, pageSize, colSizeShr, slot);
                                ++ownCount;
                            }
                            finally {
                                GroupByNotKeyedVectorRecordCursorFactory.this.perWorkerLocks.releaseSlot(slot);
                            }
                        } else {
                            VectorAggregateEntry entry = GroupByNotKeyedVectorRecordCursorFactory.this.entryPool.next();
                            ++queuedCount;
                            entry.of(vaf, null, 0L, pageAddress, pageSize, colSizeShr, GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch, null, null, GroupByNotKeyedVectorRecordCursorFactory.this.perWorkerLocks, GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker);
                            queue.get((long)seq).entry = entry;
                            pubSeq.done(seq);
                        }
                        ++total;
                    }
                }
                this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
            }
            catch (DataUnavailableException e) {
                throw e;
            }
            catch (Throwable e) {
                GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker.cancel();
                throw e;
            }
            finally {
                reclaimed = GroupByNotKeyedVectorRecordCursorFactory.getRunWhatsLeft(this.bus.getVectorAggregateSubSeq(), queue, queuedCount, reclaimed, workerId, GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch, LOG, this.circuitBreaker, GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker);
            }
            this.toTop();
            LOG.info().$("done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).I$();
        }
    }
}

