/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.InterpolationUtil;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.VirtualFunctionSkewedSymbolRecordCursor;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;

public class SampleByInterpolateRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    private final SampleByInterpolateRecordCursor cursor;
    private final int groupByFunctionCount;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final int groupByScalarFunctionCount;
    private final ObjList<GroupByFunction> groupByScalarFunctions;
    private final int groupByTwoPointFunctionCount;
    private final ObjList<GroupByFunction> groupByTwoPointFunctions;
    private final ObjList<InterpolationUtil.InterpolatorFunction> interpolatorFunctions;
    private final RecordSink mapSink;
    private final RecordSink mapSink2;
    private final ObjList<Function> recordFunctions;
    private final TimestampSampler sampler;
    private final ObjList<InterpolationUtil.StoreYFunction> storeYFunctions;
    private final int timestampIndex;
    private final int yDataSize;
    private long yData;

    public SampleByInterpolateRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, @NotNull TimestampSampler timestampSampler, @NotNull QueryModel model, @NotNull ListColumnFilter listColumnFilter, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, @NotNull EntityColumnFilter entityColumnFilter, @NotNull IntList groupByFunctionPositions, int timestampIndex) throws SqlException {
        super(metadata);
        int i;
        int columnCount = model.getBottomUpColumns().size();
        this.groupByFunctions = groupByFunctions;
        this.recordFunctions = recordFunctions;
        this.base = base;
        this.sampler = timestampSampler;
        TimestampColumn timestampColumn = TimestampColumn.newInstance(valueTypes.getColumnCount() + keyTypes.getColumnCount());
        int n = recordFunctions.size();
        for (i = 0; i < n; ++i) {
            if (recordFunctions.getQuick(i) != null) continue;
            recordFunctions.setQuick(i, timestampColumn);
        }
        this.groupByScalarFunctions = new ObjList(columnCount);
        this.groupByTwoPointFunctions = new ObjList(columnCount);
        this.storeYFunctions = new ObjList(columnCount);
        this.interpolatorFunctions = new ObjList(columnCount);
        this.groupByFunctionCount = groupByFunctions.size();
        block9: for (i = 0; i < this.groupByFunctionCount; ++i) {
            GroupByFunction function = groupByFunctions.getQuick(i);
            if (function.isScalar()) {
                this.groupByScalarFunctions.add(function);
                switch (ColumnType.tagOf(function.getType())) {
                    case 2: {
                        this.storeYFunctions.add(InterpolationUtil.STORE_Y_BYTE);
                        this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_BYTE);
                        continue block9;
                    }
                    case 3: {
                        this.storeYFunctions.add(InterpolationUtil.STORE_Y_SHORT);
                        this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_SHORT);
                        continue block9;
                    }
                    case 5: {
                        this.storeYFunctions.add(InterpolationUtil.STORE_Y_INT);
                        this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_INT);
                        continue block9;
                    }
                    case 6: {
                        this.storeYFunctions.add(InterpolationUtil.STORE_Y_LONG);
                        this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_LONG);
                        continue block9;
                    }
                    case 10: {
                        this.storeYFunctions.add(InterpolationUtil.STORE_Y_DOUBLE);
                        this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_DOUBLE);
                        continue block9;
                    }
                    case 9: {
                        this.storeYFunctions.add(InterpolationUtil.STORE_Y_FLOAT);
                        this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_FLOAT);
                        continue block9;
                    }
                    default: {
                        Misc.freeObjList(this.groupByScalarFunctions);
                        throw SqlException.$(groupByFunctionPositions.getQuick(i), "Unsupported interpolation type: ").put(ColumnType.nameOf(function.getType()));
                    }
                }
            }
            this.groupByTwoPointFunctions.add(function);
        }
        this.groupByScalarFunctionCount = this.groupByScalarFunctions.size();
        this.groupByTwoPointFunctionCount = this.groupByTwoPointFunctions.size();
        this.timestampIndex = timestampIndex;
        this.yDataSize = this.groupByFunctionCount * 16;
        this.yData = Unsafe.malloc(this.yDataSize, 50);
        this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
        entityColumnFilter.of(keyTypes.getColumnCount());
        this.mapSink2 = RecordSinkFactory.getInstance(asm, keyTypes, entityColumnFilter, false);
        this.cursor = new SampleByInterpolateRecordCursor(recordFunctions, configuration, keyTypes, valueTypes);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        for (int i = 0; i < this.groupByTwoPointFunctionCount; ++i) {
            GroupByFunction function = this.groupByTwoPointFunctions.getQuick(i);
            if (function.isInterpolationSupported()) continue;
            throw SqlException.position(0).put("interpolation is not supported for function: ").put(function.getClass().getName());
        }
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            Function.init(this.recordFunctions, baseCursor, executionContext);
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable e) {
            baseCursor.close();
            this.cursor.close();
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("SampleBy");
        sink.attr("fill").val("linear");
        sink.optAttr((CharSequence)"keys", GroupByRecordCursorFactory.getKeys(this.recordFunctions, this.getMetadata()));
        sink.optAttr("values", this.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private void freeYData() {
        if (this.yData != 0L) {
            Unsafe.free(this.yData, this.yDataSize, 50);
            this.yData = 0L;
        }
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.recordFunctions);
        this.freeYData();
        Misc.free(this.base);
        Misc.free(this.cursor);
    }

    private class SampleByInterpolateRecordCursor
    extends VirtualFunctionSkewedSymbolRecordCursor {
        protected final Map recordKeyMap;
        private final Map dataMap;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long hiSample;
        private boolean isHasNextPending;
        private boolean isMapBuilt;
        private boolean isMapFilled;
        private boolean isMapInitialized;
        private boolean isOpen;
        private long loSample;
        private Record managedRecord;
        private long prevSample;

        public SampleByInterpolateRecordCursor(ObjList<Function> functions, @NotNull CairoConfiguration configuration, @NotNull ArrayColumnTypes keyTypes, ArrayColumnTypes valueTypes) {
            super(functions);
            this.hiSample = -1L;
            this.loSample = -1L;
            this.prevSample = -1L;
            this.recordKeyMap = MapFactory.createMap(configuration, keyTypes);
            keyTypes.add(8);
            this.dataMap = MapFactory.createMap(configuration, keyTypes, (ColumnTypes)valueTypes);
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.recordKeyMap.close();
                this.dataMap.close();
                Misc.clearObjList(SampleByInterpolateRecordCursorFactory.this.groupByFunctions);
                super.close();
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                this.buildMap();
                this.isMapBuilt = true;
            }
            return super.hasNext();
        }

        public void of(RecordCursor managedCursor, SqlExecutionContext executionContext) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.recordKeyMap.reopen();
                this.dataMap.reopen();
            }
            super.of(managedCursor, this.dataMap.getCursor());
            this.circuitBreaker = executionContext.getCircuitBreaker();
            this.managedRecord = managedCursor.getRecord();
            this.loSample = -1L;
            this.hiSample = -1L;
            this.prevSample = -1L;
            this.isHasNextPending = false;
            this.isMapInitialized = false;
            this.isMapFilled = false;
            this.isMapBuilt = false;
        }

        @Override
        public long size() {
            return this.isMapBuilt ? super.size() : -1L;
        }

        @Override
        public void toTop() {
            super.toTop();
            if (!this.isMapBuilt) {
                this.recordKeyMap.clear();
                this.dataMap.clear();
                this.loSample = -1L;
                this.hiSample = -1L;
                this.prevSample = -1L;
                this.isHasNextPending = false;
                this.isMapInitialized = false;
                this.isMapFilled = false;
            }
        }

        private void buildMap() {
            long prevSample;
            if (!this.isMapInitialized) {
                if (!this.initMap()) {
                    return;
                }
                this.isMapInitialized = true;
            }
            if (!this.isMapFilled) {
                this.fillMap();
                this.isMapFilled = true;
            }
            if (SampleByInterpolateRecordCursorFactory.this.groupByTwoPointFunctionCount > 0) {
                RecordCursor mapCursor = this.recordKeyMap.getCursor();
                Record mapRecord = mapCursor.getRecord();
                while (mapCursor.hasNext()) {
                    long x1;
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    MapValue value = this.findDataMapValue(mapRecord, this.loSample);
                    if (value.getByte(0) != 0) continue;
                    long x2 = x1 = this.loSample;
                    while ((x2 = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(x2)) < this.hiSample) {
                        value = this.findDataMapValue(mapRecord, x2);
                        if (value.getByte(0) != 0) continue;
                        this.interpolateBoundaryRange(x1, x2, mapRecord);
                        x1 = x2;
                    }
                }
            }
            long sample = prevSample = this.loSample;
            while (sample < this.hiSample) {
                RecordCursor mapCursor = this.recordKeyMap.getCursor();
                Record mapRecord = mapCursor.getRecord();
                block3: while (mapCursor.hasNext()) {
                    long x1;
                    long x2;
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    MapValue value = this.findDataMapValue(mapRecord, sample);
                    if (value.getByte(0) != 1) continue;
                    long current = sample;
                    while ((x2 = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(current)) < this.hiSample) {
                        value = this.findDataMapValue(mapRecord, x2);
                        if (value.getByte(0) == 1) {
                            current = x2;
                            continue;
                        }
                        if (sample == this.loSample) {
                            x1 = x2;
                            while ((x2 = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(x2)) < this.hiSample) {
                                MapValue x2value = this.findDataMapValue(mapRecord, x2);
                                if (x2value.getByte(0) != 0) continue;
                                MapValue x1Value = this.findDataMapValue2(mapRecord, x1);
                                this.interpolate(this.loSample, x1, mapRecord, x1, x2, x1Value, x2value);
                                continue block3;
                            }
                            this.nullifyRange(this.loSample, x1, mapRecord);
                            this.nullifyRange(SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(x1), this.hiSample, mapRecord);
                            continue block3;
                        }
                        MapValue x1Value = this.findDataMapValue2(mapRecord, prevSample);
                        this.interpolate(SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(prevSample), x2, mapRecord, prevSample, x2, x1Value, value);
                        continue block3;
                    }
                    x1 = SampleByInterpolateRecordCursorFactory.this.sampler.previousTimestamp(prevSample);
                    if (x1 < this.loSample) {
                        this.nullifyRange(sample, this.hiSample, mapRecord);
                        continue;
                    }
                    MapValue x1Value = this.findDataMapValue2(mapRecord, x1);
                    MapValue x2value = this.findDataMapValue(mapRecord, prevSample);
                    this.interpolate(SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(prevSample), this.hiSample, mapRecord, x1, prevSample, x1Value, x2value);
                }
                prevSample = sample;
                sample = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(sample);
            }
            this.baseCursor = this.dataMap.getCursor();
        }

        private void computeYPoints(MapValue x1Value, MapValue x2value) {
            for (int i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByScalarFunctionCount; ++i) {
                InterpolationUtil.StoreYFunction storeYFunction = SampleByInterpolateRecordCursorFactory.this.storeYFunctions.getQuick(i);
                GroupByFunction groupByFunction = SampleByInterpolateRecordCursorFactory.this.groupByScalarFunctions.getQuick(i);
                storeYFunction.store(groupByFunction, x1Value, SampleByInterpolateRecordCursorFactory.this.yData + (long)i * 16L);
                storeYFunction.store(groupByFunction, x2value, SampleByInterpolateRecordCursorFactory.this.yData + (long)i * 16L + 8L);
            }
        }

        private void fillGaps(long lo, long hi) {
            RecordCursor keyCursor = this.recordKeyMap.getCursor();
            Record record = keyCursor.getRecord();
            long timestamp = lo;
            while (timestamp < hi) {
                while (keyCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    MapKey key = this.dataMap.withKey();
                    SampleByInterpolateRecordCursorFactory.this.mapSink2.copy(record, key);
                    key.putLong(timestamp);
                    MapValue value = key.createValue();
                    if (!value.isNew()) continue;
                    value.putByte(0, (byte)1);
                }
                timestamp = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(timestamp);
                keyCursor.toTop();
            }
        }

        private void fillMap() {
            boolean hasNext;
            if (this.prevSample == -1L) {
                boolean good = this.managedCursor.hasNext();
                assert (good);
                long timestamp = this.managedRecord.getTimestamp(SampleByInterpolateRecordCursorFactory.this.timestampIndex);
                SampleByInterpolateRecordCursorFactory.this.sampler.setStart(timestamp);
                this.loSample = this.prevSample = SampleByInterpolateRecordCursorFactory.this.sampler.round(timestamp);
            }
            do {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                if (!this.isHasNextPending) {
                    int i;
                    long sample = SampleByInterpolateRecordCursorFactory.this.sampler.round(this.managedRecord.getTimestamp(SampleByInterpolateRecordCursorFactory.this.timestampIndex));
                    if (sample != this.prevSample) {
                        this.fillGaps(this.prevSample, sample);
                        this.prevSample = sample;
                        GroupByUtils.toTop(SampleByInterpolateRecordCursorFactory.this.groupByFunctions);
                    }
                    MapKey key = this.dataMap.withKey();
                    SampleByInterpolateRecordCursorFactory.this.mapSink.copy(this.managedRecord, key);
                    key.putLong(sample);
                    MapValue value = key.createValue();
                    if (value.isNew()) {
                        value.putByte(0, (byte)0);
                        for (i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByFunctionCount; ++i) {
                            SampleByInterpolateRecordCursorFactory.this.groupByFunctions.getQuick(i).computeFirst(value, this.managedRecord);
                        }
                    } else {
                        for (i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByFunctionCount; ++i) {
                            SampleByInterpolateRecordCursorFactory.this.groupByFunctions.getQuick(i).computeNext(value, this.managedRecord);
                        }
                    }
                }
                this.isHasNextPending = true;
                hasNext = this.managedCursor.hasNext();
                this.isHasNextPending = false;
            } while (hasNext);
            this.hiSample = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(this.prevSample);
            this.fillGaps(this.prevSample, this.hiSample);
        }

        private MapValue findDataMapValue(Record record, long timestamp) {
            MapKey key = this.dataMap.withKey();
            SampleByInterpolateRecordCursorFactory.this.mapSink2.copy(record, key);
            key.putLong(timestamp);
            return key.findValue();
        }

        private MapValue findDataMapValue2(Record record, long timestamp) {
            MapKey key = this.dataMap.withKey();
            SampleByInterpolateRecordCursorFactory.this.mapSink2.copy(record, key);
            key.putLong(timestamp);
            return key.findValue2();
        }

        private MapValue findDataMapValue3(Record record, long timestamp) {
            MapKey key = this.dataMap.withKey();
            SampleByInterpolateRecordCursorFactory.this.mapSink2.copy(record, key);
            key.putLong(timestamp);
            return key.findValue3();
        }

        private boolean initMap() {
            while (this.managedCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.recordKeyMap.withKey();
                SampleByInterpolateRecordCursorFactory.this.mapSink.copy(this.managedRecord, key);
                key.createValue();
            }
            if (this.recordKeyMap.size() == 0L) {
                return false;
            }
            this.managedCursor.toTop();
            return true;
        }

        private void interpolate(long lo, long hi, Record mapRecord, long x1, long x2, MapValue x1Value, MapValue x2value) {
            this.computeYPoints(x1Value, x2value);
            long x = lo;
            while (x < hi) {
                GroupByFunction function;
                int i;
                MapValue result = this.findDataMapValue3(mapRecord, x);
                assert (result != null && result.getByte(0) == 1);
                for (i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByTwoPointFunctionCount; ++i) {
                    function = SampleByInterpolateRecordCursorFactory.this.groupByTwoPointFunctions.getQuick(i);
                    InterpolationUtil.interpolateGap(function, result, SampleByInterpolateRecordCursorFactory.this.sampler.getBucketSize(), x1Value, x2value);
                }
                for (i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByScalarFunctionCount; ++i) {
                    function = SampleByInterpolateRecordCursorFactory.this.groupByScalarFunctions.getQuick(i);
                    SampleByInterpolateRecordCursorFactory.this.interpolatorFunctions.getQuick(i).interpolateAndStore(function, result, x, x1, x2, SampleByInterpolateRecordCursorFactory.this.yData + (long)i * 16L, SampleByInterpolateRecordCursorFactory.this.yData + (long)i * 16L + 8L);
                }
                result.putByte(0, (byte)0);
                x = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(x);
            }
        }

        private void interpolateBoundaryRange(long x1, long x2, Record record) {
            for (int i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByTwoPointFunctionCount; ++i) {
                GroupByFunction function = SampleByInterpolateRecordCursorFactory.this.groupByTwoPointFunctions.getQuick(i);
                MapValue startValue = this.findDataMapValue2(record, x1);
                MapValue endValue = this.findDataMapValue3(record, x2);
                InterpolationUtil.interpolateBoundary(function, SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(x1), startValue, endValue, true);
                InterpolationUtil.interpolateBoundary(function, x2, startValue, endValue, false);
            }
        }

        private void nullifyRange(long lo, long hi, Record record) {
            long x = lo;
            while (x < hi) {
                MapKey key = this.dataMap.withKey();
                SampleByInterpolateRecordCursorFactory.this.mapSink2.copy(record, key);
                key.putLong(x);
                MapValue value = key.findValue();
                assert (value != null && value.getByte(0) == 1);
                value.putByte(0, (byte)0);
                for (int i = 0; i < SampleByInterpolateRecordCursorFactory.this.groupByFunctionCount; ++i) {
                    SampleByInterpolateRecordCursorFactory.this.groupByFunctions.getQuick(i).setNull(value);
                }
                x = SampleByInterpolateRecordCursorFactory.this.sampler.nextTimestamp(x);
            }
        }
    }
}

