/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IndexFrame;
import io.questdb.cairo.IndexFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SingleSymbolFilter;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByCursor;
import io.questdb.griffin.engine.groupby.LongNullUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.std.BitmapIndexUtilsNative;
import io.questdb.std.DirectLongList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class SampleByFirstLastRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int FILTER_KEY_IS_NULL = 0;
    private static final int FIRST_OUT_INDEX = 0;
    private static final int ITEMS_PER_OUT_ARRAY_SHIFT = 2;
    private static final int LAST_OUT_INDEX = 1;
    private static final int TIMESTAMP_OUT_INDEX = 2;
    private final RecordCursorFactory base;
    private final LongList crossFrameRow;
    private final int[] firstLastIndexByCol;
    private final int groupBySymbolColIndex;
    private final boolean[] isKeyColumn;
    private final int maxSamplePeriodSize;
    private final int pageSize;
    private final int[] queryToFrameColumnMapping;
    private final SampleByFirstLastRecordCursor sampleByFirstLastRecordCursor;
    private final SingleSymbolFilter symbolFilter;
    private final int timestampIndex;
    private int groupByTimestampIndex = -1;
    private DirectLongList rowIdOutAddress;
    private DirectLongList samplePeriodAddress;

    public SampleByFirstLastRecordCursorFactory(RecordCursorFactory base, TimestampSampler timestampSampler, GenericRecordMetadata groupByMetadata, ObjList<QueryColumn> columns, RecordMetadata metadata, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, int timestampIndex, SingleSymbolFilter symbolFilter, int configPageSize) throws SqlException {
        super(groupByMetadata);
        this.base = base;
        this.groupBySymbolColIndex = symbolFilter.getColumnIndex();
        this.queryToFrameColumnMapping = new int[columns.size()];
        this.firstLastIndexByCol = new int[columns.size()];
        this.isKeyColumn = new boolean[columns.size()];
        this.crossFrameRow = new LongList(columns.size());
        this.crossFrameRow.setPos(columns.size());
        this.timestampIndex = timestampIndex;
        this.buildFirstLastIndex(this.firstLastIndexByCol, this.queryToFrameColumnMapping, metadata, columns, timestampIndex, this.isKeyColumn);
        int blockSize = metadata.getIndexValueBlockCapacity(this.groupBySymbolColIndex);
        this.pageSize = configPageSize < 16 ? Math.max(blockSize, 16) : configPageSize;
        this.maxSamplePeriodSize = this.pageSize * 4;
        int outSize = this.pageSize << 2;
        this.rowIdOutAddress = new DirectLongList(outSize, 18);
        this.rowIdOutAddress.setPos(outSize);
        this.samplePeriodAddress = new DirectLongList(this.pageSize, 18);
        this.symbolFilter = symbolFilter;
        this.sampleByFirstLastRecordCursor = new SampleByFirstLastRecordCursor(timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        PageFrameCursor pageFrameCursor = this.base.getPageFrameCursor(executionContext, 0);
        int groupByIndexKey = this.symbolFilter.getSymbolFilterKey();
        if (groupByIndexKey == -2) {
            Misc.free(pageFrameCursor);
            return EmptyTableRecordCursor.INSTANCE;
        }
        try {
            this.sampleByFirstLastRecordCursor.of(pageFrameCursor, groupByIndexKey, executionContext);
            return this.sampleByFirstLastRecordCursor;
        }
        catch (Throwable e) {
            Misc.free(pageFrameCursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        int i;
        sink.type("SampleByFirstLast");
        sink.attr("keys");
        boolean first = true;
        sink.val('[');
        for (i = 0; i < this.isKeyColumn.length; ++i) {
            if (!this.isKeyColumn[i]) continue;
            if (first) {
                first = false;
            } else {
                sink.val(", ");
            }
            sink.putBaseColumnName(i);
        }
        sink.val(']');
        sink.attr("values");
        first = true;
        sink.val('[');
        for (i = 0; i < this.isKeyColumn.length; ++i) {
            if (this.isKeyColumn[i]) continue;
            if (first) {
                first = false;
            } else {
                sink.val(", ");
            }
            sink.val(this.firstLastIndexByCol[i] == 1 ? "last" : "first").val('(');
            sink.putBaseColumnName(i);
            sink.val(')');
        }
        sink.val(']');
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private void buildFirstLastIndex(int[] firstLastIndex, int[] queryToFrameColumnMapping, RecordMetadata metadata, ObjList<QueryColumn> columns, int timestampIndex, boolean[] isKeyColumn) throws SqlException {
        int n = firstLastIndex.length;
        for (int i = 0; i < n; ++i) {
            int underlyingColIndex;
            QueryColumn column = columns.getQuick(i);
            ExpressionNode ast = column.getAst();
            int resultSetColumnType = this.getMetadata().getColumnType(i);
            if (ast.rhs != null) {
                if (SqlKeywords.isLastKeyword(ast.token)) {
                    firstLastIndex[i] = 1;
                } else if (SqlKeywords.isFirstKeyword(ast.token)) {
                    firstLastIndex[i] = 0;
                } else {
                    throw SqlException.$(ast.position, "expected first() or last() functions but got ").put(ast.token);
                }
                queryToFrameColumnMapping[i] = underlyingColIndex = metadata.getColumnIndex(ast.rhs.token);
                int underlyingType = metadata.getColumnType(underlyingColIndex);
                if (underlyingType == resultSetColumnType && ColumnType.pow2SizeOf(resultSetColumnType) <= 3) continue;
                throw SqlException.$(ast.position, "column \"").put(metadata.getColumnName(underlyingColIndex)).put("\": first(), last() is not supported on data type ").put(ColumnType.nameOf(underlyingType)).put(" ");
            }
            underlyingColIndex = metadata.getColumnIndex(ast.token);
            isKeyColumn[i] = true;
            queryToFrameColumnMapping[i] = underlyingColIndex;
            if (underlyingColIndex != timestampIndex) continue;
            this.groupByTimestampIndex = i;
        }
    }

    @Override
    protected void _close() {
        this.base.close();
        this.rowIdOutAddress = Misc.free(this.rowIdOutAddress);
        this.samplePeriodAddress = Misc.free(this.samplePeriodAddress);
    }

    private class SampleByFirstLastRecordCursor
    extends AbstractSampleByCursor {
        private static final int CROSS_ROW_STATE_REFS_UPDATED = 2;
        private static final int CROSS_ROW_STATE_SAVED = 1;
        private static final int NONE = 0;
        private static final int STATE_DONE = 7;
        private static final int STATE_FETCH_NEXT_DATA_FRAME = 1;
        private static final int STATE_FETCH_NEXT_INDEX_FRAME = 3;
        private static final int STATE_OUT_BUFFER_FULL = 4;
        private static final int STATE_RETURN_LAST_ROW = 6;
        private static final int STATE_SEARCH = 5;
        private static final int STATE_START = 0;
        private final SampleByFirstLastRecord record;
        private int crossRowState;
        private PageFrame currentFrame;
        private long currentRow;
        private long dataFrameHi;
        private long dataFrameLo;
        private long frameNextRowId;
        private int groupBySymbolKey;
        private IndexFrameCursor indexCursor;
        private IndexFrame indexFrame;
        private int indexFramePosition;
        private boolean initialized;
        private PageFrameCursor pageFrameCursor;
        private long prevSamplePeriodOffset;
        private int rowsFound;
        private long samplePeriodIndexOffset;
        private long samplePeriodStart;
        private int state;

        public SampleByFirstLastRecordCursor(TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
            super(timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
            this.record = new SampleByFirstLastRecord();
            this.dataFrameHi = -1L;
            this.dataFrameLo = -1L;
            this.frameNextRowId = -1L;
            this.indexFramePosition = -1;
            this.prevSamplePeriodOffset = 0L;
            this.samplePeriodIndexOffset = 0L;
        }

        @Override
        public void close() {
            this.pageFrameCursor = Misc.free(this.pageFrameCursor);
        }

        public long getNextTimestamp() {
            long lastTimestampLocUtc = this.localEpoch - this.tzOffset;
            long nextLastTimestampLoc = this.timestampSampler.nextTimestamp(this.localEpoch);
            if (nextLastTimestampLoc - this.tzOffset >= this.nextDstUtc) {
                this.tzOffset = this.rules.getOffset(nextLastTimestampLoc - this.tzOffset);
                this.nextDstUtc = this.rules.getNextDST(nextLastTimestampLoc - this.tzOffset);
                while (nextLastTimestampLoc - this.tzOffset <= lastTimestampLocUtc) {
                    nextLastTimestampLoc = this.timestampSampler.nextTimestamp(nextLastTimestampLoc);
                }
            }
            this.localEpoch = nextLastTimestampLoc;
            return this.localEpoch - this.tzOffset;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.pageFrameCursor.getSymbolTable(SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[columnIndex]);
        }

        @Override
        public boolean hasNext() {
            if (++this.currentRow < (long)(this.rowsFound - 1)) {
                this.record.of(this.currentRow);
                return true;
            }
            return this.hasNext0();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.pageFrameCursor.newSymbolTable(SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[columnIndex]);
        }

        @Override
        public long size() {
            return -1L;
        }

        public long startFrom(long timestamp) {
            if (!this.initialized || timestamp != this.localEpoch - this.tzOffset) {
                if (this.rules != null) {
                    this.tzOffset = this.rules.getOffset(timestamp);
                    this.tzOffset = this.rules.getOffset(timestamp + this.tzOffset);
                    this.nextDstUtc = this.rules.getNextDST(timestamp + this.tzOffset);
                }
                this.localEpoch = this.fixedOffset != Long.MIN_VALUE ? this.timestampSampler.round(timestamp + this.tzOffset - this.fixedOffset) + this.fixedOffset : timestamp + this.tzOffset;
                this.initialized = true;
            }
            return this.localEpoch - this.tzOffset;
        }

        @Override
        public void toTop() {
            this.rowsFound = 0;
            this.currentRow = 0;
            this.dataFrameHi = -1L;
            this.dataFrameLo = -1L;
            this.frameNextRowId = -1L;
            this.state = 0;
            this.crossRowState = 0;
            this.pageFrameCursor.toTop();
        }

        private void checkCrossRowAfterFoundBufferIterated() {
            if (this.crossRowState != 0 && this.rowsFound > 1) {
                long lastFoundIndex = (long)(this.rowsFound - 1) << 2;
                SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.set(0L, SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(lastFoundIndex + 0L));
                SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.set(1L, SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(lastFoundIndex + 1L));
                SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.set(2L, SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(lastFoundIndex + 2L));
                this.crossRowState = 2;
            }
            if (this.crossRowState == 2) {
                this.saveFirstLastValuesToCrossFrameRowBuffer();
                this.crossRowState = 1;
            }
        }

        private void checkSaveLastValues(boolean zeroRowLastIdUpdated) {
            if (this.crossRowState != 0) {
                if (zeroRowLastIdUpdated) {
                    this.saveLastValuesToBuffer();
                    this.crossRowState = 1;
                }
            } else if (this.rowsFound > 0) {
                this.saveFirstLastValuesToCrossFrameRowBuffer();
                this.crossRowState = 1;
            }
        }

        private int fillSamplePeriodsUntil(long lastInDataTimestamp) {
            long nextTs = this.samplePeriodStart;
            long currentTs = Long.MIN_VALUE;
            nextTs = this.startFrom(nextTs);
            SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.clear();
            for (int i = 0; i < SampleByFirstLastRecordCursorFactory.this.maxSamplePeriodSize && currentTs <= lastInDataTimestamp; ++i) {
                currentTs = nextTs;
                nextTs = this.getNextTimestamp();
                assert (nextTs != currentTs) : "uh-oh, we may have got into an infinite loop with ts " + nextTs;
                SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.add(currentTs);
            }
            return (int)SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.size();
        }

        private int getNextState(int state) {
            switch (state) {
                case 0: {
                    this.samplePeriodIndexOffset = 0L;
                    this.prevSamplePeriodOffset = 0L;
                    this.crossRowState = 0;
                    this.samplePeriodStart = Long.MIN_VALUE;
                }
                case 1: {
                    this.currentFrame = this.pageFrameCursor.next();
                    if (this.currentFrame != null) {
                        this.record.switchFrame();
                        this.frameNextRowId = this.dataFrameLo = this.currentFrame.getPartitionLo();
                        this.dataFrameHi = this.dataFrameLo + this.currentFrame.getPageSize(SampleByFirstLastRecordCursorFactory.this.timestampIndex) / 8L;
                        BitmapIndexReader symbolIndexReader = this.currentFrame.getBitmapIndexReader(SampleByFirstLastRecordCursorFactory.this.groupBySymbolColIndex, 1);
                        this.indexCursor = symbolIndexReader.getFrameCursor(this.groupBySymbolKey, this.dataFrameLo, this.dataFrameHi);
                    } else {
                        return 6;
                    }
                }
                case 3: {
                    this.indexFrame = this.indexCursor.getNext();
                    this.indexFramePosition = 0;
                    long indexFrameAddress = this.indexFrame.getAddress();
                    if (this.indexFrame.getSize() == 0L && (indexFrameAddress != 0L || this.groupBySymbolKey != 0)) {
                        this.frameNextRowId = this.dataFrameHi;
                        return 1;
                    }
                    if (this.samplePeriodStart == Long.MIN_VALUE) {
                        long rowId = indexFrameAddress > 0L ? Unsafe.getUnsafe().getLong(indexFrameAddress) : this.dataFrameLo;
                        long offsetTimestampColumnAddress = this.currentFrame.getPageAddress(SampleByFirstLastRecordCursorFactory.this.timestampIndex) - this.dataFrameLo * 8L;
                        this.samplePeriodStart = Unsafe.getUnsafe().getLong(offsetTimestampColumnAddress + rowId * 8L);
                        this.startFrom(this.samplePeriodStart);
                    }
                }
                case 4: 
                case 5: {
                    int outPosition = this.crossRowState == 0 ? 0 : 1;
                    long offsetTimestampColumnAddress = this.currentFrame.getPageAddress(SampleByFirstLastRecordCursorFactory.this.timestampIndex) - this.dataFrameLo * 8L;
                    long iFrameAddress = this.indexFrame.getAddress();
                    long iFrameSize = this.indexFrame.getSize();
                    long lastIndexRowId = iFrameAddress > 0L ? Unsafe.getUnsafe().getLong(iFrameAddress + (iFrameSize - 1L) * 8L) : Long.MAX_VALUE;
                    long lastInDataRowId = Math.min(lastIndexRowId, this.dataFrameHi - 1L);
                    long lastInDataTimestamp = Unsafe.getUnsafe().getLong(offsetTimestampColumnAddress + lastInDataRowId * 8L);
                    int samplePeriodCount = this.fillSamplePeriodsUntil(lastInDataTimestamp);
                    this.rowsFound = BitmapIndexUtilsNative.findFirstLastInFrame(outPosition, this.frameNextRowId, this.dataFrameHi, offsetTimestampColumnAddress, this.dataFrameLo, iFrameAddress, iFrameSize, this.indexFramePosition, SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.getAddress(), samplePeriodCount, this.samplePeriodIndexOffset, SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.getAddress(), SampleByFirstLastRecordCursorFactory.this.pageSize);
                    boolean firstRowLastRowIdUpdated = this.rowsFound < 0;
                    this.rowsFound = Math.abs(this.rowsFound);
                    this.checkSaveLastValues(firstRowLastRowIdUpdated);
                    int lastOutIndex = this.rowsFound << 2;
                    this.prevSamplePeriodOffset = this.samplePeriodIndexOffset;
                    this.indexFramePosition = (int)SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(lastOutIndex + 0);
                    this.frameNextRowId = SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(lastOutIndex + 1);
                    this.samplePeriodIndexOffset = SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(lastOutIndex + 2);
                    this.samplePeriodStart = SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.get(this.samplePeriodIndexOffset - this.prevSamplePeriodOffset);
                    int newState = this.frameNextRowId >= this.dataFrameHi ? 1 : ((long)this.indexFramePosition >= iFrameSize ? (iFrameAddress > 0L ? 3 : 1) : (this.rowsFound == SampleByFirstLastRecordCursorFactory.this.pageSize - 1 ? 4 : (this.samplePeriodIndexOffset - this.prevSamplePeriodOffset == (long)(SampleByFirstLastRecordCursorFactory.this.maxSamplePeriodSize - 1) ? 5 : 1)));
                    if (this.rowsFound > 1) {
                        this.currentRow = 0L;
                        this.record.of(0L);
                        newState = -newState;
                    }
                    return newState;
                }
                case 6: {
                    if (this.crossRowState != 0) {
                        this.currentRow = 0L;
                        this.record.of(0L);
                        return -7;
                    }
                }
                case 7: {
                    return 7;
                }
            }
            throw new UnsupportedOperationException("Invalid state " + state);
        }

        private boolean hasNext0() {
            this.checkCrossRowAfterFoundBufferIterated();
            this.rowsFound = 0;
            while (this.state != 7) {
                this.state = this.getNextState(this.state);
                if (this.state >= 0) continue;
                this.state = -this.state;
                return true;
            }
            return false;
        }

        private void saveFirstLastValuesToCrossFrameRowBuffer() {
            int length = SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol.length;
            for (int i = 0; i < length; ++i) {
                if (i == SampleByFirstLastRecordCursorFactory.this.groupByTimestampIndex) {
                    long tsIndex = SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(2L) - this.prevSamplePeriodOffset;
                    SampleByFirstLastRecordCursorFactory.this.crossFrameRow.set(i, SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.get(tsIndex));
                    continue;
                }
                long rowId = SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[i]);
                this.saveRowIdValueToCrossRow(rowId, i);
            }
        }

        private void saveFixedColToBufferWithLongAlignment(int index, LongList crossFrameRow, int columnType, long pageAddress, long rowId) {
            switch (ColumnType.pow2SizeOf(columnType)) {
                case 3: {
                    crossFrameRow.set(index, Unsafe.getUnsafe().getLong(pageAddress + (rowId << 3)));
                    break;
                }
                case 2: {
                    crossFrameRow.set(index, Unsafe.getUnsafe().getInt(pageAddress + (rowId << 2)));
                    break;
                }
                case 1: {
                    crossFrameRow.set(index, Unsafe.getUnsafe().getShort(pageAddress + (rowId << 1)));
                    break;
                }
                case 0: {
                    crossFrameRow.set(index, Unsafe.getUnsafe().getByte(pageAddress + rowId));
                    break;
                }
                default: {
                    throw new CairoException().put("first(), last() cannot be used with column type ").put(ColumnType.nameOf(columnType));
                }
            }
        }

        private void saveLastValuesToBuffer() {
            int length = SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol.length;
            for (int columnIndex = 0; columnIndex < length; ++columnIndex) {
                if (SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[columnIndex] != 1) continue;
                int frameColIndex = SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[columnIndex];
                assert (this.currentFrame.getPageSize(frameColIndex) > SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(1L));
                this.saveRowIdValueToCrossRow(SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get(1L), columnIndex);
            }
        }

        private void saveRowIdValueToCrossRow(long rowId, int columnIndex) {
            int columnType = SampleByFirstLastRecordCursorFactory.this.getMetadata().getColumnType(columnIndex);
            int frameColIndex = SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[columnIndex];
            long pageAddress = this.currentFrame.getPageAddress(frameColIndex);
            if (pageAddress > 0L) {
                this.saveFixedColToBufferWithLongAlignment(columnIndex, SampleByFirstLastRecordCursorFactory.this.crossFrameRow, columnType, pageAddress, rowId);
            } else {
                SampleByFirstLastRecordCursorFactory.this.crossFrameRow.set(columnIndex, LongNullUtils.getLongNull(columnType));
            }
        }

        void of(PageFrameCursor pageFrameCursor, int groupBySymbolKey, SqlExecutionContext sqlExecutionContext) throws SqlException {
            this.pageFrameCursor = pageFrameCursor;
            this.groupBySymbolKey = groupBySymbolKey;
            this.toTop();
            this.parseParams(this, sqlExecutionContext);
            this.initialized = false;
        }

        private class SampleByFirstLastRecord
        implements Record {
            private final SampleByCrossRecord crossRecord = new SampleByCrossRecord();
            private final SampleByDataRecord dataRecord = new SampleByDataRecord();
            private Record currentRecord;

            private SampleByFirstLastRecord() {
            }

            @Override
            public byte getByte(int col) {
                return this.currentRecord.getByte(col);
            }

            @Override
            public char getChar(int col) {
                return this.currentRecord.getChar(col);
            }

            @Override
            public double getDouble(int col) {
                return this.currentRecord.getDouble(col);
            }

            @Override
            public float getFloat(int col) {
                return this.currentRecord.getFloat(col);
            }

            @Override
            public byte getGeoByte(int col) {
                return this.currentRecord.getGeoByte(col);
            }

            @Override
            public int getGeoInt(int col) {
                return this.currentRecord.getGeoInt(col);
            }

            @Override
            public long getGeoLong(int col) {
                return this.currentRecord.getGeoLong(col);
            }

            @Override
            public short getGeoShort(int col) {
                return this.currentRecord.getGeoShort(col);
            }

            @Override
            public int getInt(int col) {
                return this.currentRecord.getInt(col);
            }

            @Override
            public long getLong(int col) {
                return this.currentRecord.getLong(col);
            }

            @Override
            public short getShort(int col) {
                return this.currentRecord.getShort(col);
            }

            @Override
            public CharSequence getSym(int col) {
                return this.currentRecord.getSym(col);
            }

            @Override
            public long getTimestamp(int col) {
                return this.currentRecord.getTimestamp(col);
            }

            public void of(long index) {
                this.currentRecord = index == 0L ? this.crossRecord : this.dataRecord.of(SampleByFirstLastRecordCursor.this.currentRow);
            }

            public void switchFrame() {
                this.dataRecord.switchFrame();
            }

            private class SampleByDataRecord
            implements Record {
                private final long[] pageAddresses;
                private long currentRow;

                private SampleByDataRecord() {
                    this.pageAddresses = new long[SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping.length];
                }

                @Override
                public byte getByte(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getByte(pageAddress + this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]));
                    }
                    return 0;
                }

                @Override
                public char getChar(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getChar(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 1));
                    }
                    return '\u0000';
                }

                @Override
                public double getDouble(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getDouble(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 3));
                    }
                    return Double.NaN;
                }

                @Override
                public float getFloat(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getFloat(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 2));
                    }
                    return Float.NaN;
                }

                @Override
                public byte getGeoByte(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getByte(pageAddress + this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]));
                    }
                    return -1;
                }

                @Override
                public int getGeoInt(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getInt(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 2));
                    }
                    return -1;
                }

                @Override
                public long getGeoLong(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getLong(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 3));
                    }
                    return -1L;
                }

                @Override
                public short getGeoShort(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getShort(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 1));
                    }
                    return -1;
                }

                @Override
                public int getInt(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getInt(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 2));
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public long getLong(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        if (col != SampleByFirstLastRecordCursorFactory.this.timestampIndex) {
                            return Unsafe.getUnsafe().getLong(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 3));
                        }
                        return SampleByFirstLastRecordCursorFactory.this.samplePeriodAddress.get(this.getRowId(2) - SampleByFirstLastRecordCursor.this.prevSamplePeriodOffset);
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public short getShort(int col) {
                    long pageAddress = this.pageAddresses[col];
                    if (pageAddress > 0L) {
                        return Unsafe.getUnsafe().getShort(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 1));
                    }
                    return 0;
                }

                @Override
                public CharSequence getSym(int col) {
                    long pageAddress = this.pageAddresses[col];
                    int symbolId = pageAddress > 0L ? Unsafe.getUnsafe().getInt(pageAddress + (this.getRowId(SampleByFirstLastRecordCursorFactory.this.firstLastIndexByCol[col]) << 2)) : Integer.MIN_VALUE;
                    return SampleByFirstLastRecordCursor.this.pageFrameCursor.getSymbolTable(SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[col]).valueBOf(symbolId);
                }

                @Override
                public long getTimestamp(int col) {
                    return this.getLong(col);
                }

                public SampleByDataRecord of(long currentRow) {
                    this.currentRow = currentRow;
                    return this;
                }

                public void switchFrame() {
                    int length = this.pageAddresses.length;
                    for (int i = 0; i < length; ++i) {
                        this.pageAddresses[i] = SampleByFirstLastRecordCursor.this.currentFrame.getPageAddress(SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[i]);
                    }
                }

                private long getRowId(int col) {
                    return SampleByFirstLastRecordCursorFactory.this.rowIdOutAddress.get((this.currentRow << 2) + (long)col);
                }
            }

            private class SampleByCrossRecord
            implements Record {
                private SampleByCrossRecord() {
                }

                @Override
                public byte getByte(int col) {
                    return (byte)SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col);
                }

                @Override
                public char getChar(int col) {
                    return (char)SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col);
                }

                @Override
                public double getDouble(int col) {
                    return Double.longBitsToDouble(SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col));
                }

                @Override
                public float getFloat(int col) {
                    return Float.intBitsToFloat((int)SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col));
                }

                @Override
                public byte getGeoByte(int col) {
                    return this.getByte(col);
                }

                @Override
                public int getGeoInt(int col) {
                    return this.getInt(col);
                }

                @Override
                public long getGeoLong(int col) {
                    return this.getLong(col);
                }

                @Override
                public short getGeoShort(int col) {
                    return this.getShort(col);
                }

                @Override
                public int getInt(int col) {
                    return (int)SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col);
                }

                @Override
                public long getLong(int col) {
                    return SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col);
                }

                @Override
                public short getShort(int col) {
                    return (short)SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col);
                }

                @Override
                public CharSequence getSym(int col) {
                    int symbolId = (int)SampleByFirstLastRecordCursorFactory.this.crossFrameRow.getQuick(col);
                    return SampleByFirstLastRecordCursor.this.pageFrameCursor.getSymbolTable(SampleByFirstLastRecordCursorFactory.this.queryToFrameColumnMapping[col]).valueBOf(symbolId);
                }

                @Override
                public long getTimestamp(int col) {
                    return this.getLong(col);
                }
            }
        }
    }
}

