/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

public class CountRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final GenericRecordMetadata DEFAULT_COUNT_METADATA = new GenericRecordMetadata();
    private final RecordCursorFactory base;
    private final CountRecordCursor cursor = new CountRecordCursor();

    public CountRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory base) {
        super(metadata);
        this.base = base;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(this.base.getCursor(executionContext), executionContext.getCircuitBreaker());
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Count");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    static {
        DEFAULT_COUNT_METADATA.add(new TableColumnMetadata("count", 6));
    }

    private static class CountRecordCursor
    implements NoRandomAccessRecordCursor {
        private final CountRecord countRecord = new CountRecord();
        private RecordCursor baseCursor;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long count;
        private boolean hasNext = true;

        private CountRecordCursor() {
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
        }

        @Override
        public Record getRecord() {
            return this.countRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.baseCursor != null) {
                while (this.baseCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    ++this.count;
                }
                this.baseCursor = Misc.free(this.baseCursor);
            }
            if (this.hasNext) {
                this.hasNext = false;
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.hasNext = true;
        }

        private void of(RecordCursor baseCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            this.baseCursor = baseCursor;
            this.circuitBreaker = circuitBreaker;
            long size = baseCursor.size();
            if (size < 0L) {
                this.count = 0L;
            } else {
                this.count = size;
                this.baseCursor = Misc.free(baseCursor);
            }
            this.toTop();
        }

        private class CountRecord
        implements Record {
            private CountRecord() {
            }

            @Override
            public long getLong(int col) {
                return CountRecordCursor.this.count;
            }
        }
    }
}

