/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.AbstractSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNoRecordSampleByCursor
extends AbstractSampleByCursor {
    protected final ObjList<GroupByFunction> groupByFunctions;
    protected final GroupByFunctionsUpdater groupByFunctionsUpdater;
    protected final int timestampIndex;
    private final ObjList<Function> recordFunctions;
    protected RecordCursor baseCursor;
    protected Record baseRecord;
    protected SqlExecutionCircuitBreaker circuitBreaker;
    protected long nextSampleLocalEpoch;
    protected long sampleLocalEpoch;
    protected long topTzOffset;
    private boolean areTimestampsInitialized;
    private boolean isNotKeyedLoopInitialized;
    private long topLocalEpoch;
    private long topNextDst;

    public AbstractNoRecordSampleByCursor(ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        this.timestampIndex = timestampIndex;
        this.recordFunctions = recordFunctions;
        this.groupByFunctions = groupByFunctions;
        this.groupByFunctionsUpdater = groupByFunctionsUpdater;
    }

    @Override
    public void close() {
        Misc.free(this.baseCursor);
        Misc.clearObjList(this.groupByFunctions);
        this.circuitBreaker = null;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.recordFunctions.getQuick(columnIndex));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return ((SymbolFunction)this.recordFunctions.getQuick(columnIndex)).newSymbolTable();
    }

    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        this.prevDst = Long.MIN_VALUE;
        this.parseParams(baseCursor, executionContext);
        this.topNextDst = this.nextDstUtc;
        this.baseCursor = baseCursor;
        this.baseRecord = baseCursor.getRecord();
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isNotKeyedLoopInitialized = false;
        this.areTimestampsInitialized = false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        GroupByUtils.toTop(this.recordFunctions);
        this.baseCursor.toTop();
        this.localEpoch = this.topLocalEpoch;
        this.sampleLocalEpoch = this.nextSampleLocalEpoch = this.topLocalEpoch;
        this.tzOffset = this.topTzOffset;
        this.prevDst = Long.MIN_VALUE;
        this.nextDstUtc = this.topNextDst;
        this.baseRecord = this.baseCursor.getRecord();
        this.isNotKeyedLoopInitialized = false;
        this.areTimestampsInitialized = false;
    }

    private void kludge(long newTzOffset) {
        this.sampleLocalEpoch += newTzOffset - this.tzOffset;
        this.nextSampleLocalEpoch = this.sampleLocalEpoch;
        this.tzOffset = newTzOffset;
    }

    protected long adjustDst(long timestamp, @Nullable MapValue mapValue, long nextSampleTimestamp) {
        long utcTimestamp = timestamp - this.tzOffset;
        if (utcTimestamp < this.nextDstUtc) {
            return timestamp;
        }
        long newTzOffset = this.rules.getOffset(utcTimestamp);
        this.prevDst = this.nextDstUtc;
        this.nextDstUtc = this.rules.getNextDST(utcTimestamp);
        if (timestamp - (this.tzOffset - newTzOffset) < nextSampleTimestamp) {
            this.updateValueWhenClockMovesBack(mapValue);
            this.localEpoch = this.nextSampleLocalEpoch = this.timestampSampler.round(timestamp);
            this.sampleLocalEpoch += newTzOffset - this.tzOffset;
            this.tzOffset = newTzOffset;
            return Long.MIN_VALUE;
        }
        this.kludge(newTzOffset);
        return utcTimestamp + newTzOffset;
    }

    protected void adjustDstInFlight(long utcEpoch) {
        if (utcEpoch < this.nextDstUtc) {
            return;
        }
        long daylightSavings = this.rules.getOffset(utcEpoch);
        this.prevDst = this.nextDstUtc;
        this.nextDstUtc = this.rules.getNextDST(utcEpoch);
        this.kludge(daylightSavings);
    }

    protected long getBaseRecordTimestamp() {
        return this.baseRecord.getTimestamp(this.timestampIndex) + this.tzOffset;
    }

    protected void initTimestamps() {
        if (this.areTimestampsInitialized) {
            return;
        }
        if (!this.baseCursor.hasNext()) {
            this.baseRecord = null;
            return;
        }
        long timestamp = this.baseRecord.getTimestamp(this.timestampIndex);
        if (this.rules != null) {
            this.tzOffset = this.rules.getOffset(timestamp);
            this.nextDstUtc = this.rules.getNextDST(timestamp);
        }
        if (this.tzOffset == 0L && this.fixedOffset == Long.MIN_VALUE) {
            this.timestampSampler.setStart(timestamp);
        } else {
            this.timestampSampler.setStart(this.fixedOffset != Long.MIN_VALUE ? this.fixedOffset : 0L);
        }
        this.topTzOffset = this.tzOffset;
        this.topNextDst = this.nextDstUtc;
        this.topLocalEpoch = this.localEpoch = this.timestampSampler.round(timestamp + this.tzOffset);
        this.sampleLocalEpoch = this.nextSampleLocalEpoch = this.localEpoch;
        this.areTimestampsInitialized = true;
    }

    protected void nextSamplePeriod(long timestamp) {
        this.localEpoch = this.timestampSampler.round(timestamp);
        if (this.localEpoch - this.tzOffset < this.prevDst) {
            this.localEpoch += this.tzOffset;
        }
        GroupByUtils.toTop(this.groupByFunctions);
    }

    protected boolean notKeyedLoop(MapValue mapValue) {
        if (!this.isNotKeyedLoopInitialized) {
            this.sampleLocalEpoch = this.localEpoch;
            this.nextSampleLocalEpoch = this.localEpoch;
            this.groupByFunctionsUpdater.updateNew(mapValue, this.baseRecord);
            this.isNotKeyedLoopInitialized = true;
        }
        long next = this.timestampSampler.nextTimestamp(this.localEpoch);
        while (this.baseCursor.hasNext()) {
            long timestamp = this.getBaseRecordTimestamp();
            if (timestamp < next) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.adjustDstInFlight(timestamp - this.tzOffset);
                this.groupByFunctionsUpdater.updateExisting(mapValue, this.baseRecord);
                continue;
            }
            if ((timestamp = this.adjustDst(timestamp, mapValue, next)) == Long.MIN_VALUE) continue;
            this.nextSamplePeriod(timestamp);
            this.isNotKeyedLoopInitialized = false;
            return true;
        }
        this.baseRecord = null;
        this.isNotKeyedLoopInitialized = false;
        return true;
    }

    protected void updateValueWhenClockMovesBack(MapValue value) {
        this.groupByFunctionsUpdater.updateExisting(value, this.baseRecord);
    }

    protected class TimestampFunc
    extends TimestampFunction
    implements Function {
        protected TimestampFunc() {
        }

        @Override
        public long getTimestamp(Record rec) {
            return AbstractNoRecordSampleByCursor.this.sampleLocalEpoch - AbstractNoRecordSampleByCursor.this.tzOffset;
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("Timestamp");
        }
    }
}

