/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class ConcatFunctionFactory
implements FunctionFactory {
    private static final ObjList<TypeAdapter> adapterReferences = new ObjList();

    @Override
    public String getSignature() {
        return "concat(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        ObjList<Function> functions = new ObjList<Function>(args.size());
        functions.addAll(args);
        return new ConcatFunction(functions);
    }

    private static void sinkBin(CharSink sink, Function function, Record record) {
        sink.put('[');
        sink.put(']');
    }

    private static void sinkBool(CharSink sink, Function function, Record record) {
        sink.put(function.getBool(record));
    }

    private static void sinkByte(CharSink sink, Function function, Record record) {
        sink.put(function.getByte(record));
    }

    private static void sinkChar(CharSink sink, Function function, Record record) {
        sink.put(function.getChar(record));
    }

    private static void sinkDate(CharSink sink, Function function, Record record) {
        sink.put(function.getDate(record));
    }

    private static void sinkDouble(CharSink sink, Function function, Record record) {
        sink.put(function.getDouble(record));
    }

    private static void sinkFloat(CharSink sink, Function function, Record record) {
        sink.put(function.getFloat(record), 3);
    }

    private static void sinkInt(CharSink sink, Function function, Record record) {
        sink.put(function.getInt(record));
    }

    private static void sinkLong(CharSink sink, Function function, Record record) {
        sink.put(function.getLong(record));
    }

    private static void sinkLong256(CharSink sink, Function function, Record record) {
        function.getLong256(record, sink);
    }

    private static void sinkNull(CharSink sink, Function function, Record record) {
    }

    private static void sinkShort(CharSink sink, Function function, Record record) {
        sink.put(function.getShort(record));
    }

    private static void sinkStr(CharSink sink, Function function, Record record) {
        function.getStr(record, sink);
    }

    private static void sinkSymbol(CharSink sink, Function function, Record record) {
        sink.put(function.getSymbol(record));
    }

    private static void sinkTimestamp(CharSink sink, Function function, Record record) {
        sink.put(function.getTimestamp(record));
    }

    private static void sinkUuid(CharSink sink, Function function, Record record) {
        long lo = function.getLong128Lo(record);
        long hi = function.getLong128Hi(record);
        SqlUtil.implicitCastUuidAsStr(lo, hi, sink);
    }

    static {
        adapterReferences.extendAndSet(13, ConcatFunctionFactory::sinkLong256);
        adapterReferences.extendAndSet(1, ConcatFunctionFactory::sinkBool);
        adapterReferences.extendAndSet(2, ConcatFunctionFactory::sinkByte);
        adapterReferences.extendAndSet(3, ConcatFunctionFactory::sinkShort);
        adapterReferences.extendAndSet(4, ConcatFunctionFactory::sinkChar);
        adapterReferences.extendAndSet(5, ConcatFunctionFactory::sinkInt);
        adapterReferences.extendAndSet(6, ConcatFunctionFactory::sinkLong);
        adapterReferences.extendAndSet(9, ConcatFunctionFactory::sinkFloat);
        adapterReferences.extendAndSet(10, ConcatFunctionFactory::sinkDouble);
        adapterReferences.extendAndSet(11, ConcatFunctionFactory::sinkStr);
        adapterReferences.extendAndSet(12, ConcatFunctionFactory::sinkSymbol);
        adapterReferences.extendAndSet(18, ConcatFunctionFactory::sinkBin);
        adapterReferences.extendAndSet(7, ConcatFunctionFactory::sinkDate);
        adapterReferences.extendAndSet(8, ConcatFunctionFactory::sinkTimestamp);
        adapterReferences.extendAndSet(19, ConcatFunctionFactory::sinkUuid);
        adapterReferences.extendAndSet(29, ConcatFunctionFactory::sinkNull);
    }

    private static class ConcatFunction
    extends StrFunction
    implements MultiArgFunction {
        private final ObjList<TypeAdapter> adaptors;
        private final int functionCount;
        private final ObjList<Function> functions;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public ConcatFunction(ObjList<Function> functions) {
            this.functions = functions;
            this.functionCount = functions.size();
            this.adaptors = new ObjList(this.functionCount);
            for (int i = 0; i < this.functionCount; ++i) {
                this.adaptors.add(adapterReferences.getQuick(functions.getQuick(i).getType()));
            }
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.functions;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            for (int i = 0; i < this.functionCount; ++i) {
                this.adaptors.getQuick(i).sink(sink, this.functions.getQuick(i), rec);
            }
        }

        @Override
        public CharSequence getStr(Record rec) {
            this.sinkA.clear();
            this.getStr(rec, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            this.getStr(rec, this.sinkB);
            return this.sinkB;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("concat(").val(this.functions).val(')');
        }
    }

    @FunctionalInterface
    private static interface TypeAdapter {
        public void sink(CharSink var1, Function var2, Record var3);
    }
}

