/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class LtStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(SS)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant() && !b.isConstant()) {
            CharSequence constValue = a.getStr(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new ConstOnLeftFunc(constValue, b);
        }
        if (!a.isConstant() && b.isConstant()) {
            CharSequence constValue = b.getStr(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new ConstOnRightFunc(a, constValue);
        }
        return new Func(a, b);
    }

    private static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence l = this.left.getStr(rec);
            CharSequence r = this.right.getStrB(rec);
            if (l == null || r == null) {
                return false;
            }
            return this.negated == Chars.compare(l, r) >= 0;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public String getName() {
            if (this.negated) {
                return ">=";
            }
            return "<";
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.right);
        }
    }

    private static class ConstOnRightFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final CharSequence constant;
        private final Function left;

        public ConstOnRightFunc(Function left, CharSequence constant) {
            this.left = left;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence l = this.left.getStrB(rec);
            if (l == null) {
                return false;
            }
            return this.negated == Chars.compare(l, this.constant) >= 0;
        }

        @Override
        public String getName() {
            if (this.negated) {
                return ">=";
            }
            return "<";
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val("<");
            }
            sink.val(this.constant);
        }
    }

    private static class ConstOnLeftFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final CharSequence constant;
        private final Function right;

        public ConstOnLeftFunc(CharSequence constant, Function right) {
            this.constant = constant;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.right;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence r = this.right.getStrB(rec);
            if (r == null) {
                return false;
            }
            return this.negated == Chars.compare(this.constant, r) >= 0;
        }

        @Override
        public String getName() {
            if (this.negated) {
                return ">=";
            }
            return "<";
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.constant);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val("<");
            }
            sink.val(this.right);
        }
    }
}

