/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;

public class EqLong256StrFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<Long256Decoder> DECODER = ThreadLocal.withInitial(() -> new Long256Decoder());

    @Override
    public String getSignature() {
        return "=(Hs)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(1);
        if (ColumnType.isNull(arg.getType())) {
            return new Func(arg);
        }
        return DECODER.get().newInstance(args.getQuick(0), arg.getStr(null));
    }

    private static class Long256Decoder {
        private long long0;
        private long long1;
        private long long2;
        private long long3;
        private final Long256Acceptor decoder = this::setAll;

        private Long256Decoder() {
        }

        public void setAll(long l0, long l1, long l2, long l3) {
            this.long0 = l0;
            this.long1 = l1;
            this.long2 = l2;
            this.long3 = l3;
        }

        private Func newInstance(Function arg, CharSequence hexLong256) {
            Long256FromCharSequenceDecoder.decode(hexLong256, 2, hexLong256.length(), this.decoder);
            return new Func(arg, this.long0, this.long1, this.long2, this.long3);
        }
    }

    private static class Func
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private static final Long256 NULL = Long256Impl.NULL_LONG256;
        private final Function arg;
        private final long long0;
        private final long long1;
        private final long long2;
        private final long long3;

        public Func(Function arg) {
            this(arg, NULL.getLong0(), NULL.getLong1(), NULL.getLong2(), NULL.getLong3());
        }

        public Func(Function arg, long long0, long long1, long long2, long long3) {
            this.arg = arg;
            this.long0 = long0;
            this.long1 = long1;
            this.long2 = long2;
            this.long3 = long3;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            Long256 value = this.arg.getLong256A(rec);
            return this.negated != (value.getLong0() == this.long0 && value.getLong1() == this.long1 && value.getLong2() == this.long2 && value.getLong3() == this.long3);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val('=');
            sink.val(this.long0, this.long1, this.long2, this.long3);
        }
    }
}

