/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.TimestampFloorFunctions;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class TimestampFloorFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "timestamp_floor(sN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence str = args.getQuick(0).getStr(null);
        int stride = 1;
        int c = 0;
        if (str != null) {
            if (str.length() == 1) {
                c = str.charAt(0);
            } else if (str.length() > 1) {
                c = str.charAt(str.length() - 1);
                try {
                    stride = Numbers.parseInt(str, 0, str.length() - 1);
                    if (stride <= 0) {
                        c = 1;
                    }
                }
                catch (NumericException ignored) {
                    c = 1;
                }
            } else {
                c = 1;
            }
        }
        switch (c) {
            case 77: {
                return new TimestampFloorFunctions.TimestampFloorMMFunction(args.getQuick(1), stride);
            }
            case 121: {
                return new TimestampFloorFunctions.TimestampFloorYYYYFunction(args.getQuick(1), stride);
            }
            case 119: {
                return new TimestampFloorFunctions.TimestampFloorWWFunction(args.getQuick(1), stride);
            }
            case 100: {
                return new TimestampFloorFunctions.TimestampFloorDDFunction(args.getQuick(1), stride);
            }
            case 104: {
                return new TimestampFloorFunctions.TimestampFloorHHFunction(args.getQuick(1), stride);
            }
            case 109: {
                return new TimestampFloorFunctions.TimestampFloorMIFunction(args.getQuick(1), stride);
            }
            case 115: {
                return new TimestampFloorFunctions.TimestampFloorSSFunction(args.getQuick(1), stride);
            }
            case 84: {
                return new TimestampFloorFunctions.TimestampFloorMSFunction(args.getQuick(1), stride);
            }
            case 0: {
                throw SqlException.position(argPositions.getQuick(0)).put("invalid unit 'null'");
            }
        }
        throw SqlException.position(argPositions.getQuick(0)).put("invalid unit '").put(str).put('\'');
    }
}

