/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NullIfIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(II)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new NullIfIntFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class NullIfIntFunction
    extends IntFunction
    implements BinaryFunction {
        private final Function intFunc1;
        private final Function intFunc2;

        public NullIfIntFunction(Function intFunc1, Function intFunc2) {
            this.intFunc1 = intFunc1;
            this.intFunc2 = intFunc2;
        }

        @Override
        public int getInt(Record rec) {
            return this.intFunc1.getInt(rec) == this.intFunc2.getInt(rec) ? Integer.MIN_VALUE : this.intFunc1.getInt(rec);
        }

        @Override
        public Function getLeft() {
            return this.intFunc1;
        }

        @Override
        public Function getRight() {
            return this.intFunc2;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("nullif(").val(this.intFunc1).val(',').val(this.intFunc2).val(')');
        }
    }
}

