/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GeoLongFunction;

public class GeoLongColumn
extends GeoLongFunction {
    private static final GeoLongColumn[] COLUMNS;
    private final int columnIndex;

    public GeoLongColumn(int columnIndex, int columnType) {
        super(columnType);
        this.columnIndex = columnIndex;
    }

    public static GeoLongColumn newInstance(int columnIndex, int columnType) {
        assert (ColumnType.getGeoHashBits(columnType) >= 32 && ColumnType.getGeoHashBits(columnType) <= 60);
        int bits = 29;
        if (columnIndex < 32) {
            return COLUMNS[columnIndex * 29 + ColumnType.getGeoHashBits(columnType) - 32];
        }
        return new GeoLongColumn(columnIndex, columnType);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getGeoLong(Record rec) {
        return rec.getGeoLong(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        int bits = 29;
        COLUMNS = new GeoLongColumn[32 * bits];
        for (int col = 0; col < 32; ++col) {
            for (int bit = 32; bit <= 60; ++bit) {
                GeoLongColumn.COLUMNS[col * bits + bit - 32] = new GeoLongColumn(col, ColumnType.getGeoHashTypeWithBits(bit));
            }
        }
    }
}

