/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class SimulateCrashFunctionFactory
implements FunctionFactory {
    private static final CairoErrorFunction CairoErrorInstance = new CairoErrorFunction();
    private static final CairoExceptionFunction CairoExceptionInstance = new CairoExceptionFunction();
    private static final SimulateCrashFunction CrashInstance = new SimulateCrashFunction();
    private static final DoNothingInstance Dummy = new DoNothingInstance();
    private static final OutOfMemoryFunction OutOfMemoryInstance = new OutOfMemoryFunction();

    @Override
    public String getSignature() {
        return "simulate_crash(a)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        if (configuration.getSimulateCrashEnabled()) {
            char killType = args.get(0).getChar(null);
            switch (killType) {
                case '0': {
                    return CrashInstance;
                }
                case 'M': {
                    return OutOfMemoryInstance;
                }
                case 'C': {
                    return CairoErrorInstance;
                }
                case 'D': {
                    return CairoExceptionInstance;
                }
            }
        }
        return Dummy;
    }

    private static class SimulateCrashFunction
    extends BooleanFunction {
        private SimulateCrashFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            Unsafe.getUnsafe().getLong(0L);
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("simulate_crash(dummy)");
        }
    }

    private static class OutOfMemoryFunction
    extends BooleanFunction {
        private OutOfMemoryFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            throw new OutOfMemoryError("simulate_crash('M')");
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("simulate_crash(oom)");
        }
    }

    private static class DoNothingInstance
    extends BooleanFunction {
        private DoNothingInstance() {
        }

        @Override
        public boolean getBool(Record rec) {
            return false;
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("simulate_crash(jvm)");
        }
    }

    private static class CairoExceptionFunction
    extends BooleanFunction {
        private CairoExceptionFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            throw CairoException.critical(1).put("simulated cairo exception");
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("simulate_crash(cairoException)");
        }
    }

    private static class CairoErrorFunction
    extends BooleanFunction {
        private CairoErrorFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            throw new CairoError("simulated cairo error");
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("simulate_crash(jvm)");
        }
    }
}

