/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.bool.InTimestampStrFunctionFactory;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InTimestampTimestampFunctionFactory
implements FunctionFactory {
    public static long tryParseTimestamp(CharSequence seq, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(seq, 0, seq.length());
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(position);
        }
    }

    @Override
    public String getSignature() {
        return "in(NV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        boolean allConst = true;
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 29: {
                    break;
                }
                default: {
                    throw SqlException.position(0).put("cannot compare TIMESTAMP with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            break;
        }
        if (allConst) {
            return new InTimestampConstFunction(args.getQuick(0), this.parseToTs(args, argPositions));
        }
        if (args.size() == 2 && ColumnType.isString(args.get(1).getType())) {
            return new InTimestampStrFunctionFactory.EqTimestampStrFunction(args.get(0), args.get(1));
        }
        return new InTimestampVarFunction(new ObjList<Function>(args));
    }

    private LongList parseToTs(ObjList<Function> args, IntList argPositions) throws SqlException {
        LongList res = new LongList(args.size() - 1);
        res.extendAndSet(args.size() - 2, 0L);
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            long val = Long.MIN_VALUE;
            switch (ColumnType.tagOf(func.getType())) {
                case 7: {
                    val = func.getDate(null);
                    val = val == Long.MIN_VALUE ? val : val * 1000L;
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    val = func.getTimestamp(null);
                    break;
                }
                case 11: 
                case 12: {
                    CharSequence tsValue = func.getStr(null);
                    val = tsValue != null ? InTimestampTimestampFunctionFactory.tryParseTimestamp(tsValue, argPositions.getQuick(i)) : Long.MIN_VALUE;
                }
            }
            res.setQuick(i - 1, val);
        }
        res.sort();
        return res;
    }

    private static class InTimestampVarFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InTimestampVarFunction(ObjList<Function> args) {
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.args.getQuick(0).getTimestamp(rec);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                long val = Long.MIN_VALUE;
                switch (ColumnType.tagOf(func.getType())) {
                    case 5: 
                    case 6: 
                    case 8: {
                        val = func.getTimestamp(rec);
                        break;
                    }
                    case 11: 
                    case 12: {
                        CharSequence str = func.getStr(rec);
                        long l = val = str != null ? IntervalUtils.tryParseTimestamp(str) : Long.MIN_VALUE;
                    }
                }
                if (val != ts) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }

    private static class InTimestampConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final LongList inList;
        private final Function tsFunc;

        public InTimestampConstFunction(Function tsFunc, LongList longList) {
            this.tsFunc = tsFunc;
            this.inList = longList;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.tsFunc.getTimestamp(rec);
            return this.negated != this.inList.binarySearch(ts, -1) >= 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.tsFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }
}

