/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Sv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = args.size();
        if (n == 1) {
            return BooleanConstant.FALSE;
        }
        ObjList<Function> deferredValues = null;
        CharSequenceHashSet set = new CharSequenceHashSet();
        block4: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 11: 
                case 12: 
                case 29: {
                    if (func.isRuntimeConstant()) {
                        if (deferredValues == null) {
                            deferredValues = new ObjList<Function>();
                        }
                        deferredValues.add(func);
                        continue block4;
                    }
                    CharSequence value = func.getStr(null);
                    if (value == null) {
                        set.addNull();
                    }
                    set.add(Chars.toString(value));
                    continue block4;
                }
                case 4: {
                    set.add(String.valueOf(func.getChar(null)));
                    continue block4;
                }
                default: {
                    throw SqlException.$(argPositions.getQuick(i), "STRING constant expected");
                }
            }
        }
        Function var = args.getQuick(0);
        if (var.isConstant() && deferredValues == null) {
            return BooleanConstant.of(set.contains(var.getStr(null)));
        }
        return new Func(var, set, deferredValues);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequenceHashSet deferredSet;
        private final ObjList<Function> deferredValues;
        private final CharSequenceHashSet set;

        public Func(Function arg, CharSequenceHashSet set, ObjList<Function> deferredValues) {
            this.arg = arg;
            this.set = set;
            this.deferredValues = deferredValues;
            this.deferredSet = deferredValues != null ? new CharSequenceHashSet() : null;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence val = this.arg.getStr(rec);
            return this.set.contains(val) || this.deferredSet != null && this.deferredSet.contains(val);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            if (this.deferredValues != null) {
                this.deferredSet.clear();
                int n = this.deferredValues.size();
                for (int i = 0; i < n; ++i) {
                    Function func = this.deferredValues.getQuick(i);
                    func.init(symbolTableSource, executionContext);
                    this.deferredSet.add(func.getStr(null));
                }
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            if (this.deferredValues != null) {
                sink.val('(');
            }
            sink.val(this.arg).val(" in ").val(this.set);
            if (this.deferredValues != null) {
                sink.val(" or ").val(this.arg).val(" in ").val(this.deferredValues).val(')');
            }
        }
    }
}

