/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.DoubleList;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InDoubleFunctionFactory
implements FunctionFactory {
    public static double tryParseDouble(CharSequence seq, int position) throws SqlException {
        try {
            return Numbers.parseDouble(seq);
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid DOUBLE value");
        }
    }

    @Override
    public String getSignature() {
        return "in(DV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        boolean allConst = true;
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 29: {
                    break;
                }
                default: {
                    throw SqlException.position(0).put("cannot compare DOUBLE with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            break;
        }
        if (allConst) {
            return new InDoubleConstFunction(args.getQuick(0), this.parseToDouble(args, argPositions));
        }
        return new InDoubleVarFunction(new ObjList<Function>(args));
    }

    private DoubleList parseToDouble(ObjList<Function> args, IntList argPositions) throws SqlException {
        DoubleList res = new DoubleList(args.size() - 1);
        res.extendAndSet(args.size() - 2, 0.0);
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            double val = Double.NaN;
            switch (ColumnType.tagOf(func.getType())) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    val = func.getDouble(null);
                    break;
                }
                case 11: 
                case 12: {
                    CharSequence tsValue = func.getStr(null);
                    val = tsValue != null ? InDoubleFunctionFactory.tryParseDouble(tsValue, argPositions.getQuick(i)) : Double.NaN;
                }
            }
            res.setQuick(i - 1, val);
        }
        res.sort();
        return res;
    }

    private static class InDoubleVarFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InDoubleVarFunction(ObjList<Function> args) {
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            double argVal = this.args.getQuick(0).getDouble(rec);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                double val = Double.NaN;
                switch (ColumnType.tagOf(func.getType())) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: {
                        val = func.getDouble(rec);
                        break;
                    }
                    case 11: 
                    case 12: {
                        val = Numbers.parseDoubleQuiet(func.getStr(rec));
                    }
                }
                if (!Numbers.equals(val, argVal)) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }

    private static class InDoubleConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function func;
        private final DoubleList inList;

        public InDoubleConstFunction(Function func, DoubleList doubleList) {
            this.func = func;
            this.inList = doubleList;
        }

        @Override
        public Function getArg() {
            return this.func;
        }

        @Override
        public boolean getBool(Record rec) {
            double val = this.func.getDouble(rec);
            return this.negated != this.inList.binarySearch(val, -1) >= 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.func);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }
}

