/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.analytic;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ReadOnlyObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedAnalyticRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final ObjList<AnalyticFunction> allFunctions;
    private final RecordCursorFactory base;
    private final ObjList<RecordComparator> comparators;
    private final CachedAnalyticRecordCursor cursor;
    private final ObjList<ObjList<AnalyticFunction>> orderedFunctions;
    private final int orderedGroupCount;
    @Nullable
    private final ObjList<AnalyticFunction> unorderedFunctions;
    private boolean closed = false;

    public CachedAnalyticRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordSink recordSink, GenericRecordMetadata metadata, ColumnTypes chainMetadata, ObjList<RecordComparator> comparators, ObjList<ObjList<AnalyticFunction>> orderedFunctions, @Nullable ObjList<AnalyticFunction> unorderedFunctions, @NotNull IntList columnIndexes) {
        super(metadata);
        int i;
        this.base = base;
        this.orderedGroupCount = comparators.size();
        assert (this.orderedGroupCount == orderedFunctions.size());
        this.orderedFunctions = orderedFunctions;
        this.comparators = comparators;
        RecordChain recordChain = new RecordChain(chainMetadata, recordSink, configuration.getSqlAnalyticStorePageSize(), configuration.getSqlAnalyticStoreMaxPages());
        ObjList<LongTreeChain> orderedSources = new ObjList<LongTreeChain>(this.orderedGroupCount);
        for (i = 0; i < this.orderedGroupCount; ++i) {
            orderedSources.add(new LongTreeChain(configuration.getSqlAnalyticTreeKeyPageSize(), configuration.getSqlAnalyticTreeKeyMaxPages(), configuration.getSqlAnalyticRowIdPageSize(), configuration.getSqlAnalyticRowIdMaxPages()));
        }
        this.cursor = new CachedAnalyticRecordCursor(columnIndexes, recordChain, orderedSources);
        this.allFunctions = new ObjList();
        int n = orderedFunctions.size();
        for (i = 0; i < n; ++i) {
            this.allFunctions.addAll((ReadOnlyObjList<AnalyticFunction>)orderedFunctions.getQuick(i));
        }
        if (unorderedFunctions != null) {
            this.allFunctions.addAll(unorderedFunctions);
        }
        this.unorderedFunctions = unorderedFunctions;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        this.cursor.of(baseCursor, executionContext);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("CachedAnalytic");
        sink.optAttr((CharSequence)"functions", this.allFunctions);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private void resetFunctions() {
        int n = this.allFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.allFunctions.getQuick(i).reset();
        }
    }

    @Override
    protected void _close() {
        if (this.closed) {
            return;
        }
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.freeObjList(this.allFunctions);
        this.closed = true;
    }

    class CachedAnalyticRecordCursor
    implements RecordCursor {
        private final IntList columnIndexes;
        private final ObjList<LongTreeChain> orderedSources;
        private final RecordChain recordChain;
        private RecordCursor base;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;
        private boolean isRecordChainBuilt;
        private long recordChainOffset;

        public CachedAnalyticRecordCursor(IntList columnIndexes, RecordChain recordChain, ObjList<LongTreeChain> orderedSources) {
            this.columnIndexes = columnIndexes;
            this.recordChain = recordChain;
            this.recordChain.setSymbolTableResolver(this);
            this.isOpen = true;
            this.orderedSources = orderedSources;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                Misc.free(this.base);
                Misc.free(this.recordChain);
                int n = this.orderedSources.size();
                for (int i = 0; i < n; ++i) {
                    Misc.free(this.orderedSources.getQuick(i));
                }
                CachedAnalyticRecordCursorFactory.this.resetFunctions();
                this.isOpen = false;
            }
        }

        @Override
        public Record getRecord() {
            return this.recordChain.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.recordChain.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
        }

        @Override
        public boolean hasNext() {
            if (!this.isRecordChainBuilt) {
                this.buildRecordChain();
            }
            this.isRecordChainBuilt = true;
            return this.recordChain.hasNext();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.recordChain.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.recordChain.size();
        }

        @Override
        public void toTop() {
            this.recordChain.toTop();
        }

        private void buildRecordChain() {
            Record record = this.base.getRecord();
            Record chainRecord = this.recordChain.getRecord();
            Record chainRightRecord = this.recordChain.getRecordB();
            if (CachedAnalyticRecordCursorFactory.this.orderedGroupCount > 0) {
                while (this.base.hasNext()) {
                    this.recordChainOffset = this.recordChain.put(record, this.recordChainOffset);
                    this.recordChain.recordAt(chainRecord, this.recordChainOffset);
                    for (int i = 0; i < CachedAnalyticRecordCursorFactory.this.orderedGroupCount; ++i) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        this.orderedSources.getQuick(i).put(chainRecord, this.recordChain, chainRightRecord, CachedAnalyticRecordCursorFactory.this.comparators.getQuick(i));
                    }
                }
            } else {
                while (this.base.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    this.recordChainOffset = this.recordChain.put(record, this.recordChainOffset);
                }
            }
            if (CachedAnalyticRecordCursorFactory.this.orderedGroupCount > 0) {
                for (int i = 0; i < CachedAnalyticRecordCursorFactory.this.orderedGroupCount; ++i) {
                    LongTreeChain tree = this.orderedSources.getQuick(i);
                    ObjList<AnalyticFunction> functions = CachedAnalyticRecordCursorFactory.this.orderedFunctions.getQuick(i);
                    LongTreeChain.TreeCursor cursor = tree.getCursor();
                    int functionCount = functions.size();
                    while (cursor.hasNext()) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        long offset = cursor.next();
                        this.recordChain.recordAt(chainRecord, offset);
                        for (int j = 0; j < functionCount; ++j) {
                            functions.getQuick(j).pass1(chainRecord, offset, this.recordChain);
                        }
                    }
                }
            }
            if (CachedAnalyticRecordCursorFactory.this.unorderedFunctions != null) {
                int n = CachedAnalyticRecordCursorFactory.this.unorderedFunctions.size();
                for (int j = 0; j < n; ++j) {
                    AnalyticFunction f = CachedAnalyticRecordCursorFactory.this.unorderedFunctions.getQuick(j);
                    this.recordChain.toTop();
                    while (this.recordChain.hasNext()) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        f.pass1(chainRecord, chainRecord.getRowId(), this.recordChain);
                    }
                }
            }
            this.recordChain.toTop();
        }

        private void of(RecordCursor base, SqlExecutionContext context) {
            this.base = base;
            this.isRecordChainBuilt = false;
            this.recordChainOffset = -1L;
            this.circuitBreaker = context.getCircuitBreaker();
            if (!this.isOpen) {
                this.recordChain.reopen();
                this.recordChain.setSymbolTableResolver(this);
                this.reopenTrees();
                this.reopen(CachedAnalyticRecordCursorFactory.this.allFunctions);
                this.isOpen = true;
            }
        }

        private void reopen(ObjList<?> list) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.getQuick(i) instanceof Reopenable)) continue;
                ((Reopenable)list.getQuick(i)).reopen();
            }
        }

        private void reopenTrees() {
            for (int i = 0; i < CachedAnalyticRecordCursorFactory.this.orderedGroupCount; ++i) {
                this.orderedSources.getQuick(i).reopen();
            }
        }
    }
}

