/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.constants.Long256Constant;
import io.questdb.griffin.engine.functions.constants.Long256NullConstant;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjectPool;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.DateFormatCompiler;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.fastdouble.FastFloatParser;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.Nullable;

public class SqlUtil {
    static final CharSequenceHashSet disallowedAliases = new CharSequenceHashSet();
    private static final DateFormat[] DATE_FORMATS;
    private static final DateFormat[] DATE_FORMATS_FOR_TIMESTAMP;
    private static final int DATE_FORMATS_FOR_TIMESTAMP_SIZE;
    private static final int DATE_FORMATS_SIZE;
    private static final ThreadLocal<Long256ConstantFactory> LONG256_FACTORY;

    public static void addSelectStar(QueryModel model, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<ExpressionNode> expressionNodePool) throws SqlException {
        model.addBottomUpColumn(SqlUtil.nextColumn(queryColumnPool, expressionNodePool, "*", "*"));
        model.setArtificialStar(true);
    }

    public static long dateToTimestamp(long millis) {
        return millis != Long.MIN_VALUE ? millis * 1000L : millis;
    }

    public static long expectMicros(CharSequence tok, int position) throws SqlException {
        int k = -1;
        int len = tok.length();
        for (int i = 0; i < len; ++i) {
            char c = tok.charAt(i);
            if (c >= '0' && c <= '9') continue;
            k = i;
            break;
        }
        if (k == -1) {
            throw SqlException.$(position + len, "expected interval qualifier in ").put(tok);
        }
        try {
            long interval = Numbers.parseLong(tok, 0, k);
            int nChars = len - k;
            if (nChars > 2) {
                throw SqlException.$(position + k, "expected 1/2 letter interval qualifier in ").put(tok);
            }
            switch (tok.charAt(k)) {
                case 's': {
                    if (nChars != 1) break;
                    return interval * 1000000L;
                }
                case 'm': {
                    if (nChars == 1) {
                        return interval * 60000000L;
                    }
                    if (tok.charAt(k + 1) != 's') break;
                    return interval * 1000L;
                }
                case 'h': {
                    if (nChars != 1) break;
                    return interval * 3600000000L;
                }
                case 'd': {
                    if (nChars != 1) break;
                    return interval * 86400000000L;
                }
                case 'u': {
                    if (nChars != 2 || tok.charAt(k + 1) != 's') break;
                    return interval;
                }
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        throw SqlException.$(position + len, "invalid interval qualifier ").put(tok);
    }

    public static CharSequence fetchNext(GenericLexer lexer) {
        int blockCount = 0;
        boolean lineComment = false;
        while (lexer.hasNext()) {
            CharSequence cs = lexer.next();
            if (lineComment) {
                if (!Chars.equals(cs, '\n') && !Chars.equals(cs, '\r')) continue;
                lineComment = false;
                continue;
            }
            if (Chars.equals((CharSequence)"--", cs)) {
                lineComment = true;
                continue;
            }
            if (Chars.equals((CharSequence)"/*", cs)) {
                ++blockCount;
                continue;
            }
            if (Chars.equals((CharSequence)"*/", cs) && blockCount > 0) {
                --blockCount;
                continue;
            }
            if (blockCount != 0 || !GenericLexer.WHITESPACE.excludes(cs)) continue;
            return cs;
        }
        return null;
    }

    public static byte implicitCastAsByte(long value, int fromType) {
        if (value >= -128L && value <= 127L) {
            return (byte)value;
        }
        throw ImplicitCastException.inconvertibleValue(value, fromType, 2);
    }

    public static char implicitCastAsChar(long value, int fromType) {
        if (value >= 0L && value <= 9L) {
            return (char)(value + 48L);
        }
        throw ImplicitCastException.inconvertibleValue(value, fromType, 4);
    }

    public static float implicitCastAsFloat(double value, int fromType) {
        if (value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || Double.isNaN(value)) {
            return (float)value;
        }
        throw ImplicitCastException.inconvertibleValue(value, fromType, 9);
    }

    public static int implicitCastAsInt(long value, int fromType) {
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw ImplicitCastException.inconvertibleValue(value, fromType, 5);
    }

    public static short implicitCastAsShort(long value, int fromType) {
        if (value >= -32768L && value <= 32767L) {
            return (short)value;
        }
        throw ImplicitCastException.inconvertibleValue(value, fromType, 3);
    }

    public static byte implicitCastCharAsByte(char value, int toType) {
        return SqlUtil.implicitCastCharAsType(value, toType);
    }

    public static byte implicitCastCharAsGeoHash(char value, int toType) {
        int v;
        if (value >= '0' && value <= '9' || (v = value | 0x20) > 97 && v <= 122 && v != 105 && v != 108 && v != 111) {
            int toBits = ColumnType.getGeoHashBits(toType);
            if (toBits < 5) {
                return (byte)GeoHashes.widen(GeoHashes.encodeChar(value), 5, toBits);
            }
            if (toBits == 5) {
                return GeoHashes.encodeChar(value);
            }
        }
        throw ImplicitCastException.inconvertibleValue(value, 4, toType);
    }

    public static byte implicitCastCharAsType(char value, int toType) {
        byte v = (byte)(value - 48);
        if (v > -1 && v < 10) {
            return v;
        }
        throw ImplicitCastException.inconvertibleValue(value, 4, toType);
    }

    public static byte implicitCastDoubleAsByte(double value) {
        if (value >= -128.0 && value <= 127.0) {
            return (byte)value;
        }
        if (Double.isNaN(value)) {
            return 0;
        }
        throw ImplicitCastException.inconvertibleValue(value, 9, 2);
    }

    public static float implicitCastDoubleAsFloat(double value) {
        double d = Math.abs(value);
        if (d >= (double)1.4E-45f && d <= 3.4028234663852886E38 || Double.isNaN(value) || Double.isInfinite(value) || d == 0.0) {
            return (float)value;
        }
        throw ImplicitCastException.inconvertibleValue(value, 10, 9);
    }

    public static int implicitCastDoubleAsInt(double value) {
        if (Double.isNaN(value)) {
            return Integer.MIN_VALUE;
        }
        return SqlUtil.implicitCastAsInt((long)value, 6);
    }

    public static long implicitCastDoubleAsLong(double value) {
        if (value > -9.223372036854776E18 && value <= 9.223372036854776E18) {
            return (long)value;
        }
        if (Double.isNaN(value)) {
            return Long.MIN_VALUE;
        }
        throw ImplicitCastException.inconvertibleValue(value, 10, 6);
    }

    public static short implicitCastDoubleAsShort(double value) {
        if (Double.isNaN(value)) {
            return 0;
        }
        return SqlUtil.implicitCastAsShort((long)value, 6);
    }

    public static byte implicitCastFloatAsByte(float value) {
        if (value >= -128.0f && value <= 127.0f) {
            return (byte)value;
        }
        if (Float.isNaN(value)) {
            return 0;
        }
        throw ImplicitCastException.inconvertibleValue(value, 9, 2);
    }

    public static int implicitCastFloatAsInt(float value) {
        if (value > -2.1474836E9f && value <= 2.1474836E9f) {
            return (int)value;
        }
        if (Float.isNaN(value)) {
            return Integer.MIN_VALUE;
        }
        throw ImplicitCastException.inconvertibleValue(value, 9, 5);
    }

    public static long implicitCastFloatAsLong(float value) {
        if (value > -9.223372E18f && value <= 9.223372E18f) {
            return (long)value;
        }
        if (Float.isNaN(value)) {
            return Long.MIN_VALUE;
        }
        throw ImplicitCastException.inconvertibleValue(value, 9, 6);
    }

    public static short implicitCastFloatAsShort(float value) {
        if (value >= -32768.0f && value <= 32767.0f) {
            return (short)value;
        }
        if (Float.isNaN(value)) {
            return 0;
        }
        throw ImplicitCastException.inconvertibleValue(value, 9, 3);
    }

    public static long implicitCastGeoHashAsGeoHash(long value, int fromType, int toType) {
        int fromBits = ColumnType.getGeoHashBits(fromType);
        int toBits = ColumnType.getGeoHashBits(toType);
        assert (fromBits >= toBits);
        return GeoHashes.widen(value, fromBits, toBits);
    }

    public static byte implicitCastIntAsByte(int value) {
        if (value != Integer.MIN_VALUE) {
            return SqlUtil.implicitCastAsByte(value, 5);
        }
        return 0;
    }

    public static short implicitCastIntAsShort(int value) {
        if (value != Integer.MIN_VALUE) {
            return SqlUtil.implicitCastAsShort(value, 5);
        }
        return 0;
    }

    public static byte implicitCastLongAsByte(long value) {
        if (value != Long.MIN_VALUE) {
            return SqlUtil.implicitCastAsByte(value, 6);
        }
        return 0;
    }

    public static int implicitCastLongAsInt(long value) {
        if (value != Long.MIN_VALUE) {
            return SqlUtil.implicitCastAsInt(value, 6);
        }
        return Integer.MIN_VALUE;
    }

    public static short implicitCastLongAsShort(long value) {
        if (value != Long.MIN_VALUE) {
            return SqlUtil.implicitCastAsShort(value, 6);
        }
        return 0;
    }

    public static byte implicitCastShortAsByte(short value) {
        return SqlUtil.implicitCastAsByte(value, 3);
    }

    public static byte implicitCastStrAsByte(CharSequence value) {
        if (value != null) {
            try {
                int res = Numbers.parseInt(value);
                if (res >= -128 && res <= 127) {
                    return (byte)res;
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            throw ImplicitCastException.inconvertibleValue(value, 11, 2);
        }
        return 0;
    }

    public static char implicitCastStrAsChar(CharSequence value) {
        if (value == null || value.length() == 0) {
            return '\u0000';
        }
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw ImplicitCastException.inconvertibleValue(value, 11, 4);
    }

    public static long implicitCastStrAsDate(CharSequence value) {
        if (value != null) {
            int hi = value.length();
            for (int i = 0; i < DATE_FORMATS_SIZE; ++i) {
                try {
                    return DATE_FORMATS[i].parse(value, 0, hi, DateFormatUtils.enLocale);
                }
                catch (NumericException numericException) {
                    continue;
                }
            }
            try {
                return Numbers.parseLong(value, 0, hi);
            }
            catch (NumericException e) {
                throw ImplicitCastException.inconvertibleValue(value, 11, 7);
            }
        }
        return Long.MIN_VALUE;
    }

    public static double implicitCastStrAsDouble(CharSequence value) {
        if (value != null) {
            try {
                return Numbers.parseDouble(value);
            }
            catch (NumericException e) {
                throw ImplicitCastException.inconvertibleValue(value, 11, 10);
            }
        }
        return Double.NaN;
    }

    public static float implicitCastStrAsFloat(CharSequence value) {
        if (value != null) {
            try {
                return FastFloatParser.parseFloat(value, 0, value.length(), true);
            }
            catch (NumericException ignored) {
                throw ImplicitCastException.inconvertibleValue(value, 11, 9);
            }
        }
        return Float.NaN;
    }

    public static int implicitCastStrAsInt(CharSequence value) {
        if (value != null) {
            try {
                return Numbers.parseInt(value);
            }
            catch (NumericException e) {
                throw ImplicitCastException.inconvertibleValue(value, 11, 5);
            }
        }
        return Integer.MIN_VALUE;
    }

    public static long implicitCastStrAsLong(CharSequence value) {
        if (value != null) {
            try {
                return Numbers.parseLong(value);
            }
            catch (NumericException e) {
                throw ImplicitCastException.inconvertibleValue(value, 11, 6);
            }
        }
        return Long.MIN_VALUE;
    }

    public static Long256Constant implicitCastStrAsLong256(CharSequence value) {
        if (value == null || value.length() == 0) {
            return Long256NullConstant.INSTANCE;
        }
        int start = 0;
        int end = value.length();
        if (end > 2 && value.charAt(start) == '0' && (value.charAt(start + 1) | 0x20) == 120) {
            start += 2;
        }
        Long256ConstantFactory factory = LONG256_FACTORY.get();
        Long256FromCharSequenceDecoder.decode(value, start, end, factory);
        return factory.pop();
    }

    public static void implicitCastStrAsLong256(CharSequence value, Long256Acceptor long256Acceptor) {
        if (value != null) {
            Long256FromCharSequenceDecoder.decode(value, 0, value.length(), long256Acceptor);
        } else {
            long256Acceptor.setAll(Long256Impl.NULL_LONG256.getLong0(), Long256Impl.NULL_LONG256.getLong1(), Long256Impl.NULL_LONG256.getLong2(), Long256Impl.NULL_LONG256.getLong3());
        }
    }

    public static short implicitCastStrAsShort(@Nullable CharSequence value) {
        try {
            return value != null ? Numbers.parseShort(value) : (short)0;
        }
        catch (NumericException ignore) {
            throw ImplicitCastException.inconvertibleValue(value, 11, 3);
        }
    }

    public static long implicitCastStrAsTimestamp(CharSequence value) {
        if (value != null) {
            try {
                return Numbers.parseLong(value);
            }
            catch (NumericException numericException) {
                try {
                    return IntervalUtils.parseFloorPartialTimestamp(value);
                }
                catch (NumericException numericException2) {
                    int hi = value.length();
                    for (int i = 0; i < DATE_FORMATS_FOR_TIMESTAMP_SIZE; ++i) {
                        try {
                            return DATE_FORMATS_FOR_TIMESTAMP[i].parse(value, 0, hi, DateFormatUtils.enLocale) * 1000L;
                        }
                        catch (NumericException numericException3) {
                            continue;
                        }
                    }
                    throw ImplicitCastException.inconvertibleValue(value, 11, 8);
                }
            }
        }
        return Long.MIN_VALUE;
    }

    public static void implicitCastStrAsUuid(CharSequence str, Uuid uuid) {
        if (str == null || str.length() == 0) {
            uuid.ofNull();
            return;
        }
        try {
            uuid.of(str);
        }
        catch (NumericException e) {
            throw ImplicitCastException.inconvertibleValue(str, 11, 19);
        }
    }

    public static boolean implicitCastUuidAsStr(long lo, long hi, CharSink sink) {
        if (Uuid.isNull(lo, hi)) {
            return false;
        }
        Numbers.appendUuid(lo, hi, sink);
        return true;
    }

    public static long parseFloorPartialTimestamp(CharSequence value, int tupleIndex, int columnType) {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(value);
        }
        catch (NumericException e) {
            throw ImplicitCastException.inconvertibleValue(tupleIndex, value, 11, columnType);
        }
    }

    static CharSequence createColumnAlias(CharacterStore store, CharSequence base, int indexOfDot, LowerCaseCharSequenceObjHashMap<QueryColumn> aliasToColumnMap) {
        return SqlUtil.createColumnAlias(store, base, indexOfDot, aliasToColumnMap, false);
    }

    static CharSequence createColumnAlias(CharacterStore store, CharSequence base, int indexOfDot, LowerCaseCharSequenceObjHashMap<QueryColumn> aliasToColumnMap, boolean cleanColumnNames) {
        CharSequence alias;
        boolean disallowed;
        boolean bl = disallowed = cleanColumnNames && disallowedAliases.contains(base);
        if (indexOfDot == -1 && !disallowed && aliasToColumnMap.excludes(base)) {
            return base;
        }
        CharacterStoreEntry characterStoreEntry = store.newEntry();
        if (indexOfDot == -1) {
            if (disallowed) {
                characterStoreEntry.put("column");
            } else {
                characterStoreEntry.put(base);
            }
        } else if (indexOfDot + 1 == base.length()) {
            characterStoreEntry.put("column");
        } else {
            characterStoreEntry.put(base, indexOfDot + 1, base.length());
        }
        int len = characterStoreEntry.length();
        int sequence = 0;
        do {
            if (sequence > 0) {
                characterStoreEntry.trimTo(len);
                characterStoreEntry.put(sequence);
            }
            ++sequence;
        } while (!aliasToColumnMap.excludes(alias = characterStoreEntry.toImmutable()));
        return alias;
    }

    static QueryColumn nextColumn(ObjectPool<QueryColumn> queryColumnPool, ObjectPool<ExpressionNode> sqlNodePool, CharSequence alias, CharSequence column) {
        return queryColumnPool.next().of(alias, SqlUtil.nextLiteral(sqlNodePool, column, 0));
    }

    static ExpressionNode nextLiteral(ObjectPool<ExpressionNode> pool, CharSequence token, int position) {
        return pool.next().of(4, token, 0, position);
    }

    static {
        LONG256_FACTORY = new ThreadLocal<Long256ConstantFactory>(() -> new Long256ConstantFactory());
        int n = OperatorExpression.operators.size();
        for (int i = 0; i < n; ++i) {
            disallowedAliases.add(OperatorExpression.operators.getQuick((int)i).token);
        }
        disallowedAliases.add("");
        DateFormatCompiler milliCompiler = new DateFormatCompiler();
        DateFormat pgDateTimeFormat = milliCompiler.compile("y-MM-dd HH:mm:ssz");
        DATE_FORMATS = new DateFormat[]{pgDateTimeFormat, DateFormatUtils.PG_DATE_Z_FORMAT, DateFormatUtils.PG_DATE_MILLI_TIME_Z_FORMAT, DateFormatUtils.UTC_FORMAT};
        DATE_FORMATS_SIZE = DATE_FORMATS.length;
        DATE_FORMATS_FOR_TIMESTAMP = new DateFormat[]{DateFormatUtils.PG_DATE_Z_FORMAT, DateFormatUtils.PG_DATE_MILLI_TIME_Z_FORMAT, pgDateTimeFormat};
        DATE_FORMATS_FOR_TIMESTAMP_SIZE = DATE_FORMATS_FOR_TIMESTAMP.length;
    }

    private static class Long256ConstantFactory
    implements Long256Acceptor {
        private Long256Constant long256;

        private Long256ConstantFactory() {
        }

        @Override
        public void setAll(long l0, long l1, long l2, long l3) {
            assert (this.long256 == null);
            this.long256 = new Long256Constant(l0, l1, l2, l3);
        }

        Long256Constant pop() {
            Long256Constant v = this.long256;
            this.long256 = null;
            return v;
        }
    }
}

