/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.analytic.AnalyticContextImpl;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.IntStack;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.tasks.TelemetryTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExecutionContextImpl
implements SqlExecutionContext {
    private final AnalyticContextImpl analyticContext = new AnalyticContextImpl();
    private final CairoConfiguration cairoConfiguration;
    private final CairoEngine cairoEngine;
    private final int sharedWorkerCount;
    private final Telemetry<TelemetryTask> telemetry;
    private final TelemetryFacade telemetryFacade;
    private final IntStack timestampRequiredStack = new IntStack();
    private final int workerCount;
    private BindVariableService bindVariableService;
    private SqlExecutionCircuitBreaker circuitBreaker = SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER;
    private MicrosecondClock clock;
    private boolean cloneSymbolTables = false;
    private boolean columnPreTouchEnabled = true;
    private int jitMode;
    private long now;
    private final MicrosecondClock nowClock = () -> this.now;
    private boolean parallelFilterEnabled;
    private Rnd random;
    private long requestFd = -1L;
    private SecurityContext securityContext;

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int workerCount, int sharedWorkerCount) {
        assert (workerCount > 0);
        this.workerCount = workerCount;
        assert (sharedWorkerCount > 0);
        this.sharedWorkerCount = sharedWorkerCount;
        this.cairoEngine = cairoEngine;
        this.cairoConfiguration = cairoEngine.getConfiguration();
        this.clock = this.cairoConfiguration.getMicrosecondClock();
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.jitMode = this.cairoConfiguration.getSqlJitMode();
        this.parallelFilterEnabled = this.cairoConfiguration.isSqlParallelFilterEnabled();
        this.telemetry = cairoEngine.getTelemetry();
        this.telemetryFacade = this.telemetry.isEnabled() ? this::doStoreTelemetry : this::storeTelemetryNoop;
    }

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int workerCount) {
        this(cairoEngine, workerCount, workerCount);
    }

    @Override
    public void clearAnalyticContext() {
        this.analyticContext.clear();
    }

    @Override
    public void configureAnalyticContext(@Nullable VirtualRecord partitionByRecord, @Nullable RecordSink partitionBySink, @Nullable ColumnTypes partitionByKeyTypes, boolean ordered, boolean baseSupportsRandomAccess) {
        this.analyticContext.of(partitionByRecord, partitionBySink, partitionByKeyTypes, ordered, baseSupportsRandomAccess);
    }

    @Override
    public AnalyticContext getAnalyticContext() {
        return this.analyticContext;
    }

    @Override
    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    @Override
    @NotNull
    public CairoEngine getCairoEngine() {
        return this.cairoEngine;
    }

    @Override
    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public boolean getCloneSymbolTables() {
        return this.cloneSymbolTables;
    }

    @Override
    public int getJitMode() {
        return this.jitMode;
    }

    @Override
    public long getMicrosecondTimestamp() {
        return this.clock.getTicks();
    }

    @Override
    public long getNow() {
        return this.now;
    }

    @Override
    public QueryFutureUpdateListener getQueryFutureUpdateListener() {
        return QueryFutureUpdateListener.EMPTY;
    }

    @Override
    public Rnd getRandom() {
        return this.random != null ? this.random : SharedRandom.getRandom(this.cairoConfiguration);
    }

    @Override
    public long getRequestFd() {
        return this.requestFd;
    }

    @Override
    @NotNull
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public int getSharedWorkerCount() {
        return this.sharedWorkerCount;
    }

    @Override
    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public void initNow() {
        this.now = this.clock.getTicks();
    }

    @Override
    public boolean isColumnPreTouchEnabled() {
        return this.columnPreTouchEnabled;
    }

    @Override
    public boolean isParallelFilterEnabled() {
        return this.parallelFilterEnabled;
    }

    @Override
    public boolean isTimestampRequired() {
        return this.timestampRequiredStack.notEmpty() && this.timestampRequiredStack.peek() == 1;
    }

    @Override
    public boolean isWalApplication() {
        return false;
    }

    @Override
    public void popTimestampRequiredFlag() {
        this.timestampRequiredStack.pop();
    }

    @Override
    public void pushTimestampRequiredFlag(boolean flag) {
        this.timestampRequiredStack.push(flag ? 1 : 0);
    }

    @Override
    public void setCloneSymbolTables(boolean cloneSymbolTables) {
        this.cloneSymbolTables = cloneSymbolTables;
    }

    @Override
    public void setColumnPreTouchEnabled(boolean columnPreTouchEnabled) {
        this.columnPreTouchEnabled = columnPreTouchEnabled;
    }

    @Override
    public void setJitMode(int jitMode) {
        this.jitMode = jitMode;
    }

    @Override
    public void setNowAndFixClock(long now) {
        this.now = now;
        this.clock = this.nowClock;
    }

    @Override
    public void setParallelFilterEnabled(boolean parallelFilterEnabled) {
        this.parallelFilterEnabled = parallelFilterEnabled;
    }

    @Override
    public void setRandom(Rnd rnd) {
        this.random = rnd;
    }

    @Override
    public void storeTelemetry(short event, short origin) {
        this.telemetryFacade.store(event, origin);
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd) {
        this.securityContext = securityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        return this;
    }

    public void with(long requestFd) {
        this.requestFd = requestFd;
    }

    public void with(BindVariableService bindVariableService) {
        this.bindVariableService = bindVariableService;
    }

    public void with(SqlExecutionCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext, @Nullable BindVariableService bindVariableService) {
        return this.with(securityContext, bindVariableService, null, -1L, null);
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd, long requestFd, @Nullable SqlExecutionCircuitBreaker circuitBreaker) {
        this.securityContext = securityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        this.requestFd = requestFd;
        this.circuitBreaker = circuitBreaker == null ? SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER : circuitBreaker;
        return this;
    }

    private void doStoreTelemetry(short event, short origin) {
        TelemetryTask.store(this.telemetry, origin, event);
    }

    private void storeTelemetryNoop(short event, short origin) {
    }

    @FunctionalInterface
    private static interface TelemetryFacade {
        public void store(short var1, short var2);
    }
}

