/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.Rnd;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqlExecutionContext
extends Closeable {
    public void clearAnalyticContext();

    @Override
    default public void close() {
    }

    public void configureAnalyticContext(@Nullable VirtualRecord var1, @Nullable RecordSink var2, @Nullable ColumnTypes var3, boolean var4, boolean var5);

    public AnalyticContext getAnalyticContext();

    default public Rnd getAsyncRandom() {
        return SharedRandom.getAsyncRandom(this.getCairoEngine().getConfiguration());
    }

    public BindVariableService getBindVariableService();

    @NotNull
    public CairoEngine getCairoEngine();

    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker();

    public boolean getCloneSymbolTables();

    public int getJitMode();

    @NotNull
    default public MessageBus getMessageBus() {
        return this.getCairoEngine().getMessageBus();
    }

    default public TableRecordMetadata getMetadata(TableToken tableToken) {
        return this.getCairoEngine().getMetadata(tableToken);
    }

    default public TableRecordMetadata getMetadata(TableToken tableToken, long structureVersion) {
        return this.getCairoEngine().getMetadata(tableToken, structureVersion);
    }

    public long getMicrosecondTimestamp();

    public long getNow();

    public QueryFutureUpdateListener getQueryFutureUpdateListener();

    public Rnd getRandom();

    default public TableReader getReader(TableToken tableName, long version) {
        return this.getCairoEngine().getReader(tableName, version);
    }

    default public TableReader getReader(TableToken tableName) {
        return this.getCairoEngine().getReader(tableName);
    }

    public long getRequestFd();

    @NotNull
    public SecurityContext getSecurityContext();

    default public int getSharedWorkerCount() {
        return this.getWorkerCount();
    }

    default public int getTableStatus(Path path, TableToken tableName) {
        return this.getCairoEngine().getTableStatus(path, tableName);
    }

    default public TableToken getTableToken(CharSequence tableName) {
        return this.getCairoEngine().verifyTableName(tableName);
    }

    default public TableToken getTableToken(CharSequence tableName, int lo, int hi) {
        return this.getCairoEngine().verifyTableName(tableName, lo, hi);
    }

    default public TableToken getTableTokenIfExists(CharSequence tableName) {
        return this.getCairoEngine().getTableTokenIfExists(tableName);
    }

    default public TableToken getTableTokenIfExists(CharSequence tableName, int lo, int hi) {
        return this.getCairoEngine().getTableTokenIfExists(tableName, lo, hi);
    }

    public int getWorkerCount();

    public void initNow();

    public boolean isColumnPreTouchEnabled();

    public boolean isParallelFilterEnabled();

    public boolean isTimestampRequired();

    public boolean isWalApplication();

    public void popTimestampRequiredFlag();

    public void pushTimestampRequiredFlag(boolean var1);

    public void setCloneSymbolTables(boolean var1);

    public void setColumnPreTouchEnabled(boolean var1);

    public void setJitMode(int var1);

    public void setNowAndFixClock(long var1);

    public void setParallelFilterEnabled(boolean var1);

    public void setRandom(Rnd var1);

    default public void storeTelemetry(short event, short origin) {
    }

    default public boolean isUninterruptible() {
        return false;
    }
}

