/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlException
extends Exception
implements Sinkable,
FlyweightMessageContainer {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final ThreadLocal<SqlException> tlException = new ThreadLocal<SqlException>(SqlException::new);
    private final StringSink message = new StringSink();
    private int position;

    protected SqlException() {
    }

    public static SqlException $(int position, CharSequence message) {
        return SqlException.position(position).put(message);
    }

    public static SqlException $(int position, long addrLo, long addrHi) {
        return SqlException.position(position).put(addrLo, addrHi);
    }

    public static SqlException ambiguousColumn(int position, CharSequence columnName) {
        return SqlException.position(position).put("Ambiguous column [name=").put(columnName).put(']');
    }

    public static SqlException duplicateColumn(int position, CharSequence colName) {
        return SqlException.duplicateColumn(position, colName, null);
    }

    public static SqlException duplicateColumn(int position, CharSequence colName, CharSequence additionalMessage) {
        SqlException exception = SqlException.$(position, "Duplicate column [name=").put(colName).put(']');
        if (additionalMessage != null) {
            exception.put(' ').put(additionalMessage);
        }
        return exception;
    }

    public static SqlException inconvertibleTypes(int position, int fromType, CharSequence fromName, int toType, CharSequence toName) {
        return SqlException.$(position, "inconvertible types: ").put(ColumnType.nameOf(fromType)).put(" -> ").put(ColumnType.nameOf(toType)).put(" [from=").put(fromName).put(", to=").put(toName).put(']');
    }

    public static SqlException invalidColumn(int position, CharSequence column) {
        return SqlException.position(position).put("Invalid column: ").put(column);
    }

    public static SqlException tableDoesNotExist(int position, CharSequence tableName) {
        return SqlException.position(position).put("table does not exist [table=").put(tableName).put(']');
    }

    public static SqlException invalidDate(int position) {
        return SqlException.position(position).put("Invalid date");
    }

    public static SqlException parserErr(int position, @Nullable CharSequence tok, @NotNull CharSequence msg) {
        return tok == null ? SqlException.$(position, msg) : SqlException.$(position, "found [tok='").put(tok).put("', len=").put(tok.length()).put("] ").put(msg);
    }

    public static SqlException position(int position) {
        SqlException ex = tlException.get();
        assert ((ex = new SqlException()) != null);
        ex.message.clear();
        ex.position = position;
        return ex;
    }

    public static SqlException unexpectedToken(int position, CharSequence token) {
        return SqlException.position(position).put("unexpected token: ").put(token);
    }

    public static SqlException unsupportedCast(int position, CharSequence columnName, int fromType, int toType) {
        return SqlException.$(position, "unsupported cast [column=").put(columnName).put(", from=").put(ColumnType.nameOf(fromType)).put(", to=").put(ColumnType.nameOf(toType)).put(']');
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return "[" + this.position + "] " + this.message;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] result = EMPTY_STACK_TRACE;
        assert ((result = super.getStackTrace()) != null);
        return result;
    }

    public SqlException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public SqlException put(char c) {
        this.message.put(c);
        return this;
    }

    public SqlException put(int value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(long value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(double value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(Sinkable sinkable) {
        this.message.put(sinkable);
        return this;
    }

    public SqlException put(long addrLo, long addrHi) {
        this.message.put(addrLo, addrHi);
        return this;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.position).put("]: ").put(this.message);
    }
}

