/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableNameRegistryFileStore;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.VacuumColumnVersions;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.WalWriterMetadata;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.BatchCallback;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.CompiledQueryImpl;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.InsertRowImpl;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.RecordToRowCopierUtils;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.catalogue.ShowDateStyleCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowMaxIdentifierLengthCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowSearchPathCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowStandardConformingStringsCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTimeZoneFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTransactionIsolationLevelCursorFactory;
import io.questdb.griffin.engine.ops.AlterOperationBuilder;
import io.questdb.griffin.engine.ops.CopyCancelFactory;
import io.questdb.griffin.engine.ops.CopyFactory;
import io.questdb.griffin.engine.ops.InsertOperationImpl;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.griffin.engine.table.ShowColumnsRecordCursorFactory;
import io.questdb.griffin.engine.table.ShowPartitionsRecordCursorFactory;
import io.questdb.griffin.engine.table.TableListRecordCursorFactory;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExplainModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Sinkable;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompiler
implements Closeable {
    static final ObjList<String> sqlControlSymbols = new ObjList(8);
    private static final BatchCallback EMPTY_CALLBACK = new BatchCallback(){

        @Override
        public void postCompile(SqlCompiler compiler, CompiledQuery cq, CharSequence queryText) {
        }

        @Override
        public void preCompile(SqlCompiler compiler) {
        }
    };
    private static final Log LOG = LogFactory.getLog(SqlCompiler.class);
    private static final IntList castGroups = new IntList();
    protected final AlterOperationBuilder alterOperationBuilder;
    protected final CompiledQueryImpl compiledQuery;
    protected final CairoConfiguration configuration;
    protected final CairoEngine engine;
    protected final CharSequenceObjHashMap<KeywordBasedExecutor> keywordBasedExecutors = new CharSequenceObjHashMap();
    protected final GenericLexer lexer;
    protected final Path path = new Path();
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final DatabaseBackupAgent backupAgent;
    private final CharacterStore characterStore;
    private final SqlCodeGenerator codeGenerator;
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final FilesFacade ff;
    private final FunctionParser functionParser;
    private final ListColumnFilter listColumnFilter = new ListColumnFilter();
    private final ExecutableMethod insertAsSelectMethod = this::insertAsSelect;
    private final MemoryMARW mem = Vm.getMARWInstance();
    private final MessageBus messageBus;
    private final SqlOptimiser optimiser;
    private final SqlParser parser;
    private final TimestampValueRecord partitionFunctionRec = new TimestampValueRecord();
    private final QueryBuilder queryBuilder = new QueryBuilder();
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final IndexBuilder rebuildIndex;
    private final Path renamePath = new Path();
    private final DatabaseSnapshotAgent snapshotAgent;
    private final ObjectPool<ExpressionNode> sqlNodePool;
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final ObjList<TableWriterAPI> tableWriters = new ObjList();
    private final TextLoader textLoader;
    private final IntIntHashMap typeCast = new IntIntHashMap();
    private final VacuumColumnVersions vacuumColumnVersions;
    private long insertCount;
    private final ExecutableMethod createTableMethod = this::createTable;
    private boolean isSingleQueryMode = true;

    public SqlCompiler(CairoEngine engine) {
        this(engine, null, null);
    }

    public SqlCompiler(CairoEngine engine, @Nullable DatabaseSnapshotAgent snapshotAgent) {
        this(engine, engine.getFunctionFactoryCache(), snapshotAgent);
    }

    public SqlCompiler(CairoEngine engine, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
        this.messageBus = engine.getMessageBus();
        this.rebuildIndex = new IndexBuilder(this.configuration);
        this.sqlNodePool = new ObjectPool<ExpressionNode>(ExpressionNode.FACTORY, this.configuration.getSqlExpressionPoolCapacity());
        this.queryColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, this.configuration.getSqlColumnPoolCapacity());
        this.queryModelPool = new ObjectPool<QueryModel>(QueryModel.FACTORY, this.configuration.getSqlModelPoolCapacity());
        this.compiledQuery = new CompiledQueryImpl(engine);
        this.characterStore = new CharacterStore(this.configuration.getSqlCharacterStoreCapacity(), this.configuration.getSqlCharacterStoreSequencePoolCapacity());
        this.lexer = new GenericLexer(this.configuration.getSqlLexerPoolCapacity());
        this.functionParser = new FunctionParser(this.configuration, functionFactoryCache != null ? functionFactoryCache : engine.getFunctionFactoryCache());
        this.codeGenerator = new SqlCodeGenerator(engine, this.configuration, this.functionParser, this.sqlNodePool);
        this.vacuumColumnVersions = new VacuumColumnVersions(engine);
        this.functionParser.setSqlCodeGenerator(this.codeGenerator);
        this.backupAgent = new DatabaseBackupAgent();
        this.snapshotAgent = snapshotAgent;
        this.registerKeywordBasedExecutors();
        SqlCompiler.configureLexer(this.lexer);
        PostOrderTreeTraversalAlgo postOrderTreeTraversalAlgo = new PostOrderTreeTraversalAlgo();
        this.optimiser = new SqlOptimiser(this.configuration, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo, this.functionParser, this.path);
        this.parser = new SqlParser(this.configuration, this.optimiser, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo);
        this.textLoader = new TextLoader(engine);
        this.alterOperationBuilder = new AlterOperationBuilder();
    }

    public static void expectKeyword(GenericLexer lexer, CharSequence keyword) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(keyword).put("' expected");
        }
        if (!Chars.equalsLowerCaseAscii(tok, keyword)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(keyword).put("' expected");
        }
    }

    @Override
    public void close() {
        this.backupAgent.close();
        this.vacuumColumnVersions.close();
        Misc.free(this.path);
        Misc.free(this.renamePath);
        Misc.free(this.textLoader);
        Misc.free(this.rebuildIndex);
        Misc.free(this.codeGenerator);
        Misc.free(this.mem);
        Misc.freeObjList(this.tableWriters);
    }

    @NotNull
    public CompiledQuery compile(@NotNull CharSequence query, @NotNull SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        this.isSingleQueryMode = true;
        this.compileInner(executionContext, query);
        return this.compiledQuery;
    }

    public void compileBatch(@NotNull CharSequence query, @NotNull SqlExecutionContext executionContext, BatchCallback batchCallback) throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException, SqlException {
        LOG.info().$("batch [text=").$(query).I$();
        this.clear();
        this.lexer.of(query);
        this.isSingleQueryMode = false;
        if (batchCallback == null) {
            batchCallback = EMPTY_CALLBACK;
        }
        while (this.lexer.hasNext()) {
            int position = this.getNextValidTokenPosition();
            if (position == -1) {
                return;
            }
            boolean recompileStale = true;
            int retries = 0;
            while (recompileStale) {
                try {
                    batchCallback.preCompile(this);
                    this.clear();
                    CompiledQuery current = this.compileInner(executionContext, query);
                    CharSequence currentQuery = query.subSequence(position, this.goToQueryEnd());
                    batchCallback.postCompile(this, current, currentQuery);
                    recompileStale = false;
                }
                catch (TableReferenceOutOfDateException e) {
                    if (retries == 10) {
                        throw e;
                    }
                    LOG.info().$(e.getFlyweightMessage()).$();
                    this.lexer.restart();
                }
                ++retries;
            }
        }
    }

    public CairoEngine getEngine() {
        return this.engine;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionParser.getFunctionFactoryCache();
    }

    public QueryBuilder query() {
        this.queryBuilder.clear();
        return this.queryBuilder;
    }

    public void setEnableJitNullChecks(boolean value) {
        this.codeGenerator.setEnableJitNullChecks(value);
    }

    public void setFullFatJoins(boolean value) {
        this.codeGenerator.setFullFatJoins(value);
    }

    public ExecutionModel testCompileModel(CharSequence query, SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        return this.compileExecutionModel(executionContext);
    }

    public ExpressionNode testParseExpression(CharSequence expression, QueryModel model) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        return this.parser.expr(this.lexer, model);
    }

    public void testParseExpression(CharSequence expression, ExpressionParserListener listener) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        this.parser.expr(this.lexer, listener);
    }

    private static void configureLexer(GenericLexer lexer) {
        int i;
        int k = sqlControlSymbols.size();
        for (i = 0; i < k; ++i) {
            lexer.defineSymbol(sqlControlSymbols.getQuick(i));
        }
        k = OperatorExpression.operators.size();
        for (i = 0; i < k; ++i) {
            OperatorExpression op = OperatorExpression.operators.getQuick(i);
            if (!op.symbol) continue;
            lexer.defineSymbol(op.token);
        }
    }

    private static boolean isCompatibleCase(int from, int to) {
        return castGroups.getQuick(ColumnType.tagOf(from)) == castGroups.getQuick(ColumnType.tagOf(to));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery alterTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) return this.unknownAlterStatement(executionContext, tok);
        if (!SqlKeywords.isTableKeyword(tok)) {
            return this.unknownAlterStatement(executionContext, tok);
        }
        int tableNamePosition = this.lexer.getPosition();
        tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        TableToken tableToken = this.tableExistsOrFail(tableNamePosition, tok, executionContext);
        try (TableRecordMetadata tableMetadata = executionContext.getMetadata(tableToken);){
            String expectedTokenDescription = "'add', 'alter', 'attach', 'detach', 'drop', 'resume', 'rename', 'set' or 'squash'";
            tok = SqlCompiler.expectToken(this.lexer, expectedTokenDescription);
            if (SqlKeywords.isAddKeyword(tok)) {
                executionContext.getSecurityContext().authorizeAlterTableAddColumn(tableToken);
                CompiledQuery compiledQuery = this.alterTableAddColumn(tableNamePosition, tableToken, tableMetadata);
                return compiledQuery;
            }
            if (SqlKeywords.isDropKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'column' or 'partition'");
                if (SqlKeywords.isColumnKeyword(tok)) {
                    CompiledQuery compiledQuery = this.alterTableDropColumn(executionContext.getSecurityContext(), tableNamePosition, tableToken, tableMetadata);
                    return compiledQuery;
                }
                if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                executionContext.getSecurityContext().authorizeAlterTableDropPartition(tableToken);
                CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartition(tableMetadata, tableToken, 1, executionContext);
                return compiledQuery;
            }
            if (SqlKeywords.isRenameKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'column'");
                if (!SqlKeywords.isColumnKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' expected");
                CompiledQuery compiledQuery = this.alterTableRenameColumn(executionContext.getSecurityContext(), tableNamePosition, tableToken, tableMetadata);
                return compiledQuery;
            }
            if (SqlKeywords.isAttachKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'partition'");
                if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                executionContext.getSecurityContext().authorizeAlterTableAttachPartition(tableToken);
                CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartition(tableMetadata, tableToken, 2, executionContext);
                return compiledQuery;
            }
            if (SqlKeywords.isDetachKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'partition'");
                if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                executionContext.getSecurityContext().authorizeAlterTableDetachPartition(tableToken);
                CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartition(tableMetadata, tableToken, 3, executionContext);
                return compiledQuery;
            }
            if (SqlKeywords.isAlterKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'column'");
                if (!SqlKeywords.isColumnKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                int columnNamePosition = this.lexer.getPosition();
                tok = SqlCompiler.expectToken(this.lexer, "column name");
                CharSequence columnName = GenericLexer.immutableOf(tok);
                tok = SqlCompiler.expectToken(this.lexer, "'add index' or 'drop index' or 'cache' or 'nocache'");
                if (SqlKeywords.isAddKeyword(tok)) {
                    SqlCompiler.expectKeyword(this.lexer, "index");
                    tok = SqlUtil.fetchNext(this.lexer);
                    int indexValueCapacity = -1;
                    if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                        if (!SqlKeywords.isCapacityKeyword(tok)) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "'capacity' expected");
                        }
                        tok = SqlCompiler.expectToken(this.lexer, "capacity value");
                        try {
                            indexValueCapacity = Numbers.parseInt(tok);
                            if (indexValueCapacity <= 0) {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "positive integer literal expected as index capacity");
                            }
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "positive integer literal expected as index capacity");
                        }
                    }
                    CompiledQuery e = this.alterTableColumnAddIndex(executionContext.getSecurityContext(), tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata, indexValueCapacity);
                    return e;
                }
                if (SqlKeywords.isDropKeyword(tok)) {
                    SqlCompiler.expectKeyword(this.lexer, "index");
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("] while trying to drop index");
                    }
                    CompiledQuery indexValueCapacity = this.alterTableColumnDropIndex(executionContext.getSecurityContext(), tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata);
                    return indexValueCapacity;
                }
                if (SqlKeywords.isCacheKeyword(tok)) {
                    CompiledQuery indexValueCapacity = this.alterTableColumnCacheFlag(executionContext.getSecurityContext(), tableNamePosition, tableToken, columnName, tableMetadata, true);
                    return indexValueCapacity;
                }
                if (!SqlKeywords.isNoCacheKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'add', 'drop', 'cache' or 'nocache' expected").put(" found '").put(tok).put('\'');
                CompiledQuery indexValueCapacity = this.alterTableColumnCacheFlag(executionContext.getSecurityContext(), tableNamePosition, tableToken, columnName, tableMetadata, false);
                return indexValueCapacity;
            }
            if (SqlKeywords.isSetKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'param' or 'type'");
                if (SqlKeywords.isParamKeyword(tok)) {
                    int paramNamePosition = this.lexer.getPosition();
                    tok = SqlCompiler.expectToken(this.lexer, "param name");
                    CharSequence paramName = GenericLexer.immutableOf(tok);
                    tok = SqlCompiler.expectToken(this.lexer, "'='");
                    if (tok.length() != 1) throw SqlException.$(this.lexer.lastTokenPosition(), "'=' expected");
                    if (tok.charAt(0) != '=') throw SqlException.$(this.lexer.lastTokenPosition(), "'=' expected");
                    CharSequence value = GenericLexer.immutableOf(SqlUtil.fetchNext(this.lexer));
                    CompiledQuery e = this.alterTableSetParam(paramName, value, paramNamePosition, tableToken, tableNamePosition, tableMetadata.getTableId());
                    return e;
                }
                if (!SqlKeywords.isTypeKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'param' or 'type' expected");
                tok = SqlCompiler.expectToken(this.lexer, "'bypass' or 'wal'");
                if (SqlKeywords.isBypassKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'wal'");
                    if (!SqlKeywords.isWalKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'wal' expected");
                    CompiledQuery paramNamePosition = this.alterTableSetType(executionContext, tableNamePosition, tableToken, (byte)0);
                    return paramNamePosition;
                }
                if (!SqlKeywords.isWalKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'bypass' or 'wal' expected");
                CompiledQuery paramNamePosition = this.alterTableSetType(executionContext, tableNamePosition, tableToken, (byte)1);
                return paramNamePosition;
            }
            if (SqlKeywords.isResumeKeyword(tok)) {
                tok = SqlCompiler.expectToken(this.lexer, "'wal'");
                if (!SqlKeywords.isWalKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'wal' expected");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                long fromTxn = -1L;
                if (tok != null) {
                    if (!SqlKeywords.isFromKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'from' expected");
                    tok = SqlCompiler.expectToken(this.lexer, "'transaction' or 'txn'");
                    if (!SqlKeywords.isTransactionKeyword(tok) && !SqlKeywords.isTxnKeyword(tok)) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'transaction' or 'txn' expected");
                    }
                    CharSequence txnValue = SqlCompiler.expectToken(this.lexer, "transaction value");
                    try {
                        fromTxn = Numbers.parseLong(txnValue);
                    }
                    catch (NumericException e) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "invalid value [value=").put(txnValue).put(']');
                    }
                }
                if (!this.engine.isWalTable(tableToken)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), tableToken.getTableName()).put(" is not a WAL table.");
                }
                CompiledQuery compiledQuery = this.alterTableResume(tableNamePosition, tableToken, fromTxn, executionContext);
                return compiledQuery;
            }
            if (!SqlKeywords.isSquashKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), expectedTokenDescription).put(" expected");
            executionContext.getSecurityContext().authorizeAlterTableDropPartition(tableToken);
            tok = SqlCompiler.expectToken(this.lexer, "'partitions'");
            if (!SqlKeywords.isPartitionsKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'partitions' expected");
            CompiledQuery compiledQuery = this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSquashPartitions(tableNamePosition, tableToken).build());
            return compiledQuery;
        }
        catch (CairoException e) {
            LOG.info().$("could not alter table [table=").$(tableToken.getTableName()).$(", ex=").$(e).$();
            e.position(this.lexer.lastTokenPosition());
            throw e;
        }
    }

    private CompiledQuery alterTableAddColumn(int tableNamePosition, TableToken tableToken, TableRecordMetadata tableMetadata) throws SqlException {
        block33: {
            CharSequence tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && !SqlKeywords.isColumnKeyword(tok)) {
                this.lexer.unparseLast();
            }
            AlterOperationBuilder addColumn = this.alterOperationBuilder.ofAddColumn(tableNamePosition, tableToken, tableMetadata.getTableId());
            int semicolonPos = -1;
            do {
                int indexValueBlockCapacity;
                boolean indexed;
                boolean cache;
                int symbolCapacity;
                tok = SqlCompiler.maybeExpectToken(this.lexer, "'column' or column name", semicolonPos < 0);
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block33;
                }
                int index = tableMetadata.getColumnIndexQuiet(tok);
                if (index != -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "column '").put(tok).put("' already exists");
                }
                CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                int columnNamePosition = this.lexer.lastTokenPosition();
                if (!TableUtils.isValidColumnName(columnName, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                tok = SqlCompiler.expectToken(this.lexer, "column type");
                int type = ColumnType.tagOf(tok);
                if (type == -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "invalid type");
                }
                if (type == 23) {
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || tok.charAt(0) != '(') {
                        throw SqlException.position(this.lexer.getPosition()).put("missing GEOHASH precision");
                    }
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok != null && tok.charAt(0) != ')') {
                        int geoHashBits = GeoHashUtil.parseGeoHashBits(this.lexer.lastTokenPosition(), 0, tok);
                        tok = SqlUtil.fetchNext(this.lexer);
                        if (tok == null || tok.charAt(0) != ')') {
                            if (tok != null) {
                                throw SqlException.position(this.lexer.lastTokenPosition()).put("invalid GEOHASH type literal, expected ')'").put(" found='").put(tok.charAt(0)).put("'");
                            }
                            throw SqlException.position(this.lexer.getPosition()).put("invalid GEOHASH type literal, expected ')'");
                        }
                        type = ColumnType.getGeoHashTypeWithBits(geoHashBits);
                    } else {
                        throw SqlException.position(this.lexer.lastTokenPosition()).put("missing GEOHASH precision");
                    }
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (ColumnType.isSymbol(type) && tok != null && !Chars.equals(tok, ',') && !Chars.equals(tok, ';')) {
                    if (SqlKeywords.isCapacityKeyword(tok)) {
                        boolean negative;
                        tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        int errorPos = this.lexer.lastTokenPosition();
                        if (Chars.equals(tok, '-')) {
                            negative = true;
                            tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        } else {
                            negative = false;
                        }
                        try {
                            symbolCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        if (negative) {
                            symbolCapacity = -symbolCapacity;
                        }
                        TableUtils.validateSymbolCapacity(errorPos, symbolCapacity);
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    }
                    if (Chars.equalsLowerCaseAsciiNc("cache", tok)) {
                        cache = true;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else if (Chars.equalsLowerCaseAsciiNc("nocache", tok)) {
                        cache = false;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        cache = this.configuration.getDefaultSymbolCacheFlag();
                    }
                    TableUtils.validateSymbolCapacityCached(cache, symbolCapacity, this.lexer.lastTokenPosition());
                    indexed = Chars.equalsLowerCaseAsciiNc("index", tok);
                    if (indexed) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (Chars.equalsLowerCaseAsciiNc("capacity", tok)) {
                        tok = SqlCompiler.expectToken(this.lexer, "symbol index capacity");
                        try {
                            indexValueBlockCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    }
                } else {
                    if (tok != null && SqlKeywords.isNotKeyword(tok)) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (tok != null && SqlKeywords.isNullKeyword(tok)) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    cache = this.configuration.getDefaultSymbolCacheFlag();
                    indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    indexed = false;
                }
                addColumn.addColumnToList(columnName, columnNamePosition, type, Numbers.ceilPow2(symbolCapacity), cache, indexed, Numbers.ceilPow2(indexValueBlockCapacity));
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block33;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableColumnAddIndex(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata metadata, int indexValueBlockSize) throws SqlException {
        if (metadata.getColumnIndexQuiet(columnName) == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        if (indexValueBlockSize == -1) {
            indexValueBlockSize = this.configuration.getIndexValueBlockSize();
        }
        this.alterOperationBuilder.ofAddIndex(tableNamePosition, tableToken, metadata.getTableId(), columnName, Numbers.ceilPow2(indexValueBlockSize));
        securityContext.authorizeAlterTableAddIndex(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableColumnCacheFlag(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, CharSequence columnName, TableRecordMetadata metadata, boolean cache) throws SqlException {
        int columnIndex = metadata.getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), columnName);
        }
        if (!ColumnType.isSymbol(metadata.getColumnType(columnIndex))) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "Invalid column type - Column should be of type symbol");
        }
        if (cache) {
            this.alterOperationBuilder.ofCacheSymbol(tableNamePosition, tableToken, metadata.getTableId(), columnName);
        } else {
            this.alterOperationBuilder.ofRemoveCacheSymbol(tableNamePosition, tableToken, metadata.getTableId(), columnName);
        }
        securityContext.authorizeAlterTableAlterColumnCache(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableColumnDropIndex(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata metadata) throws SqlException {
        if (metadata.getColumnIndexQuiet(columnName) == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        this.alterOperationBuilder.ofDropIndex(tableNamePosition, tableToken, metadata.getTableId(), columnName, columnNamePosition);
        securityContext.authorizeAlterTableDropIndex(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableDropColumn(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, TableRecordMetadata metadata) throws SqlException {
        AlterOperationBuilder dropColumnStatement;
        block4: {
            CharSequence tok;
            dropColumnStatement = this.alterOperationBuilder.ofDropColumn(tableNamePosition, tableToken, metadata.getTableId());
            int semicolonPos = -1;
            do {
                tok = GenericLexer.unquote(SqlCompiler.maybeExpectToken(this.lexer, "column name", semicolonPos < 0));
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block4;
                }
                if (metadata.getColumnIndexQuiet(tok) == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence columnName = tok;
                dropColumnStatement.ofDropColumn(columnName);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block4;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            return this.unknownDropColumnSuffix(securityContext, tok, tableToken, dropColumnStatement);
        }
        securityContext.authorizeAlterTableDropColumn(tableToken, dropColumnStatement.getExtraStrInfo());
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableDropDetachOrAttachPartition(TableRecordMetadata tableMetadata, TableToken tableToken, int action, SqlExecutionContext executionContext) throws SqlException {
        int pos = this.lexer.lastTokenPosition();
        TableReader reader = null;
        if (!tableMetadata.isWalEnabled() || executionContext.isWalApplication()) {
            reader = executionContext.getReader(tableToken);
        }
        try {
            if (reader != null && !PartitionBy.isPartitioned(reader.getMetadata().getPartitionBy())) {
                throw SqlException.$(pos, "table is not partitioned");
            }
            CharSequence tok = SqlCompiler.expectToken(this.lexer, "'list' or 'where'");
            if (SqlKeywords.isListKeyword(tok)) {
                CompiledQuery compiledQuery = this.alterTableDropDetachOrAttachPartitionByList(tableMetadata, tableToken, reader, pos, action);
                return compiledQuery;
            }
            if (SqlKeywords.isWhereKeyword(tok)) {
                AlterOperationBuilder alterOperationBuilder;
                switch (action) {
                    case 1: {
                        alterOperationBuilder = this.alterOperationBuilder.ofDropPartition(pos, tableToken, tableMetadata.getTableId());
                        break;
                    }
                    case 3: {
                        alterOperationBuilder = this.alterOperationBuilder.ofDetachPartition(pos, tableToken, tableMetadata.getTableId());
                        break;
                    }
                    default: {
                        throw SqlException.$(pos, "WHERE clause can only be used with command DROP PARTITION, or DETACH PARTITION");
                    }
                }
                int functionPosition = this.lexer.getPosition();
                ExpressionNode expr = this.parser.expr(this.lexer, (QueryModel)null);
                String designatedTimestampColumnName = null;
                int tsIndex = tableMetadata.getTimestampIndex();
                if (tsIndex >= 0) {
                    designatedTimestampColumnName = tableMetadata.getColumnName(tsIndex);
                }
                if (designatedTimestampColumnName != null) {
                    GenericRecordMetadata metadata = new GenericRecordMetadata();
                    metadata.add(new TableColumnMetadata(designatedTimestampColumnName, 8, null));
                    Function function = this.functionParser.parseFunction(expr, metadata, executionContext);
                    try {
                        if (function != null && ColumnType.isBoolean(function.getType())) {
                            int affected;
                            function.init(null, executionContext);
                            if (reader != null && (affected = this.filterPartitions(function, functionPosition, reader, alterOperationBuilder)) == 0) {
                                throw SqlException.$(functionPosition, "no partitions matched WHERE clause");
                            }
                            CompiledQuery compiledQuery = this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
                            return compiledQuery;
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "boolean expression expected");
                    }
                    finally {
                        Misc.free(function);
                    }
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), "this table does not have a designated timestamp column");
            }
            throw SqlException.$(this.lexer.lastTokenPosition(), "'list' or 'where' expected");
        }
        finally {
            Misc.free(reader);
        }
    }

    private CompiledQuery alterTableDropDetachOrAttachPartitionByList(TableRecordMetadata tableMetadata, TableToken tableToken, @Nullable TableReader reader, int pos, int action) throws SqlException {
        AlterOperationBuilder alterOperationBuilder;
        block13: {
            CharSequence tok;
            switch (action) {
                case 1: {
                    alterOperationBuilder = this.alterOperationBuilder.ofDropPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                case 3: {
                    alterOperationBuilder = this.alterOperationBuilder.ofDetachPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                case 2: {
                    alterOperationBuilder = this.alterOperationBuilder.ofAttachPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                default: {
                    alterOperationBuilder = null;
                    assert (false);
                    break;
                }
            }
            int semicolonPos = -1;
            do {
                tok = SqlCompiler.maybeExpectToken(this.lexer, "partition name", semicolonPos < 0);
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block13;
                }
                if (Chars.equals(tok, ',') || Chars.equals(tok, ';')) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "partition name missing");
                }
                CharSequence partitionName = GenericLexer.unquote(tok);
                int lastPosition = this.lexer.lastTokenPosition();
                if (reader != null) {
                    try {
                        long timestamp = PartitionBy.parsePartitionDirName(partitionName, reader.getPartitionedBy(), 0, -1);
                        alterOperationBuilder.addPartitionToList(timestamp, lastPosition);
                    }
                    catch (CairoException e) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), e.getFlyweightMessage());
                    }
                }
                if ((tok = SqlUtil.fetchNext(this.lexer)) == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block13;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        return this.compiledQuery.ofAlter(alterOperationBuilder.build());
    }

    private CompiledQuery alterTableRenameColumn(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, TableRecordMetadata metadata) throws SqlException {
        block8: {
            CharSequence tok;
            AlterOperationBuilder renameColumnStatement = this.alterOperationBuilder.ofRenameColumn(tableNamePosition, tableToken, metadata.getTableId());
            int hadSemicolonPos = -1;
            do {
                tok = GenericLexer.unquote(SqlCompiler.maybeExpectToken(this.lexer, "current column name", hadSemicolonPos < 0));
                if (hadSemicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(hadSemicolonPos, "',' expected");
                    }
                    break block8;
                }
                int columnIndex = metadata.getColumnIndexQuiet(tok);
                if (columnIndex == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence existingName = GenericLexer.immutableOf(tok);
                tok = SqlCompiler.expectToken(this.lexer, "'to' expected");
                if (!SqlKeywords.isToKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'to' expected'");
                }
                tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "new column name"));
                if (Chars.equals(existingName, tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "new column name is identical to existing name");
                }
                if (metadata.getColumnIndexQuiet(tok) > -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " column already exists");
                }
                if (!TableUtils.isValidColumnName(tok, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                CharSequence newName = GenericLexer.immutableOf(tok);
                renameColumnStatement.ofRenameColumn(existingName, newName);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block8;
            } while ((hadSemicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        securityContext.authorizeAlterTableRenameColumn(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        return this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private CompiledQuery alterTableResume(int tableNamePosition, TableToken tableToken, long resumeFromTxn, SqlExecutionContext executionContext) {
        try {
            this.engine.getTableSequencerAPI().resumeTable(tableToken, resumeFromTxn);
            executionContext.storeTelemetry((short)108, (short)6);
            return this.compiledQuery.ofTableResume();
        }
        catch (CairoException ex) {
            LOG.critical().$("table resume failed [table=").$(tableToken).$(", error=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            ex.position(tableNamePosition);
            throw ex;
        }
    }

    private CompiledQuery alterTableSetParam(CharSequence paramName, CharSequence value, int paramNamePosition, TableToken tableToken, int tableNamePosition, int tableId) throws SqlException {
        if (SqlKeywords.isMaxUncommittedRowsKeyword(paramName)) {
            int maxUncommittedRows;
            try {
                maxUncommittedRows = Numbers.parseInt(value);
            }
            catch (NumericException e) {
                throw SqlException.$(paramNamePosition, "invalid value [value=").put(value).put(",parameter=").put(paramName).put(']');
            }
            if (maxUncommittedRows < 0) {
                throw SqlException.$(paramNamePosition, "maxUncommittedRows must be non negative");
            }
            return this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSetParamUncommittedRows(tableNamePosition, tableToken, tableId, maxUncommittedRows).build());
        }
        if (SqlKeywords.isO3MaxLagKeyword(paramName)) {
            long o3MaxLag = SqlUtil.expectMicros(value, paramNamePosition);
            if (o3MaxLag < 0L) {
                throw SqlException.$(paramNamePosition, "o3MaxLag must be non negative");
            }
            return this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSetO3MaxLag(tableNamePosition, tableToken, tableId, o3MaxLag).build());
        }
        throw SqlException.$(paramNamePosition, "unknown parameter '").put(paramName).put('\'');
    }

    private CompiledQuery alterTableSetType(SqlExecutionContext executionContext, int pos, TableToken tableToken, byte walFlag) throws SqlException {
        executionContext.getSecurityContext().authorizeAlterTableSetType(tableToken);
        try {
            try (TableReader reader = this.engine.getReader(tableToken);){
                if (reader != null && !PartitionBy.isPartitioned(reader.getMetadata().getPartitionBy())) {
                    throw SqlException.$(pos, "Cannot convert non-partitioned table");
                }
            }
            this.path.of(this.configuration.getRoot()).concat(tableToken.getDirName());
            TableUtils.createConvertFile(this.ff, this.path, walFlag);
            return this.compiledQuery.ofTableSetType();
        }
        catch (CairoException e) {
            throw SqlException.position(pos).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private CompiledQuery compileBegin(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofBegin();
    }

    private CompiledQuery compileCommit(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofCommit();
    }

    private RecordCursorFactory compileCopy(SecurityContext securityContext, CopyModel model) throws SqlException {
        CharSequence fileName;
        assert (!model.isCancel());
        securityContext.authorizeCopy();
        if (model.getTimestampColumnName() == null && model.getPartitionBy() != -1 && model.getPartitionBy() != 3) {
            throw SqlException.$(-1, "invalid option used for import without a designated timestamp (format or partition by)");
        }
        if (model.getDelimiter() < 0) {
            model.setDelimiter((byte)44);
        }
        CharSequence tableName = GenericLexer.unquote(model.getTarget().token);
        ExpressionNode fileNameNode = model.getFileName();
        CharSequence charSequence = fileName = fileNameNode != null ? GenericLexer.assertNoDots(GenericLexer.unquote(fileNameNode.token), fileNameNode.position) : null;
        assert (fileName != null);
        return new CopyFactory(this.messageBus, this.engine.getCopyContext(), Chars.toString(tableName), Chars.toString(fileName), model);
    }

    private RecordCursorFactory compileCopyCancel(SqlExecutionContext executionContext, CopyModel model) throws SqlException {
        long cancelCopyID;
        assert (model.isCancel());
        String cancelCopyIDStr = Chars.toString(GenericLexer.unquote(model.getTarget().token));
        try {
            cancelCopyID = Numbers.parseHexLong(cancelCopyIDStr);
        }
        catch (NumericException e) {
            throw SqlException.$(0, "copy cancel ID format is invalid: '").put(cancelCopyIDStr).put('\'');
        }
        return new CopyCancelFactory(this.engine.getCopyContext(), cancelCopyID, cancelCopyIDStr, this.query().$("select * from '").$(this.engine.getConfiguration().getSystemTableNamePrefix()).$("text_import_log' where id = '").$(cancelCopyIDStr).$("' limit -1").compile(executionContext).getRecordCursorFactory());
    }

    private CompiledQuery compileDeallocate(SqlExecutionContext executionContext) throws SqlException {
        CharSequence statementName = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "statement name"));
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("]");
        }
        return this.compiledQuery.ofDeallocate(statementName);
    }

    private ExecutionModel compileExecutionModel(SqlExecutionContext executionContext) throws SqlException {
        ExecutionModel model = this.parser.parse(this.lexer, executionContext);
        if (7 != model.getModelType()) {
            return this.compileExecutionModel0(executionContext, model);
        }
        ExplainModel explainModel = (ExplainModel)model;
        explainModel.setModel(this.compileExecutionModel0(executionContext, explainModel.getInnerExecutionModel()));
        return explainModel;
    }

    private ExecutionModel compileExecutionModel0(SqlExecutionContext executionContext, ExecutionModel model) throws SqlException {
        switch (model.getModelType()) {
            case 1: {
                return this.optimiser.optimise((QueryModel)model, executionContext);
            }
            case 4: {
                InsertModel insertModel = (InsertModel)model;
                if (insertModel.getQueryModel() != null) {
                    this.validateAndOptimiseInsertAsSelect(executionContext, insertModel);
                } else {
                    this.lightlyValidateInsertModel(insertModel);
                }
                TableToken tableToken = this.engine.getTableTokenIfExists(insertModel.getTableName());
                executionContext.getSecurityContext().authorizeInsert(tableToken, insertModel.getColumnNameList());
                return insertModel;
            }
            case 6: {
                QueryModel queryModel = (QueryModel)model;
                TableToken tableToken = executionContext.getTableToken(queryModel.getTableName());
                try (TableRecordMetadata metadata = executionContext.getMetadata(tableToken);){
                    this.optimiser.optimiseUpdate(queryModel, executionContext, metadata);
                    ExecutionModel executionModel = model;
                    return executionModel;
                }
            }
        }
        return model;
    }

    private CompiledQuery compileInner(@NotNull SqlExecutionContext executionContext, CharSequence query) throws SqlException {
        short type;
        CharSequence tok;
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        if (!circuitBreaker.isTimerSet()) {
            circuitBreaker.resetTimer();
        }
        if ((tok = SqlUtil.fetchNext(this.lexer)) == null) {
            throw SqlException.$(0, "empty query");
        }
        KeywordBasedExecutor executor = this.keywordBasedExecutors.get(tok);
        CompiledQuery cq = null;
        if (executor != null) {
            cq = executor.execute(executionContext);
        }
        if (cq == null) {
            cq = this.compileUsingModel(executionContext);
        }
        if (!((type = cq.getType()) != 4 && type != 14 || executionContext.isWalApplication())) {
            cq.withSqlStatement(Chars.toString(query));
        }
        cq.withContext(executionContext);
        return cq;
    }

    private CompiledQuery compileRollback(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofRollback();
    }

    private CompiledQuery compileSet(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofSet();
    }

    @NotNull
    private CompiledQuery compileUsingModel(SqlExecutionContext executionContext) throws SqlException {
        this.lexer.unparseLast();
        this.codeGenerator.clear();
        ExecutionModel executionModel = this.compileExecutionModel(executionContext);
        switch (executionModel.getModelType()) {
            case 1: {
                LOG.info().$("plan [q=`").$((QueryModel)executionModel).$("`, fd=").$(executionContext.getRequestFd()).$(']').$();
                return this.compiledQuery.of(this.generate((QueryModel)executionModel, executionContext));
            }
            case 2: {
                return this.createTableWithRetries(executionModel, executionContext);
            }
            case 5: {
                return this.copy(executionContext, (CopyModel)executionModel);
            }
            case 3: {
                RenameTableModel rtm = (RenameTableModel)executionModel;
                this.engine.rename(executionContext.getSecurityContext(), this.path, this.mem, GenericLexer.unquote(rtm.getFrom().token), this.renamePath, GenericLexer.unquote(rtm.getTo().token));
                return this.compiledQuery.ofRenameTable();
            }
            case 6: {
                QueryModel updateQueryModel = (QueryModel)executionModel;
                TableToken tableToken = executionContext.getTableToken(updateQueryModel.getTableName());
                try (TableRecordMetadata metadata = executionContext.getMetadata(tableToken);){
                    UpdateOperation updateOperation = this.generateUpdate(updateQueryModel, executionContext, metadata);
                    CompiledQuery compiledQuery = this.compiledQuery.ofUpdate(updateOperation);
                    return compiledQuery;
                }
            }
            case 7: {
                return this.compiledQuery.ofExplain(this.generateExplain((ExplainModel)executionModel, executionContext));
            }
        }
        InsertModel insertModel = (InsertModel)executionModel;
        if (insertModel.getQueryModel() != null) {
            return this.executeWithRetries(this.insertAsSelectMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
        }
        return this.insert(executionModel, executionContext);
    }

    @NotNull
    private CompiledQuery copy(SqlExecutionContext executionContext, CopyModel copyModel) throws SqlException {
        if (!copyModel.isCancel() && Chars.equalsLowerCaseAscii(copyModel.getFileName().token, "stdin")) {
            executionContext.getSecurityContext().authorizeCopy();
            this.setupTextLoaderFromModel(copyModel);
            return this.compiledQuery.ofCopyRemote(this.textLoader);
        }
        RecordCursorFactory copyFactory = copyModel.isCancel() ? this.compileCopyCancel(executionContext, copyModel) : this.compileCopy(executionContext.getSecurityContext(), copyModel);
        return this.compiledQuery.ofPseudoSelect(copyFactory);
    }

    private long copyOrdered(TableWriterAPI writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = ColumnType.isSymbolOrString(metadata.getColumnType(cursorTimestampIndex)) ? this.copyOrderedStrTimestamp(writer, cursor, copier, cursorTimestampIndex, circuitBreaker) : this.copyOrdered0(writer, cursor, copier, cursorTimestampIndex, circuitBreaker);
        writer.commit();
        return rowCount;
    }

    private long copyOrdered0(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        return rowCount;
    }

    private long copyOrderedBatched(TableWriterAPI writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = ColumnType.isSymbolOrString(metadata.getColumnType(cursorTimestampIndex)) ? this.copyOrderedBatchedStrTimestamp(writer, cursor, copier, cursorTimestampIndex, batchSize, o3MaxLag, circuitBreaker) : this.copyOrderedBatched0(writer, cursor, copier, cursorTimestampIndex, batchSize, o3MaxLag, circuitBreaker);
        writer.commit();
        return rowCount;
    }

    private long copyOrderedBatched0(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long deadline = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
            if (++rowCount <= deadline) continue;
            writer.ic(o3MaxLag);
            deadline = rowCount + batchSize;
        }
        return rowCount;
    }

    private long copyOrderedBatchedStrTimestamp(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long deadline = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            CharSequence str = record.getStr(cursorTimestampIndex);
            TableWriter.Row row = writer.newRow(SqlUtil.parseFloorPartialTimestamp(str, -1, 8));
            copier.copy(record, row);
            row.append();
            if (++rowCount <= deadline) continue;
            writer.ic(o3MaxLag);
            deadline = rowCount + batchSize;
        }
        return rowCount;
    }

    private long copyOrderedStrTimestamp(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            CharSequence str = record.getStr(cursorTimestampIndex);
            TableWriter.Row row = writer.newRow(SqlUtil.implicitCastStrAsTimestamp(str));
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        return rowCount;
    }

    private long copyTableData(RecordCursor cursor, RecordMetadata metadata, TableWriterAPI writer, RecordMetadata writerMetadata, RecordToRowCopier recordToRowCopier, SqlExecutionCircuitBreaker circuitBreaker) {
        int timestampIndex = writerMetadata.getTimestampIndex();
        if (timestampIndex == -1) {
            return this.copyUnordered(cursor, writer, recordToRowCopier, circuitBreaker);
        }
        return this.copyOrdered(writer, metadata, cursor, recordToRowCopier, timestampIndex, circuitBreaker);
    }

    private void copyTableDataAndUnlock(SecurityContext securityContext, TableToken tableToken, boolean isWalEnabled, RecordCursor cursor, RecordMetadata cursorMetadata, int position, SqlExecutionCircuitBreaker circuitBreaker) throws SqlException {
        block10: {
            TableWriter writer;
            block9: {
                TableWriterAPI writerAPI = null;
                writer = null;
                try {
                    if (!isWalEnabled) {
                        writer = new TableWriter(this.configuration, tableToken, this.messageBus, null, false, DefaultLifecycleManager.INSTANCE, this.configuration.getRoot(), this.engine.getMetrics());
                        writerAPI = writer;
                    } else {
                        writerAPI = this.engine.getTableWriterAPI(tableToken, "create as select");
                    }
                    TableRecordMetadata writerMetadata = writerAPI.getMetadata();
                    this.entityColumnFilter.of(writerMetadata.getColumnCount());
                    this.insertCount = this.copyTableData(cursor, cursorMetadata, writerAPI, writerMetadata, RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter), circuitBreaker);
                    if (!isWalEnabled) break block9;
                }
                catch (CairoException e) {
                    try {
                        LOG.error().$("could not create table [error=").$(e).I$();
                        writerAPI = Misc.free(writerAPI);
                        writer = null;
                        if (e.isInterruption()) {
                            throw e;
                        }
                        throw SqlException.$(position, "Could not create table. See log for details.");
                    }
                    catch (Throwable throwable) {
                        if (isWalEnabled) {
                            Misc.free(writerAPI);
                        } else {
                            this.engine.unlock(securityContext, tableToken, writer, false);
                        }
                        throw throwable;
                    }
                }
                Misc.free(writerAPI);
                break block10;
            }
            this.engine.unlock(securityContext, tableToken, writer, false);
        }
    }

    private void copyTableReaderMetadataToCreateTableModel(SqlExecutionContext executionContext, CreateTableModel model) throws SqlException {
        ExpressionNode likeTableName = model.getLikeTableName();
        CharSequence likeTableNameToken = likeTableName.token;
        TableToken tableToken = executionContext.getTableToken(likeTableNameToken);
        try (TableReader rdr = executionContext.getReader(tableToken);){
            model.setO3MaxLag(rdr.getO3MaxLag());
            model.setMaxUncommittedRows(rdr.getMaxUncommittedRows());
            TableReaderMetadata rdrMetadata = rdr.getMetadata();
            for (int i = 0; i < rdrMetadata.getColumnCount(); ++i) {
                int columnType = rdrMetadata.getColumnType(i);
                boolean isSymbol = ColumnType.isSymbol(columnType);
                int symbolCapacity = isSymbol ? rdr.getSymbolMapReader(i).getSymbolCapacity() : this.configuration.getDefaultSymbolCapacity();
                model.addColumn(rdrMetadata.getColumnName(i), columnType, symbolCapacity);
                if (isSymbol) {
                    model.cached(rdr.getSymbolMapReader(i).isCached());
                }
                model.setIndexFlags(rdrMetadata.isColumnIndexed(i), rdrMetadata.getIndexValueBlockCapacity(i));
            }
            model.setPartitionBy(SqlUtil.nextLiteral(this.sqlNodePool, PartitionBy.toString(rdr.getPartitionedBy()), 0));
            if (rdrMetadata.getTimestampIndex() != -1) {
                model.setTimestamp(SqlUtil.nextLiteral(this.sqlNodePool, rdrMetadata.getColumnName(rdrMetadata.getTimestampIndex()), 0));
            }
            model.setWalEnabled(this.configuration.isWalSupported() && rdrMetadata.isWalEnabled());
        }
        model.setLikeTableName(null);
    }

    private long copyUnordered(RecordCursor cursor, TableWriterAPI writer, RecordToRowCopier copier, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            TableWriter.Row row = writer.newRow();
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        writer.commit();
        return rowCount;
    }

    private CompiledQuery createTable(ExecutionModel model, SqlExecutionContext executionContext) throws SqlException {
        CreateTableModel createTableModel = (CreateTableModel)model;
        ExpressionNode name = createTableModel.getName();
        TableToken tableToken = executionContext.getTableTokenIfExists(name.token);
        int status = executionContext.getTableStatus(this.path, tableToken);
        if (createTableModel.isIgnoreIfExists() && status != 1) {
            return this.compiledQuery.ofCreateTable(tableToken);
        }
        if (status != 1) {
            throw SqlException.$(name.position, "table already exists");
        }
        CharSequence volumeAlias = createTableModel.getVolumeAlias();
        if (volumeAlias != null) {
            CharSequence volumePath = this.configuration.getVolumeDefinitions().resolveAlias(volumeAlias);
            if (volumePath != null) {
                if (!this.ff.isDirOrSoftLinkDir(this.path.of(volumePath).$())) {
                    throw CairoException.critical(0).put("not a valid path for volume [alias=").put(volumeAlias).put(", path=").put(this.path).put(']');
                }
            } else {
                throw SqlException.position(0).put("volume alias is not allowed [alias=").put(volumeAlias).put(']');
            }
        }
        this.insertCount = -1L;
        if (createTableModel.getQueryModel() == null) {
            try {
                if (createTableModel.getLikeTableName() != null) {
                    this.copyTableReaderMetadataToCreateTableModel(executionContext, createTableModel);
                }
                if (volumeAlias == null) {
                    tableToken = this.engine.createTable(executionContext.getSecurityContext(), this.mem, this.path, createTableModel.isIgnoreIfExists(), createTableModel, false);
                }
                tableToken = this.engine.createTableInVolume(executionContext.getSecurityContext(), this.mem, this.path, createTableModel.isIgnoreIfExists(), createTableModel, false);
            }
            catch (EntryUnavailableException e) {
                throw SqlException.$(name.position, "table already exists");
            }
            catch (CairoException e) {
                LOG.error().$("could not create table [error=").$(e).I$();
                if (e.isInterruption()) {
                    throw e;
                }
                throw SqlException.$(name.position, "Could not create table, ").put(e.getFlyweightMessage());
            }
        } else {
            tableToken = this.createTableFromCursorExecutor(createTableModel, executionContext, name.position, volumeAlias);
        }
        if (createTableModel.getQueryModel() == null) {
            return this.compiledQuery.ofCreateTable(tableToken);
        }
        return this.compiledQuery.ofCreateTableAsSelect(tableToken, this.insertCount);
    }

    private TableToken createTableFromCursorExecutor(CreateTableModel model, SqlExecutionContext executionContext, int position, CharSequence volumeAlias) throws SqlException {
        try (RecordCursorFactory factory = this.generate(model.getQueryModel(), executionContext);){
            RecordCursor cursor = factory.getCursor(executionContext);
            try {
                this.typeCast.clear();
                RecordMetadata metadata = factory.getMetadata();
                this.validateTableModelAndCreateTypeCast(model, metadata, this.typeCast);
                boolean keepLock = !model.isWalEnabled();
                TableToken tableToken = volumeAlias == null ? this.engine.createTable(executionContext.getSecurityContext(), this.mem, this.path, false, this.tableStructureAdapter.of(model, metadata, this.typeCast), keepLock) : this.engine.createTableInVolume(executionContext.getSecurityContext(), this.mem, this.path, false, this.tableStructureAdapter.of(model, metadata, this.typeCast), keepLock);
                SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
                try {
                    this.copyTableDataAndUnlock(executionContext.getSecurityContext(), tableToken, model.isWalEnabled(), cursor, metadata, position, circuitBreaker);
                }
                catch (CairoException e) {
                    LOG.error().$(e.getFlyweightMessage()).$(" [errno=").$(e.getErrno()).$(']').$();
                    this.engine.drop(this.path, tableToken);
                    this.engine.unlockTableName(tableToken);
                    throw e;
                }
                TableToken tableToken2 = tableToken;
                if (cursor != null) {
                    cursor.close();
                }
                return tableToken2;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private CompiledQuery createTableWithRetries(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        return this.executeWithRetries(this.createTableMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
    }

    private CompiledQuery dropTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok)) {
            return this.unknownDropStatement(executionContext, tok);
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "expected [if exists] table-name");
        }
        boolean hasIfExists = false;
        if (SqlKeywords.isIfKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok == null || !SqlKeywords.isExistsKeyword(tok)) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "expected exists");
            }
            hasIfExists = true;
        } else {
            this.lexer.unparseLast();
        }
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tableName = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            return this.unknownDropTableSuffix(executionContext, tok, tableName, tableNamePosition, hasIfExists);
        }
        TableToken tableToken = executionContext.getTableTokenIfExists(tableName);
        if (executionContext.getTableStatus(this.path, tableToken) != 0) {
            if (hasIfExists) {
                return this.compiledQuery.ofDrop();
            }
            throw SqlException.tableDoesNotExist(tableNamePosition, tableName);
        }
        executionContext.getSecurityContext().authorizeTableDrop(tableToken);
        this.engine.drop(this.path, tableToken);
        return this.compiledQuery.ofDrop();
    }

    private CompiledQuery executeWithRetries(ExecutableMethod method, ExecutionModel executionModel, int retries, SqlExecutionContext executionContext) throws SqlException {
        int attemptsLeft = retries;
        while (true) {
            try {
                return method.execute(executionModel, executionContext);
            }
            catch (TableReferenceOutOfDateException e) {
                this.clear();
                this.lexer.restart();
                executionModel = this.compileExecutionModel(executionContext);
                if (--attemptsLeft > 0) continue;
                throw SqlException.position(0).put("underlying cursor is extremely volatile");
            }
            break;
        }
    }

    private int filterPartitions(Function function, int functionPosition, TableReader reader, AlterOperationBuilder changePartitionStatement) {
        int affectedPartitions = 0;
        int partitionCount = reader.getPartitionCount();
        if (partitionCount > 0) {
            for (int i = partitionCount - 2; i > -1; --i) {
                long partitionTimestamp = reader.getPartitionTimestampByIndex(i);
                this.partitionFunctionRec.setTimestamp(partitionTimestamp);
                if (!function.getBool(this.partitionFunctionRec)) continue;
                changePartitionStatement.addPartitionToList(partitionTimestamp, functionPosition);
                ++affectedPartitions;
            }
            long partitionTimestamp = reader.getPartitionTimestampByIndex(partitionCount - 1);
            this.partitionFunctionRec.setTimestamp(partitionTimestamp);
            if (function.getBool(this.partitionFunctionRec)) {
                changePartitionStatement.addPartitionToList(partitionTimestamp, functionPosition);
                ++affectedPartitions;
            }
        }
        return affectedPartitions;
    }

    private RecordCursorFactory generateExplain(ExplainModel model, SqlExecutionContext executionContext) throws SqlException {
        if (model.getInnerExecutionModel().getModelType() == 6) {
            QueryModel updateQueryModel = model.getInnerExecutionModel().getQueryModel();
            QueryModel selectQueryModel = updateQueryModel.getNestedModel();
            RecordCursorFactory recordCursorFactory = this.prepareForUpdate(updateQueryModel.getUpdateTableToken(), selectQueryModel, updateQueryModel, executionContext);
            return this.codeGenerator.generateExplain(updateQueryModel, recordCursorFactory, model.getFormat());
        }
        return this.codeGenerator.generateExplain(model, executionContext);
    }

    private UpdateOperation generateUpdate(QueryModel updateQueryModel, SqlExecutionContext executionContext, TableRecordMetadata metadata) throws SqlException {
        TableToken updateTableToken = updateQueryModel.getUpdateTableToken();
        QueryModel selectQueryModel = updateQueryModel.getNestedModel();
        RecordCursorFactory recordCursorFactory = this.prepareForUpdate(updateTableToken, selectQueryModel, updateQueryModel, executionContext);
        if (!metadata.isWalEnabled() || executionContext.isWalApplication()) {
            return new UpdateOperation(updateTableToken, selectQueryModel.getTableId(), selectQueryModel.getTableVersion(), this.lexer.getPosition(), recordCursorFactory);
        }
        recordCursorFactory.close();
        if (selectQueryModel.containsJoin()) {
            throw SqlException.position(0).put("UPDATE statements with join are not supported yet for WAL tables");
        }
        return new UpdateOperation(updateTableToken, metadata.getTableId(), metadata.getMetadataVersion(), this.lexer.getPosition());
    }

    private int getNextValidTokenPosition() {
        while (this.lexer.hasNext()) {
            CharSequence token = SqlUtil.fetchNext(this.lexer);
            if (token == null) {
                return -1;
            }
            if (SqlKeywords.isSemicolon(token)) continue;
            this.lexer.unparseLast();
            return this.lexer.lastTokenPosition();
        }
        return -1;
    }

    private int goToQueryEnd() {
        CharSequence token;
        this.lexer.unparseLast();
        while (this.lexer.hasNext() && (token = SqlUtil.fetchNext(this.lexer)) != null && !SqlKeywords.isSemicolon(token)) {
        }
        return this.lexer.getPosition();
    }

    private CompiledQuery insert(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        CompiledQuery compiledQuery;
        block16: {
            InsertModel model = (InsertModel)executionModel;
            ExpressionNode tableNameExpr = model.getTableNameExpr();
            ObjList<Function> valueFunctions = null;
            TableToken token = this.tableExistsOrFail(tableNameExpr.position, tableNameExpr.token, executionContext);
            TableRecordMetadata metadata = this.engine.getMetadata(token);
            try {
                long metadataVersion = metadata.getMetadataVersion();
                InsertOperationImpl insertOperation = new InsertOperationImpl(this.engine, metadata.getTableToken(), metadataVersion);
                int metadataTimestampIndex = metadata.getTimestampIndex();
                ObjList<CharSequence> columnNameList = model.getColumnNameList();
                int columnSetSize = columnNameList.size();
                int n = model.getRowTupleCount();
                for (int tupleIndex = 0; tupleIndex < n; ++tupleIndex) {
                    Function timestampFunction = null;
                    this.listColumnFilter.clear();
                    if (columnSetSize > 0) {
                        valueFunctions = new ObjList<Function>(columnSetSize);
                        for (int i = 0; i < columnSetSize; ++i) {
                            int metadataColumnIndex = metadata.getColumnIndexQuiet(columnNameList.getQuick(i));
                            if (metadataColumnIndex > -1) {
                                ExpressionNode node = model.getRowTupleValues(tupleIndex).getQuick(i);
                                Function function = this.functionParser.parseFunction(node, EmptyRecordMetadata.INSTANCE, executionContext);
                                this.insertValidateFunctionAndAddToList(model, tupleIndex, valueFunctions, metadata, metadataTimestampIndex, i, metadataColumnIndex, function, node.position, executionContext.getBindVariableService());
                                if (metadataTimestampIndex != metadataColumnIndex) continue;
                                timestampFunction = function;
                                continue;
                            }
                            throw SqlException.invalidColumn(model.getColumnPosition(i), columnNameList.getQuick(i));
                        }
                    } else {
                        ObjList<ExpressionNode> values;
                        int valueCount;
                        int columnCount = metadata.getColumnCount();
                        if (columnCount != (valueCount = (values = model.getRowTupleValues(tupleIndex)).size())) {
                            throw SqlException.$(model.getEndOfRowTupleValuesPosition(tupleIndex), "row value count does not match column count [expected=").put(columnCount).put(", actual=").put(values.size()).put(", tuple=").put(tupleIndex + 1).put(']');
                        }
                        valueFunctions = new ObjList(columnCount);
                        for (int i = 0; i < columnCount; ++i) {
                            ExpressionNode node = values.getQuick(i);
                            Function function = this.functionParser.parseFunction(node, EmptyRecordMetadata.INSTANCE, executionContext);
                            this.insertValidateFunctionAndAddToList(model, tupleIndex, valueFunctions, metadata, metadataTimestampIndex, i, i, function, node.position, executionContext.getBindVariableService());
                            if (metadataTimestampIndex != i) continue;
                            timestampFunction = function;
                        }
                    }
                    if (metadataTimestampIndex > -1 && (timestampFunction == null || ColumnType.isNull(timestampFunction.getType()))) {
                        throw SqlException.$(0, "insert statement must populate timestamp");
                    }
                    VirtualRecord record = new VirtualRecord(valueFunctions);
                    RecordToRowCopier copier = RecordToRowCopierUtils.generateCopier(this.asm, record, metadata, this.listColumnFilter);
                    insertOperation.addInsertRow(new InsertRowImpl(record, copier, timestampFunction, tupleIndex));
                }
                compiledQuery = this.compiledQuery.ofInsert(insertOperation);
                if (metadata == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (metadata != null) {
                        try {
                            metadata.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SqlException e) {
                    Misc.freeObjList(valueFunctions);
                    throw e;
                }
            }
            metadata.close();
        }
        return compiledQuery;
    }

    private CompiledQuery insertAsSelect(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        long insertCount;
        InsertModel model = (InsertModel)executionModel;
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        TableToken tableToken = this.tableExistsOrFail(tableNameExpr.position, tableNameExpr.token, executionContext);
        try (TableWriterAPI writer = this.engine.getTableWriterAPI(tableToken, "insertAsSelect");
             RecordCursorFactory factory = this.generate(model.getQueryModel(), executionContext);){
            RecordToRowCopier copier;
            RecordMetadata cursorMetadata = factory.getMetadata();
            GenericRecordMetadata writerMetadata = GenericRecordMetadata.copyDense(writer.getMetadata());
            int writerTimestampIndex = writerMetadata.getTimestampIndex();
            int cursorTimestampIndex = cursorMetadata.getTimestampIndex();
            int cursorColumnCount = cursorMetadata.getColumnCount();
            ObjList<CharSequence> columnNameList = model.getColumnNameList();
            int columnSetSize = columnNameList.size();
            int timestampIndexFound = -1;
            if (columnSetSize > 0) {
                this.listColumnFilter.clear();
                for (int i = 0; i < columnSetSize; ++i) {
                    int toType;
                    CharSequence columnName = columnNameList.get(i);
                    int index = writerMetadata.getColumnIndexQuiet(columnName);
                    if (index == -1) {
                        throw SqlException.invalidColumn(model.getColumnPosition(i), columnName);
                    }
                    int fromType = cursorMetadata.getColumnType(i);
                    if (!ColumnType.isAssignableFrom(fromType, toType = writerMetadata.getColumnType(index))) {
                        throw SqlException.inconvertibleTypes(model.getColumnPosition(i), fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                    }
                    this.listColumnFilter.add(index + 1);
                    if (index != writerTimestampIndex) continue;
                    timestampIndexFound = i;
                    if (fromType == 8 || fromType == 11) continue;
                    throw SqlException.$(tableNameExpr.position, "expected timestamp column but type is ").put(ColumnType.nameOf(fromType));
                }
                if (timestampIndexFound < 0 && writerTimestampIndex >= 0) {
                    throw SqlException.$(tableNameExpr.position, "select clause must provide timestamp column");
                }
                copier = RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.listColumnFilter);
            } else {
                if (writerTimestampIndex > -1 && cursorTimestampIndex == -1) {
                    if (cursorColumnCount <= writerTimestampIndex) {
                        throw SqlException.$(tableNameExpr.position, "select clause must provide timestamp column");
                    }
                    short columnType = ColumnType.tagOf(cursorMetadata.getColumnType(writerTimestampIndex));
                    if (columnType != 8 && columnType != 11 && columnType != 29) {
                        throw SqlException.$(tableNameExpr.position, "expected timestamp column but type is ").put(ColumnType.nameOf(columnType));
                    }
                }
                if (writerTimestampIndex > -1 && cursorTimestampIndex > -1 && writerTimestampIndex != cursorTimestampIndex) {
                    throw SqlException.$(tableNameExpr.position, "designated timestamp of existing table (").put(writerTimestampIndex).put(") does not match designated timestamp in select query (").put(cursorTimestampIndex).put(')');
                }
                timestampIndexFound = writerTimestampIndex;
                int n = writerMetadata.getColumnCount();
                if (n > cursorMetadata.getColumnCount()) {
                    throw SqlException.$(model.getSelectKeywordPosition(), "not enough columns selected");
                }
                for (int i = 0; i < n; ++i) {
                    int toType;
                    int fromType = cursorMetadata.getColumnType(i);
                    if (ColumnType.isAssignableFrom(fromType, toType = writerMetadata.getColumnType(i))) continue;
                    assert (i < model.getQueryModel().getBottomUpColumns().size());
                    throw SqlException.inconvertibleTypes(model.getQueryModel().getBottomUpColumns().getQuick((int)i).getAst().position, fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                }
                this.entityColumnFilter.of(writerMetadata.getColumnCount());
                copier = RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
            }
            SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                try {
                    insertCount = writerTimestampIndex == -1 ? this.copyUnordered(cursor, writer, copier, circuitBreaker) : (model.getBatchSize() != -1L ? this.copyOrderedBatched(writer, factory.getMetadata(), cursor, copier, writerTimestampIndex, model.getBatchSize(), model.getO3MaxLag(), circuitBreaker) : this.copyOrdered(writer, factory.getMetadata(), cursor, copier, timestampIndexFound, circuitBreaker));
                }
                catch (Throwable e) {
                    writer.rollback();
                    throw e;
                }
            }
        }
        return this.compiledQuery.ofInsertAsSelect(insertCount);
    }

    private void insertValidateFunctionAndAddToList(InsertModel model, int tupleIndex, ObjList<Function> valueFunctions, RecordMetadata metadata, int metadataTimestampIndex, int insertColumnIndex, int metadataColumnIndex, Function function, int functionPosition, BindVariableService bindVariableService) throws SqlException {
        int columnType = metadata.getColumnType(metadataColumnIndex);
        if (function.isUndefined()) {
            function.assignType(columnType, bindVariableService);
        }
        if (ColumnType.isAssignableFrom(function.getType(), columnType)) {
            if (metadataColumnIndex == metadataTimestampIndex) {
                return;
            }
            valueFunctions.add(function);
            this.listColumnFilter.add(metadataColumnIndex + 1);
            return;
        }
        throw SqlException.inconvertibleTypes(functionPosition, function.getType(), model.getRowTupleValues((int)tupleIndex).getQuick((int)insertColumnIndex).token, metadata.getColumnType(metadataColumnIndex), metadata.getColumnName(metadataColumnIndex));
    }

    private void lightlyValidateInsertModel(InsertModel model) throws SqlException {
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        if (tableNameExpr.type != 4) {
            throw SqlException.$(tableNameExpr.position, "literal expected");
        }
        int columnNameListSize = model.getColumnNameList().size();
        if (columnNameListSize > 0) {
            int n = model.getRowTupleCount();
            for (int i = 0; i < n; ++i) {
                if (columnNameListSize == model.getRowTupleValues(i).size()) continue;
                throw SqlException.$(model.getEndOfRowTupleValuesPosition(i), "row value count does not match column count [expected=").put(columnNameListSize).put(", actual=").put(model.getRowTupleValues(i).size()).put(", tuple=").put(i + 1).put(']');
            }
        }
    }

    private RecordCursorFactory prepareForUpdate(TableToken tableToken, QueryModel selectQueryModel, QueryModel updateQueryModel, SqlExecutionContext executionContext) throws SqlException {
        IntList tableColumnTypes = selectQueryModel.getUpdateTableColumnTypes();
        ObjList<CharSequence> tableColumnNames = selectQueryModel.getUpdateTableColumnNames();
        RecordCursorFactory updateToDataCursorFactory = this.codeGenerator.generate(selectQueryModel, executionContext);
        try {
            if (!updateToDataCursorFactory.supportsUpdateRowId(tableToken)) {
                throw SqlException.$(updateQueryModel.getModelPosition(), "Unsupported SQL complexity for the UPDATE statement");
            }
            RecordMetadata updateDataFactoryMetadata = updateToDataCursorFactory.getMetadata();
            int n = updateDataFactoryMetadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String updateColumnName;
                int tableColumnIndex;
                int tableColumnType;
                int virtualColumnType = updateDataFactoryMetadata.getColumnType(i);
                if (virtualColumnType == (tableColumnType = tableColumnTypes.get(tableColumnIndex = tableColumnNames.indexOf(updateColumnName = updateDataFactoryMetadata.getColumnName(i)))) || ColumnType.isSymbolOrString(tableColumnType) && ColumnType.isAssignableFrom(virtualColumnType, 11)) continue;
                ExpressionNode setRhs = updateQueryModel.getNestedModel().getColumns().getQuick(i).getAst();
                throw SqlException.inconvertibleTypes(setRhs.position, virtualColumnType, "", tableColumnType, updateColumnName);
            }
            return updateToDataCursorFactory;
        }
        catch (Throwable th) {
            updateToDataCursorFactory.close();
            throw th;
        }
    }

    private CompiledQuery reindexTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "TABLE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || Chars.equals(tok, ',')) {
            throw SqlException.$(this.lexer.getPosition(), "table name expected");
        }
        if (Chars.isQuoted(tok)) {
            tok = GenericLexer.unquote(tok);
        }
        TableToken tableToken = this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
        this.rebuildIndex.of(this.path.of(this.configuration.getRoot()).concat(tableToken.getDirName()));
        tok = SqlUtil.fetchNext(this.lexer);
        CharSequence columnName = null;
        if (tok != null && SqlKeywords.isColumnKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            if (tok == null || TableUtils.isValidColumnName(tok, this.configuration.getMaxFileNameLength())) {
                columnName = GenericLexer.immutableOf(tok);
                tok = SqlUtil.fetchNext(this.lexer);
            }
        }
        CharSequence partition = null;
        if (tok != null && SqlKeywords.isPartitionKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            partition = tok;
            tok = SqlUtil.fetchNext(this.lexer);
        }
        if (tok == null || !SqlKeywords.isLockKeyword(tok)) {
            throw SqlException.$(this.lexer.getPosition(), "LOCK EXCLUSIVE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isExclusiveKeyword(tok)) {
            throw SqlException.$(this.lexer.getPosition(), "LOCK EXCLUSIVE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlException.$(this.lexer.getPosition(), "EOF expected");
        }
        executionContext.getSecurityContext().authorizeTableReindex(tableToken, columnName);
        this.rebuildIndex.reindex(partition, columnName);
        return this.compiledQuery.ofRepair();
    }

    private void setupTextLoaderFromModel(CopyModel model) {
        this.textLoader.clear();
        this.textLoader.setState(1);
        this.textLoader.configureDestination(model.getTarget().token, false, model.getAtomicity() != -1 ? model.getAtomicity() : 1, model.getPartitionBy() < 0 ? 3 : model.getPartitionBy(), model.getTimestampColumnName(), model.getTimestampFormat());
    }

    private CompiledQuery snapshotDatabase(SqlExecutionContext executionContext) throws SqlException {
        executionContext.getSecurityContext().authorizeDatabaseSnapshot();
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'prepare' or 'complete'");
        if (Chars.equalsLowerCaseAscii(tok, "prepare")) {
            if (this.snapshotAgent == null) {
                throw SqlException.position(this.lexer.lastTokenPosition()).put("Snapshot agent is not configured. Try using different embedded API");
            }
            this.snapshotAgent.prepareSnapshot(executionContext);
            return this.compiledQuery.ofSnapshotPrepare();
        }
        if (Chars.equalsLowerCaseAscii(tok, "complete")) {
            if (this.snapshotAgent == null) {
                throw SqlException.position(this.lexer.lastTokenPosition()).put("Snapshot agent is not configured. Try using different embedded API");
            }
            this.snapshotAgent.completeSnapshot();
            return this.compiledQuery.ofSnapshotComplete();
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("'prepare' or 'complete' expected");
    }

    private CompiledQuery sqlShow(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null) {
            RecordCursorFactory factory = null;
            if (SqlKeywords.isTablesKeyword(tok)) {
                factory = new TableListRecordCursorFactory();
            } else if (SqlKeywords.isColumnsKeyword(tok)) {
                factory = new ShowColumnsRecordCursorFactory(this.sqlShowFromTable(executionContext));
            } else if (SqlKeywords.isPartitionsKeyword(tok)) {
                factory = new ShowPartitionsRecordCursorFactory(this.sqlShowFromTable(executionContext));
            } else if (SqlKeywords.isTransactionKeyword(tok)) {
                factory = this.sqlShowTransaction();
            } else if (SqlKeywords.isTransactionIsolation(tok)) {
                factory = new ShowTransactionIsolationLevelCursorFactory();
            } else if (SqlKeywords.isMaxIdentifierLength(tok)) {
                factory = new ShowMaxIdentifierLengthCursorFactory();
            } else if (SqlKeywords.isStandardConformingStrings(tok)) {
                factory = new ShowStandardConformingStringsCursorFactory();
            } else if (SqlKeywords.isSearchPath(tok)) {
                factory = new ShowSearchPathCursorFactory();
            } else if (SqlKeywords.isDateStyleKeyword(tok)) {
                factory = new ShowDateStyleCursorFactory();
            } else if (SqlKeywords.isTimeKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok != null && SqlKeywords.isZoneKeyword(tok)) {
                    factory = new ShowTimeZoneFactory();
                }
            } else {
                factory = this.unknownShowStatement(executionContext, tok);
            }
            if (factory != null) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || Chars.equals(tok, ';')) {
                    return this.compiledQuery.of(factory);
                }
                Misc.free(factory);
                throw SqlException.position(this.lexer.lastTokenPosition()).put("unexpected token [").put(tok).put(']');
            }
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("expected ").put("'TABLES', 'COLUMNS FROM <tab>', 'PARTITIONS FROM <tab>', ").put("'TRANSACTION ISOLATION LEVEL', 'transaction_isolation', ").put("'max_identifier_length', 'standard_conforming_strings', ").put("'search_path', 'datestyle', or 'time zone'");
    }

    private TableToken sqlShowFromTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isFromKeyword(tok)) {
            throw SqlException.position(this.lexer.getPosition()).put("expected 'from'");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.position(this.lexer.getPosition()).put("expected a table name");
        }
        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), this.lexer.lastTokenPosition());
        return this.tableExistsOrFail(this.lexer.lastTokenPosition(), tableName, executionContext);
    }

    private RecordCursorFactory sqlShowTransaction() throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && SqlKeywords.isIsolationKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && SqlKeywords.isLevelKeyword(tok)) {
                return new ShowTransactionIsolationLevelCursorFactory();
            }
            throw SqlException.position(tok != null ? this.lexer.lastTokenPosition() : this.lexer.getPosition()).put("expected 'level'");
        }
        throw SqlException.position(tok != null ? this.lexer.lastTokenPosition() : this.lexer.getPosition()).put("expected 'isolation'");
    }

    private TableToken tableExistsOrFail(int position, CharSequence tableName, SqlExecutionContext executionContext) throws SqlException {
        TableToken tableToken = executionContext.getTableTokenIfExists(tableName);
        if (executionContext.getTableStatus(this.path, tableToken) != 0) {
            throw SqlException.tableDoesNotExist(position, tableName);
        }
        return tableToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledQuery truncateTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.getPosition(), "'table' expected");
        }
        if (!SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && SqlKeywords.isOnlyKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
        }
        if (tok != null && SqlKeywords.isWithKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "table name expected");
        }
        this.tableWriters.clear();
        try {
            block26: {
                do {
                    if (tok == null || Chars.equals(tok, ',')) {
                        throw SqlException.$(this.lexer.getPosition(), "table name expected");
                    }
                    if (Chars.isQuoted(tok)) {
                        tok = GenericLexer.unquote(tok);
                    }
                    TableToken tableToken = this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
                    executionContext.getSecurityContext().authorizeTableTruncate(tableToken);
                    try {
                        this.tableWriters.add(this.engine.getTableWriterAPI(tableToken, "truncateTables"));
                    }
                    catch (CairoException e) {
                        LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).$(']').$();
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' could not be truncated: ").put(e);
                    }
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || Chars.equals(tok, ';') || SqlKeywords.isKeepKeyword(tok)) break block26;
                    if (Chars.equalsNc(tok, ',')) continue;
                    throw SqlException.$(this.lexer.getPosition(), "',' or 'keep' expected");
                } while ((tok = SqlUtil.fetchNext(this.lexer)) == null || !SqlKeywords.isKeepKeyword(tok));
                throw SqlException.$(this.lexer.getPosition(), "table name expected");
            }
            boolean keepSymbolTables = false;
            if (tok != null && SqlKeywords.isKeepKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !SqlKeywords.isSymbolKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'symbol' expected");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !SqlKeywords.isMapsKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'maps' expected");
                }
                keepSymbolTables = true;
                tok = SqlUtil.fetchNext(this.lexer);
            }
            if (tok != null && !Chars.equals(tok, ';')) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put(']');
            }
            int n = this.tableWriters.size();
            for (int i = 0; i < n; ++i) {
                TableWriterAPI writer = this.tableWriters.getQuick(i);
                try {
                    if (writer.getMetadata().isWalEnabled()) {
                        writer.truncateSoft();
                        continue;
                    }
                    TableToken tableToken = writer.getTableToken();
                    if (this.engine.lockReaders(tableToken)) {
                        try {
                            if (keepSymbolTables) {
                                writer.truncateSoft();
                                continue;
                            }
                            writer.truncate();
                            continue;
                        }
                        finally {
                            this.engine.unlockReaders(tableToken);
                        }
                    }
                    throw SqlException.$(0, "there is an active query against '").put(tableToken).put("'. Try again.");
                }
                catch (CairoError | CairoException e) {
                    LOG.error().$("could not truncate [table=").$(writer.getTableToken()).$(", e=").$((Sinkable)((Object)e)).$(']').$();
                    throw e;
                }
            }
        }
        finally {
            int n = this.tableWriters.size();
            for (int i = 0; i < n; ++i) {
                this.tableWriters.getQuick(i).close();
            }
            this.tableWriters.clear();
        }
        return this.compiledQuery.ofTruncate();
    }

    private CompiledQuery vacuum(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'table'");
        boolean partitionsKeyword = SqlKeywords.isPartitionsKeyword(tok);
        if (partitionsKeyword || SqlKeywords.isTableKeyword(tok)) {
            CharSequence tableName = SqlCompiler.expectToken(this.lexer, "table name");
            tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tableName), this.lexer.lastTokenPosition());
            int tableNamePos = this.lexer.lastTokenPosition();
            CharSequence eol = SqlUtil.fetchNext(this.lexer);
            if (eol == null || Chars.equals(eol, ';')) {
                TableToken tableToken = this.tableExistsOrFail(this.lexer.lastTokenPosition(), tableName, executionContext);
                try (TableReader rdr = executionContext.getReader(tableToken);){
                    int partitionBy = rdr.getMetadata().getPartitionBy();
                    if (PartitionBy.isPartitioned(partitionBy)) {
                        executionContext.getSecurityContext().authorizeTableVacuum(rdr.getTableToken());
                        if (!TableUtils.schedulePurgeO3Partitions(this.messageBus, rdr.getTableToken(), partitionBy)) {
                            throw SqlException.$(tableNamePos, "cannot schedule vacuum action, queue is full, please retry or increase Purge Discovery Queue Capacity");
                        }
                    } else if (partitionsKeyword) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tableName).put("' is not partitioned");
                    }
                    this.vacuumColumnVersions.run(rdr);
                    CompiledQuery compiledQuery = this.compiledQuery.ofVacuum();
                    return compiledQuery;
                }
            }
            throw SqlException.$(this.lexer.lastTokenPosition(), "end of line or ';' expected");
        }
        throw SqlException.$(this.lexer.lastTokenPosition(), "'partitions' expected");
    }

    private void validateAndOptimiseInsertAsSelect(SqlExecutionContext executionContext, InsertModel model) throws SqlException {
        QueryModel queryModel = this.optimiser.optimise(model.getQueryModel(), executionContext);
        int columnNameListSize = model.getColumnNameList().size();
        if (columnNameListSize > 0 && queryModel.getBottomUpColumns().size() != columnNameListSize) {
            throw SqlException.$(model.getTableNameExpr().position, "column count mismatch");
        }
        model.setQueryModel(queryModel);
    }

    private void validateTableModelAndCreateTypeCast(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) throws SqlException {
        CharSequence columnName;
        int i;
        CharSequenceObjHashMap<ColumnCastModel> castModels = model.getColumnCastModels();
        ObjList<CharSequence> castColumnNames = castModels.keys();
        int n = castColumnNames.size();
        for (i = 0; i < n; ++i) {
            int to;
            columnName = castColumnNames.getQuick(i);
            int index = metadata.getColumnIndexQuiet(columnName);
            ColumnCastModel ccm = castModels.get(columnName);
            if (index == -1) {
                throw SqlException.invalidColumn(ccm.getColumnNamePos(), columnName);
            }
            int from = metadata.getColumnType(index);
            if (SqlCompiler.isCompatibleCase(from, to = ccm.getColumnType())) {
                int modelColumnIndex = model.getColumnIndex(columnName);
                if (!ColumnType.isSymbol(to) && model.isIndexed(modelColumnIndex)) {
                    throw SqlException.$(ccm.getColumnTypePos(), "indexes are supported only for SYMBOL columns: ").put(columnName);
                }
            } else {
                throw SqlException.unsupportedCast(ccm.getColumnTypePos(), columnName, from, to);
            }
            typeCast.put(index, to);
        }
        n = model.getColumnCount();
        for (i = 0; i < n; ++i) {
            columnName = model.getColumnName(i);
            ColumnCastModel ccm = castModels.get(columnName);
            if (ccm != null) continue;
            int index = metadata.getColumnIndexQuiet(columnName);
            assert (index > -1) : "wtf? " + columnName;
            if (ColumnType.isSymbol(metadata.getColumnType(index)) || !model.isIndexed(i)) continue;
            throw SqlException.$(0, "indexes are supported only for SYMBOL columns: ").put(columnName);
        }
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null && metadata.getColumnType(timestamp.token) != 8) {
            throw SqlException.position(timestamp.position).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(metadata.getColumnType(timestamp.token))).put(']');
        }
        if (PartitionBy.isPartitioned(model.getPartitionBy()) && model.getTimestampIndex() == -1 && metadata.getTimestampIndex() == -1) {
            throw SqlException.position(0).put("timestamp is not defined");
        }
    }

    protected static CharSequence expectToken(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    protected static CharSequence maybeExpectToken(GenericLexer lexer, CharSequence expected, boolean expect) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (expect && tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    protected void clear() {
        this.sqlNodePool.clear();
        this.characterStore.clear();
        this.queryColumnPool.clear();
        this.queryModelPool.clear();
        this.optimiser.clear();
        this.parser.clear();
        this.backupAgent.clear();
        this.alterOperationBuilder.clear();
        this.backupAgent.clear();
        this.functionParser.clear();
    }

    RecordCursorFactory generate(QueryModel queryModel, SqlExecutionContext executionContext) throws SqlException {
        return this.codeGenerator.generate(queryModel, executionContext);
    }

    protected void registerKeywordBasedExecutors() {
        KeywordBasedExecutor compileSet = this::compileSet;
        KeywordBasedExecutor compileBegin = this::compileBegin;
        KeywordBasedExecutor compileCommit = this::compileCommit;
        KeywordBasedExecutor compileRollback = this::compileRollback;
        KeywordBasedExecutor truncateTables = this::truncateTables;
        KeywordBasedExecutor alterTable = this::alterTable;
        KeywordBasedExecutor reindexTable = this::reindexTable;
        KeywordBasedExecutor dropTable = this::dropTable;
        KeywordBasedExecutor sqlBackup = x$0 -> this.backupAgent.sqlBackup(x$0);
        KeywordBasedExecutor sqlShow = this::sqlShow;
        KeywordBasedExecutor vacuumTable = this::vacuum;
        KeywordBasedExecutor snapshotDatabase = this::snapshotDatabase;
        KeywordBasedExecutor compileDeallocate = this::compileDeallocate;
        this.keywordBasedExecutors.put("truncate", truncateTables);
        this.keywordBasedExecutors.put("TRUNCATE", truncateTables);
        this.keywordBasedExecutors.put("alter", alterTable);
        this.keywordBasedExecutors.put("ALTER", alterTable);
        this.keywordBasedExecutors.put("reindex", reindexTable);
        this.keywordBasedExecutors.put("REINDEX", reindexTable);
        this.keywordBasedExecutors.put("set", compileSet);
        this.keywordBasedExecutors.put("SET", compileSet);
        this.keywordBasedExecutors.put("begin", compileBegin);
        this.keywordBasedExecutors.put("BEGIN", compileBegin);
        this.keywordBasedExecutors.put("commit", compileCommit);
        this.keywordBasedExecutors.put("COMMIT", compileCommit);
        this.keywordBasedExecutors.put("rollback", compileRollback);
        this.keywordBasedExecutors.put("ROLLBACK", compileRollback);
        this.keywordBasedExecutors.put("discard", compileSet);
        this.keywordBasedExecutors.put("DISCARD", compileSet);
        this.keywordBasedExecutors.put("close", compileSet);
        this.keywordBasedExecutors.put("CLOSE", compileSet);
        this.keywordBasedExecutors.put("unlisten", compileSet);
        this.keywordBasedExecutors.put("UNLISTEN", compileSet);
        this.keywordBasedExecutors.put("reset", compileSet);
        this.keywordBasedExecutors.put("RESET", compileSet);
        this.keywordBasedExecutors.put("drop", dropTable);
        this.keywordBasedExecutors.put("DROP", dropTable);
        this.keywordBasedExecutors.put("backup", sqlBackup);
        this.keywordBasedExecutors.put("BACKUP", sqlBackup);
        this.keywordBasedExecutors.put("show", sqlShow);
        this.keywordBasedExecutors.put("SHOW", sqlShow);
        this.keywordBasedExecutors.put("vacuum", vacuumTable);
        this.keywordBasedExecutors.put("VACUUM", vacuumTable);
        this.keywordBasedExecutors.put("snapshot", snapshotDatabase);
        this.keywordBasedExecutors.put("SNAPSHOT", snapshotDatabase);
        this.keywordBasedExecutors.put("deallocate", compileDeallocate);
        this.keywordBasedExecutors.put("DEALLOCATE", compileDeallocate);
    }

    protected CompiledQuery unknownAlterStatement(SqlExecutionContext executionContext, CharSequence tok) throws SqlException {
        if (tok == null) {
            throw SqlException.position(this.lexer.getPosition()).put("'table' expected");
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("'table' expected");
    }

    protected CompiledQuery unknownDropColumnSuffix(SecurityContext securityContext, CharSequence tok, TableToken tableToken, AlterOperationBuilder dropColumnStatement) throws SqlException {
        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
    }

    protected CompiledQuery unknownDropStatement(SqlExecutionContext executionContext, CharSequence tok) throws SqlException {
        if (tok == null) {
            throw SqlException.position(this.lexer.getPosition()).put("'table' expected");
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("'table' expected");
    }

    protected CompiledQuery unknownDropTableSuffix(SqlExecutionContext executionContext, CharSequence tok, CharSequence tableName, int tableNamePosition, boolean hasIfExists) throws SqlException {
        throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put(']');
    }

    protected RecordCursorFactory unknownShowStatement(SqlExecutionContext executionContext, CharSequence tok) throws SqlException {
        return null;
    }

    static {
        castGroups.extendAndSet(1, 2);
        castGroups.extendAndSet(2, 1);
        castGroups.extendAndSet(3, 1);
        castGroups.extendAndSet(4, 1);
        castGroups.extendAndSet(5, 1);
        castGroups.extendAndSet(6, 1);
        castGroups.extendAndSet(9, 1);
        castGroups.extendAndSet(10, 1);
        castGroups.extendAndSet(7, 1);
        castGroups.extendAndSet(8, 1);
        castGroups.extendAndSet(11, 3);
        castGroups.extendAndSet(12, 3);
        castGroups.extendAndSet(18, 4);
        sqlControlSymbols.add("(");
        sqlControlSymbols.add(";");
        sqlControlSymbols.add(")");
        sqlControlSymbols.add(",");
        sqlControlSymbols.add("/*");
        sqlControlSymbols.add("*/");
        sqlControlSymbols.add("--");
        sqlControlSymbols.add("[");
        sqlControlSymbols.add("]");
    }

    public class QueryBuilder
    implements Mutable {
        private final StringSink sink = new StringSink();

        public QueryBuilder $(CharSequence value) {
            this.sink.put(value);
            return this;
        }

        public QueryBuilder $(int value) {
            this.sink.put(value);
            return this;
        }

        @Override
        public void clear() {
            this.sink.clear();
        }

        public CompiledQuery compile(SqlExecutionContext executionContext) throws SqlException {
            return SqlCompiler.this.compile(this.sink, executionContext);
        }
    }

    private class DatabaseBackupAgent
    implements Closeable {
        private final Path auxPath = new Path();
        private final Path dstPath = new Path();
        private final StringSink sink = new StringSink();
        private final Path srcPath = new Path();
        private final CharSequenceObjHashMap<RecordToRowCopier> tableBackupRowCopiedCache = new CharSequenceObjHashMap();
        private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
        private final ObjHashSet<TableToken> tableTokens = new ObjHashSet();
        private transient String cachedBackupTmpRoot;
        private transient int dstCurrDirLen;
        private transient int dstPathRoot;

        private DatabaseBackupAgent() {
        }

        public void clear() {
            this.auxPath.trimTo(0);
            this.srcPath.trimTo(0);
            this.dstPath.trimTo(0);
            this.cachedBackupTmpRoot = null;
            this.dstPathRoot = 0;
            this.dstCurrDirLen = 0;
            this.tableBackupRowCopiedCache.clear();
            this.tableTokens.clear();
        }

        @Override
        public void close() {
            this.tableBackupRowCopiedCache.clear();
            Misc.free(this.auxPath);
            Misc.free(this.srcPath);
            Misc.free(this.dstPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void backupTable(@NotNull TableToken tableToken) {
            LOG.info().$("starting backup of ").$(tableToken).$();
            if (null == this.cachedBackupTmpRoot) {
                if (null == SqlCompiler.this.configuration.getBackupRoot()) {
                    throw CairoException.nonCritical().put("backup is disabled, server.conf property 'cairo.sql.backup.root' is not set");
                }
                this.auxPath.of(SqlCompiler.this.configuration.getBackupRoot()).concat(SqlCompiler.this.configuration.getBackupTempDirName()).slash$();
                this.cachedBackupTmpRoot = Chars.toString(this.auxPath);
            }
            String tableName = tableToken.getTableName();
            this.auxPath.of(this.cachedBackupTmpRoot).concat(tableToken).slash$();
            int tableRootLen = this.auxPath.length();
            try {
                try (TableReader reader = SqlCompiler.this.engine.getReader(tableToken);){
                    if (SqlCompiler.this.ff.exists(this.auxPath)) {
                        throw CairoException.nonCritical().put("backup dir already exists [path=").put(this.auxPath).put(", table=").put(tableName).put(']');
                    }
                    if (SqlCompiler.this.ff.mkdirs(this.auxPath, SqlCompiler.this.configuration.getBackupMkDirMode()) != 0) {
                        throw CairoException.critical(SqlCompiler.this.ff.errno()).put("could not create [dir=").put(this.auxPath).put(']');
                    }
                    try {
                        TableReaderMetadata metadata = reader.getMetadata();
                        SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(tableRootLen).concat("_meta").$(), 0);
                        metadata.dumpTo(SqlCompiler.this.mem);
                        this.auxPath.trimTo(tableRootLen).$();
                        int symbolMapCount = 0;
                        int sz = metadata.getColumnCount();
                        for (int i = 0; i < sz; ++i) {
                            if (!ColumnType.isSymbol(metadata.getColumnType(i))) continue;
                            SymbolMapReader mapReader = reader.getSymbolMapReader(i);
                            MapWriter.createSymbolMapFiles(SqlCompiler.this.ff, SqlCompiler.this.mem, this.auxPath, metadata.getColumnName(i), -1L, mapReader.getSymbolCapacity(), mapReader.isCached());
                            ++symbolMapCount;
                        }
                        SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(tableRootLen).concat("_txn").$(), 0);
                        TableUtils.createTxn(SqlCompiler.this.mem, symbolMapCount, 0L, 0L, 0L, 0L, metadata.getMetadataVersion(), 0L, 0L);
                        SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(tableRootLen).concat("_cv").$(), 0);
                        TableUtils.createColumnVersionFile(SqlCompiler.this.mem);
                        if (tableToken.isWal()) {
                            SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(tableRootLen).concat("_name").$(), 0);
                            TableUtils.createTableNameFile(SqlCompiler.this.mem, tableToken.getTableName());
                            this.auxPath.trimTo(tableRootLen).concat("txn_seq").slash$();
                            if (SqlCompiler.this.ff.mkdirs(this.auxPath, SqlCompiler.this.configuration.getBackupMkDirMode()) != 0) {
                                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("Cannot create [path=").put(this.auxPath).put(']');
                            }
                            int len = this.auxPath.length();
                            SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.concat("_wal_index.d").$(), 0);
                            SqlCompiler.this.mem.putLong(0L);
                            SqlCompiler.this.mem.close(true, (byte)1);
                            SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(len).concat("_txnlog").$(), 0);
                            SqlCompiler.this.mem.putInt(0);
                            SqlCompiler.this.mem.putLong(0L);
                            SqlCompiler.this.mem.putLong(0L);
                            SqlCompiler.this.mem.close(true, (byte)1);
                            SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(len).concat("_txnlog.meta.i").$(), 0);
                            SqlCompiler.this.mem.putLong(0L);
                            SqlCompiler.this.mem.close(true, (byte)1);
                            SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(len).concat("_txnlog.meta.d").$(), 0);
                            SqlCompiler.this.mem.close(true, (byte)1);
                            SqlCompiler.this.mem.smallFile(SqlCompiler.this.ff, this.auxPath.trimTo(len).concat("_meta").$(), 0);
                            WalWriterMetadata.syncToMetaFile(SqlCompiler.this.mem, metadata.getMetadataVersion(), metadata.getColumnCount(), metadata.getTimestampIndex(), metadata.getTableId(), false, metadata);
                            SqlCompiler.this.mem.close(true, (byte)1);
                        }
                    }
                    finally {
                        SqlCompiler.this.mem.close();
                    }
                    try (TableWriter backupWriter = SqlCompiler.this.engine.getBackupWriter(tableToken, this.cachedBackupTmpRoot);){
                        TableRecordMetadata writerMetadata = backupWriter.getMetadata();
                        this.srcPath.of(tableName).slash().put(reader.getVersion()).$();
                        RecordToRowCopier recordToRowCopier = this.tableBackupRowCopiedCache.get(this.srcPath);
                        if (null == recordToRowCopier) {
                            SqlCompiler.this.entityColumnFilter.of(writerMetadata.getColumnCount());
                            recordToRowCopier = RecordToRowCopierUtils.generateCopier(SqlCompiler.this.asm, reader.getMetadata(), writerMetadata, SqlCompiler.this.entityColumnFilter);
                            this.tableBackupRowCopiedCache.put(this.srcPath.toString(), recordToRowCopier);
                        }
                        TableReaderRecordCursor cursor = reader.getCursor();
                        SqlCompiler.this.copyTableData(cursor, reader.getMetadata(), backupWriter, writerMetadata, recordToRowCopier, SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER);
                        backupWriter.commit();
                    }
                }
                int renameRootLen = this.dstPath.length();
                try {
                    this.dstPath.trimTo(renameRootLen).concat(tableToken).$();
                    TableUtils.renameOrFail(SqlCompiler.this.ff, this.auxPath.trimTo(tableRootLen).$(), this.dstPath);
                    LOG.info().$("backup complete [table=").utf8(tableName).$(", to=").utf8(this.dstPath).I$();
                }
                finally {
                    this.dstPath.trimTo(renameRootLen).$();
                }
            }
            catch (CairoException e) {
                LOG.info().$("could not backup [table=").utf8(tableName).$(", ex=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).$(']').$();
                this.auxPath.of(this.cachedBackupTmpRoot).concat(tableToken).slash$();
                int errno = SqlCompiler.this.ff.rmdir(this.auxPath);
                if (errno != 0) {
                    LOG.error().$("could not delete directory [path=").utf8(this.auxPath).$(", errno=").$(errno).I$();
                }
                throw e;
            }
        }

        private void mkBackupDstDir(CharSequence dir, String errorMessage) {
            this.dstPath.trimTo(this.dstPathRoot).concat(dir).slash$();
            this.dstCurrDirLen = this.dstPath.length();
            if (SqlCompiler.this.ff.mkdirs(this.dstPath, SqlCompiler.this.configuration.getBackupMkDirMode()) != 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put(errorMessage).put(this.dstPath).put(']');
            }
        }

        private void mkBackupDstRoot() {
            DateFormat format = SqlCompiler.this.configuration.getBackupDirTimestampFormat();
            long epochMicros = SqlCompiler.this.configuration.getMicrosecondClock().getTicks();
            this.dstPath.of(SqlCompiler.this.configuration.getBackupRoot()).slash();
            int plen = this.dstPath.length();
            int n = 0;
            do {
                this.dstPath.trimTo(plen);
                format.format(epochMicros, SqlCompiler.this.configuration.getDefaultDateLocale(), null, this.dstPath);
                if (n > 0) {
                    this.dstPath.put('.').put(n);
                }
                this.dstPath.slash$();
                ++n;
            } while (SqlCompiler.this.ff.exists(this.dstPath));
            if (SqlCompiler.this.ff.mkdirs(this.dstPath, SqlCompiler.this.configuration.getBackupMkDirMode()) != 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("could not create backup [dir=").put(this.dstPath).put(']');
            }
            this.dstPathRoot = this.dstPath.length();
        }

        private CompiledQuery sqlBackup(SqlExecutionContext executionContext) throws SqlException {
            if (null == SqlCompiler.this.configuration.getBackupRoot()) {
                throw CairoException.nonCritical().put("backup is disabled, server.conf property 'cairo.sql.backup.root' is not set");
            }
            CharSequence tok = SqlUtil.fetchNext(SqlCompiler.this.lexer);
            if (null != tok) {
                if (SqlKeywords.isTableKeyword(tok)) {
                    return this.sqlTableBackup(executionContext);
                }
                if (SqlKeywords.isDatabaseKeyword(tok)) {
                    return this.sqlDatabaseBackup(executionContext);
                }
            }
            throw SqlException.position(SqlCompiler.this.lexer.lastTokenPosition()).put("expected 'table' or 'database'");
        }

        private CompiledQuery sqlDatabaseBackup(SqlExecutionContext executionContext) {
            this.mkBackupDstRoot();
            this.mkBackupDstDir(SqlCompiler.this.configuration.getDbDirectory(), "could not create backup [db dir=");
            SqlCompiler.this.engine.getTableTokens(this.tableTokenBucket, false);
            executionContext.getSecurityContext().authorizeTableBackup(this.tableTokens);
            int n = this.tableTokenBucket.size();
            for (int i = 0; i < n; ++i) {
                this.backupTable(this.tableTokenBucket.get(i));
            }
            this.srcPath.of(SqlCompiler.this.configuration.getRoot()).$();
            int srcLen = this.srcPath.length();
            int version = TableNameRegistryFileStore.findLastTablesFileVersion(SqlCompiler.this.ff, this.srcPath, this.sink);
            this.srcPath.trimTo(srcLen).concat("tables.d").put('.').put(version).$();
            this.dstPath.trimTo(this.dstCurrDirLen).concat("tables.d").put(".0").$();
            LOG.info().$("backup copying file [from=").utf8(this.srcPath).$(", to=").utf8(this.dstPath).I$();
            if (SqlCompiler.this.ff.copy(this.srcPath, this.dstPath) < 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("cannot backup table registry file [from=").put(this.srcPath).put(", to=").put(this.dstPath).put(']');
            }
            this.srcPath.trimTo(srcLen).concat("_tab_index.d").$();
            this.dstPath.trimTo(this.dstCurrDirLen).concat("_tab_index.d").$();
            LOG.info().$("backup copying file [from=").utf8(this.srcPath).$(", to=").utf8(this.dstPath).I$();
            if (SqlCompiler.this.ff.copy(this.srcPath, this.dstPath) < 0) {
                throw CairoException.critical(SqlCompiler.this.ff.errno()).put("cannot backup table index file [from=").put(this.srcPath).put(", to=").put(this.dstPath).put(']');
            }
            this.mkBackupDstDir("conf", "could not create backup [conf dir=");
            SqlCompiler.this.ff.copyRecursive(this.srcPath.of(SqlCompiler.this.configuration.getConfRoot()).$(), this.auxPath.of(this.dstPath).$(), SqlCompiler.this.configuration.getMkDirMode());
            return SqlCompiler.this.compiledQuery.ofBackupTable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompiledQuery sqlTableBackup(SqlExecutionContext executionContext) throws SqlException {
            this.mkBackupDstRoot();
            this.mkBackupDstDir(SqlCompiler.this.configuration.getDbDirectory(), "could not create backup [db dir=");
            try {
                block6: {
                    CharSequence tok;
                    this.tableTokens.clear();
                    do {
                        if (null == (tok = SqlUtil.fetchNext(SqlCompiler.this.lexer))) {
                            throw SqlException.position(SqlCompiler.this.lexer.getPosition()).put("expected a table name");
                        }
                        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), SqlCompiler.this.lexer.lastTokenPosition());
                        TableToken tableToken = SqlCompiler.this.tableExistsOrFail(SqlCompiler.this.lexer.lastTokenPosition(), tableName, executionContext);
                        this.tableTokens.add(tableToken);
                        tok = SqlUtil.fetchNext(SqlCompiler.this.lexer);
                        if (null == tok || Chars.equals(tok, ';')) break block6;
                    } while (Chars.equals(tok, ','));
                    throw SqlException.position(SqlCompiler.this.lexer.lastTokenPosition()).put("expected ','");
                }
                executionContext.getSecurityContext().authorizeTableBackup(this.tableTokens);
                int n = this.tableTokens.size();
                for (int i = 0; i < n; ++i) {
                    this.backupTable(this.tableTokens.get(i));
                }
                CompiledQuery compiledQuery = SqlCompiler.this.compiledQuery.ofBackupTable();
                return compiledQuery;
            }
            finally {
                this.tableTokens.clear();
            }
        }
    }

    private static class TimestampValueRecord
    implements Record {
        private long value;

        private TimestampValueRecord() {
        }

        @Override
        public long getTimestamp(int col) {
            return this.value;
        }

        public void setTimestamp(long value) {
            this.value = value;
        }
    }

    private static class TableStructureAdapter
    implements TableStructure {
        private RecordMetadata metadata;
        private CreateTableModel model;
        private int timestampIndex;
        private IntIntHashMap typeCast;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            int castIndex = this.typeCast.keyIndex(columnIndex);
            if (castIndex < 0) {
                return this.typeCast.valueAt(castIndex);
            }
            return this.metadata.getColumnType(columnIndex);
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return this.model.getIndexBlockCapacity(columnIndex);
        }

        @Override
        public int getMaxUncommittedRows() {
            return this.model.getMaxUncommittedRows();
        }

        @Override
        public long getO3MaxLag() {
            return this.model.getO3MaxLag();
        }

        @Override
        public int getPartitionBy() {
            return this.model.getPartitionBy();
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCacheFlag();
            }
            return this.model.getSymbolCacheFlag(columnIndex);
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCapacity();
            }
            return this.model.getSymbolCapacity(columnIndex);
        }

        @Override
        public CharSequence getTableName() {
            return this.model.getTableName();
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return this.model.isIndexed(columnIndex);
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return this.model.isSequential(columnIndex);
        }

        @Override
        public boolean isWalEnabled() {
            return this.model.isWalEnabled();
        }

        TableStructureAdapter of(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) {
            this.timestampIndex = model.getTimestampIndex() != -1 ? model.getTimestampIndex() : metadata.getTimestampIndex();
            this.model = model;
            this.metadata = metadata;
            this.typeCast = typeCast;
            return this;
        }
    }

    public static final class PartitionAction {
        public static final int ATTACH = 2;
        public static final int DETACH = 3;
        public static final int DROP = 1;
    }

    @FunctionalInterface
    protected static interface KeywordBasedExecutor {
        public CompiledQuery execute(SqlExecutionContext var1) throws SqlException;
    }

    @FunctionalInterface
    private static interface ExecutableMethod {
        public CompiledQuery execute(ExecutionModel var1, SqlExecutionContext var2) throws SqlException;
    }
}

