/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.OperationDispatcher;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import org.jetbrains.annotations.Nullable;

public class CompiledQueryImpl
implements CompiledQuery {
    private final OperationDispatcher<AlterOperation> alterOperationDispatcher;
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final OperationDispatcher<UpdateOperation> updateOperationDispatcher;
    private long affectedRowsCount;
    private AlterOperation alterOp;
    private InsertOperation insertOp;
    private RecordCursorFactory recordCursorFactory;
    private SqlExecutionContext sqlExecutionContext;
    private String sqlStatement;
    private CharSequence statementName;
    private TableToken tableToken;
    private TextLoader textLoader;
    private short type;
    private UpdateOperation updateOp;

    public CompiledQueryImpl(CairoEngine engine) {
        this.updateOperationDispatcher = new OperationDispatcher<UpdateOperation>(engine, "sync 'UPDATE' execution"){

            @Override
            protected long apply(UpdateOperation operation, TableWriterAPI writerAPI) {
                return writerAPI.apply(operation);
            }
        };
        this.alterOperationDispatcher = new OperationDispatcher<AlterOperation>(engine, "Alter table execute"){

            @Override
            protected long apply(AlterOperation operation, TableWriterAPI writerAPI) {
                return writerAPI.apply(operation, true);
            }
        };
    }

    @Override
    public OperationFuture execute(SCSequence eventSubSeq) throws SqlException {
        return this.execute(this.sqlExecutionContext, eventSubSeq, true);
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext, SCSequence eventSubSeq, boolean closeOnDone) throws SqlException {
        switch (this.type) {
            case 2: {
                return this.insertOp.execute(sqlExecutionContext);
            }
            case 14: {
                this.updateOp.withSqlStatement(this.sqlStatement);
                return this.updateOperationDispatcher.execute(this.updateOp, sqlExecutionContext, eventSubSeq, closeOnDone);
            }
            case 4: {
                this.alterOp.withSqlStatement(this.sqlStatement);
                return this.alterOperationDispatcher.execute(this.alterOp, sqlExecutionContext, eventSubSeq, closeOnDone);
            }
        }
        return this.doneFuture.of(0L);
    }

    @Override
    public long getAffectedRowsCount() {
        return this.affectedRowsCount;
    }

    @Override
    public AlterOperation getAlterOperation() {
        return this.alterOp;
    }

    @Override
    public InsertOperation getInsertOperation() {
        return this.insertOp;
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.recordCursorFactory;
    }

    @Override
    public String getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    public CharSequence getStatementName() {
        return this.statementName;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public TextLoader getTextLoader() {
        return this.textLoader;
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public UpdateOperation getUpdateOperation() {
        return this.updateOp;
    }

    public CompiledQuery of(short type) {
        return this.of(type, null, null);
    }

    public CompiledQuery of(RecordCursorFactory recordCursorFactory) {
        return this.of((short)1, recordCursorFactory, null);
    }

    public CompiledQuery ofAlter(AlterOperation alterOp) {
        this.of((short)4);
        this.alterOp = alterOp;
        return this;
    }

    public CompiledQuery ofBackupTable() {
        return this.of((short)13);
    }

    public CompiledQuery ofBegin() {
        return this.of((short)18);
    }

    public CompiledQuery ofCommit() {
        return this.of((short)19);
    }

    public CompiledQuery ofCopyRemote(TextLoader textLoader) {
        this.textLoader = textLoader;
        return this.of((short)11);
    }

    public CompiledQuery ofCreateTable(TableToken tableToken) {
        return this.of((short)9, null, tableToken);
    }

    public CompiledQuery ofCreateTableAsSelect(TableToken tableToken, long affectedRowsCount) {
        this.of((short)21, null, tableToken);
        this.affectedRowsCount = affectedRowsCount;
        return this;
    }

    public CompiledQuery ofDeallocate(CharSequence statementName) {
        this.statementName = Chars.toString(statementName);
        return this.of((short)24);
    }

    public CompiledQuery ofDrop() {
        return this.of((short)7);
    }

    public CompiledQuery ofExplain(RecordCursorFactory recordCursorFactory) {
        return this.of((short)25, recordCursorFactory, null);
    }

    public CompiledQuery ofInsert(InsertOperation insertOperation) {
        this.insertOp = insertOperation;
        return this.of((short)2);
    }

    public CompiledQuery ofInsertAsSelect(long affectedRowsCount) {
        this.of((short)10);
        this.affectedRowsCount = affectedRowsCount;
        return this;
    }

    public CompiledQuery ofPseudoSelect(@Nullable RecordCursorFactory factory) {
        this.type = (short)8;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        return this;
    }

    public CompiledQuery ofRenameTable() {
        return this.of((short)12);
    }

    public CompiledQuery ofRepair() {
        return this.of((short)5);
    }

    public CompiledQuery ofRollback() {
        return this.of((short)20);
    }

    public CompiledQuery ofSet() {
        return this.of((short)6);
    }

    public CompiledQuery ofSnapshotComplete() {
        return this.of((short)23);
    }

    public CompiledQuery ofSnapshotPrepare() {
        return this.of((short)22);
    }

    public CompiledQuery ofTableResume() {
        this.type = (short)26;
        return this;
    }

    public CompiledQuery ofTableSetType() {
        this.type = (short)27;
        return this;
    }

    public CompiledQuery ofTruncate() {
        return this.of((short)3);
    }

    public CompiledQuery ofUpdate(UpdateOperation updateOperation) {
        this.updateOp = updateOperation;
        this.type = (short)14;
        return this;
    }

    public CompiledQuery ofVacuum() {
        return this.of((short)17);
    }

    @Override
    public CompiledQueryImpl withContext(SqlExecutionContext sqlExecutionContext) {
        this.sqlExecutionContext = sqlExecutionContext;
        return this;
    }

    @Override
    public void withSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    private CompiledQuery of(short type, RecordCursorFactory factory, TableToken tableToken) {
        this.type = type;
        this.recordCursorFactory = factory;
        this.tableToken = tableToken;
        this.affectedRowsCount = -1L;
        return this;
    }
}

