/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.Atomicity;
import io.questdb.cutlass.text.CopyJob;
import io.questdb.cutlass.text.CopyTask;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextDelimiterScanner;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextImportException;
import io.questdb.cutlass.text.TextLexerWrapper;
import io.questdb.cutlass.text.TextMetadataDetector;
import io.questdb.cutlass.text.types.BadDateAdapter;
import io.questdb.cutlass.text.types.BadTimestampAdapter;
import io.questdb.cutlass.text.types.OtherToTimestampAdapter;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongHashSet;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ParallelCsvFileImporter
implements Closeable,
Mutable {
    private static final int DEFAULT_MIN_CHUNK_SIZE = 314572800;
    private static final String LOCK_REASON = "parallel import";
    private static final Log LOG = LogFactory.getLog(ParallelCsvFileImporter.class);
    private static final int NO_INDEX = -1;
    private final CairoEngine cairoEngine;
    private final LongList chunkStats;
    private final Sequence collectSeq;
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final LongList indexChunkStats;
    private final Path inputFilePath;
    private final CharSequence inputRoot;
    private final CharSequence inputWorkRoot;
    private final CopyJob localImportJob;
    private final ObjectPool<OtherToTimestampAdapter> otherToTimestampAdapterPool;
    private final LongList partitionKeysAndSizes;
    private final StringSink partitionNameSink;
    private final ObjList<PartitionInfo> partitions;
    private final Sequence pubSeq;
    private final RingQueue<CopyTask> queue;
    private final IntList symbolCapacities;
    private final TableStructureAdapter targetTableStructure;
    private final IntList taskDistribution;
    private final TextDelimiterScanner textDelimiterScanner;
    private final TextMetadataDetector textMetadataDetector;
    private final Path tmpPath;
    private final TypeManager typeManager;
    private final DirectCharSink utf8Sink;
    private final int workerCount;
    private int atomicity;
    private ExecutionCircuitBreaker circuitBreaker;
    private byte columnDelimiter;
    private boolean createdWorkDir;
    private CharSequence errorMessage;
    private long errors;
    private boolean forceHeader;
    private long importId;
    private CharSequence importRoot;
    private CharSequence inputFileName;
    private long linesIndexed;
    private RecordMetadata metadata;
    private int minChunkSize = 314572800;
    private int partitionBy;
    private byte phase = 0;
    private long phaseErrors;
    private long rowsHandled;
    private long rowsImported;
    private long startMs;
    private byte status = 0;
    private final Consumer<CopyTask> checkStatusRef = this::updateStatus;
    private final Consumer<CopyTask> collectChunkStatsRef = this::collectChunkStats;
    private final Consumer<CopyTask> collectStubRef = this::collectStub;
    private final Consumer<CopyTask> collectDataImportStatsRef = this::collectDataImportStats;
    private final Consumer<CopyTask> collectIndexStatsRef = this::collectIndexStats;
    private PhaseStatusReporter statusReporter;
    private CharSequence tableName;
    private TableToken tableToken;
    private boolean targetTableCreated;
    private int targetTableStatus;
    private int taskCount;
    private TimestampAdapter timestampAdapter;
    private CharSequence timestampColumn;
    private int timestampIndex;
    private TableWriter writer;

    public ParallelCsvFileImporter(CairoEngine cairoEngine, int workerCount) {
        if (workerCount < 1) {
            throw TextImportException.instance((byte)0, "Invalid worker count set [value=").put(workerCount).put(']');
        }
        MessageBus bus = cairoEngine.getMessageBus();
        RingQueue<CopyTask> queue = bus.getTextImportQueue();
        if (queue.getCycle() < 1) {
            throw TextImportException.instance((byte)0, "Parallel import queue size cannot be zero!");
        }
        this.cairoEngine = cairoEngine;
        this.workerCount = workerCount;
        this.queue = queue;
        this.pubSeq = bus.getTextImportPubSeq();
        this.collectSeq = bus.getTextImportColSeq();
        this.localImportJob = new CopyJob(bus);
        this.configuration = cairoEngine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
        this.inputRoot = this.configuration.getSqlCopyInputRoot();
        this.inputWorkRoot = this.configuration.getSqlCopyInputWorkRoot();
        TextConfiguration textConfiguration = this.configuration.getTextConfiguration();
        this.utf8Sink = new DirectCharSink(textConfiguration.getUtf8SinkSize());
        this.typeManager = new TypeManager(textConfiguration, this.utf8Sink);
        this.textDelimiterScanner = new TextDelimiterScanner(textConfiguration);
        this.textMetadataDetector = new TextMetadataDetector(this.typeManager, textConfiguration);
        this.targetTableStructure = new TableStructureAdapter(this.configuration);
        this.targetTableStatus = -1;
        this.targetTableCreated = false;
        this.atomicity = 2;
        this.createdWorkDir = false;
        this.otherToTimestampAdapterPool = new ObjectPool<OtherToTimestampAdapter>(OtherToTimestampAdapter::new, 4);
        this.inputFilePath = new Path();
        this.tmpPath = new Path();
        this.chunkStats = new LongList();
        this.indexChunkStats = new LongList();
        this.partitionKeysAndSizes = new LongList();
        this.partitionNameSink = new StringSink();
        this.partitions = new ObjList();
        this.taskDistribution = new IntList();
        this.symbolCapacities = new IntList();
    }

    public static int assignPartitions(ObjList<PartitionInfo> partitions, int workerCount) {
        partitions.sort((p1, p2) -> Long.compare(p2.bytes, p1.bytes));
        long[] workerSums = new long[workerCount];
        int n = partitions.size();
        for (int i = 0; i < n; ++i) {
            int minIdx = -1;
            long minSum = Long.MAX_VALUE;
            for (int j = 0; j < workerCount; ++j) {
                if (workerSums[j] == 0L) {
                    minIdx = j;
                    break;
                }
                if (workerSums[j] >= minSum) continue;
                minSum = workerSums[j];
                minIdx = j;
            }
            int n2 = minIdx;
            workerSums[n2] = workerSums[n2] + partitions.getQuick((int)i).bytes;
            partitions.getQuick((int)i).taskId = minIdx;
        }
        partitions.sort((p1, p2) -> {
            long workerIdDiff = p1.taskId - p2.taskId;
            if (workerIdDiff != 0L) {
                return (int)workerIdDiff;
            }
            return Long.compare(p1.key, p2.key);
        });
        int taskIds = 0;
        int n3 = workerSums.length;
        for (int i = 0; i < n3; ++i) {
            if (workerSums[i] == 0L) continue;
            ++taskIds;
        }
        return taskIds;
    }

    public static void createTable(FilesFacade ff, int mkDirMode, CharSequence root, CharSequence tableDir, CharSequence tableName, TableStructure structure, int tableId) {
        try (Path path = new Path();){
            switch (TableUtils.exists(ff, path, root, tableDir)) {
                case 0: {
                    int errno = ff.rmdir(path);
                    if (errno != 0) {
                        LOG.error().$("could not overwrite table [tableName='").utf8(tableName).$("',path='").utf8(path).$(", errno=").$(errno).I$();
                        throw CairoException.critical(errno).put("could not overwrite [tableName=").put(tableName).put("]");
                    }
                }
                case 1: {
                    try (MemoryMARW memory = Vm.getMARWInstance();){
                        TableUtils.createTable(ff, root, mkDirMode, memory, path, tableDir, structure, 426, tableId);
                        break;
                    }
                }
                default: {
                    throw TextException.$("name is reserved [tableName=").put(tableName).put(']');
                }
            }
        }
    }

    @Override
    public void clear() {
        this.writer = Misc.free(this.writer);
        this.metadata = null;
        this.importId = -1L;
        this.chunkStats.clear();
        this.indexChunkStats.clear();
        this.partitionKeysAndSizes.clear();
        this.partitionNameSink.clear();
        this.taskDistribution.clear();
        this.utf8Sink.clear();
        this.typeManager.clear();
        this.symbolCapacities.clear();
        this.textMetadataDetector.clear();
        this.otherToTimestampAdapterPool.clear();
        this.partitions.clear();
        this.linesIndexed = 0L;
        this.rowsHandled = 0L;
        this.rowsImported = 0L;
        this.errors = 0L;
        this.phaseErrors = 0L;
        this.inputFileName = null;
        this.tableName = null;
        this.tableToken = null;
        this.timestampColumn = null;
        this.timestampIndex = -1;
        this.partitionBy = -1;
        this.columnDelimiter = (byte)-1;
        this.timestampAdapter = null;
        this.forceHeader = false;
        this.status = 0;
        this.phase = 0;
        this.errorMessage = null;
        this.targetTableStatus = -1;
        this.targetTableCreated = false;
        this.atomicity = 2;
        this.taskCount = -1;
        this.createdWorkDir = false;
    }

    @Override
    public void close() {
        this.clear();
        this.inputFilePath.close();
        this.tmpPath.close();
        this.utf8Sink.close();
        this.textMetadataDetector.close();
        this.textDelimiterScanner.close();
        this.localImportJob.close();
    }

    public void of(CharSequence tableName, CharSequence inputFileName, long importId, int partitionBy, byte columnDelimiter, CharSequence timestampColumn, CharSequence timestampFormat, boolean forceHeader, ExecutionCircuitBreaker circuitBreaker, int atomicity) {
        this.clear();
        this.circuitBreaker = circuitBreaker;
        this.tableName = tableName;
        this.tableToken = this.cairoEngine.lockTableName(tableName, false);
        if (this.tableToken == null) {
            this.tableToken = this.cairoEngine.verifyTableName(tableName);
        }
        this.importRoot = this.tmpPath.of(this.inputWorkRoot).concat(this.tableToken).toString();
        this.inputFileName = inputFileName;
        this.timestampColumn = timestampColumn;
        this.partitionBy = partitionBy;
        this.columnDelimiter = columnDelimiter;
        if (timestampFormat != null) {
            DateFormat dateFormat = this.typeManager.getInputFormatConfiguration().getTimestampFormatFactory().get(timestampFormat);
            this.timestampAdapter = (TimestampAdapter)this.typeManager.nextTimestampAdapter(false, dateFormat, this.configuration.getTextConfiguration().getDefaultDateLocale());
        }
        this.forceHeader = forceHeader;
        this.timestampIndex = -1;
        this.status = 0;
        this.phase = 0;
        this.targetTableStatus = -1;
        this.targetTableCreated = false;
        this.atomicity = Atomicity.isValid(atomicity) ? atomicity : 1;
        this.importId = importId;
        this.inputFilePath.of(this.inputRoot).concat(inputFileName).$();
    }

    public void of(CharSequence tableName, CharSequence inputFileName, long importId, int partitionBy, byte columnDelimiter, CharSequence timestampColumn, CharSequence tsFormat, boolean forceHeader, ExecutionCircuitBreaker circuitBreaker) {
        this.of(tableName, inputFileName, importId, partitionBy, columnDelimiter, timestampColumn, tsFormat, forceHeader, circuitBreaker, 2);
    }

    public void of(CharSequence tableName, CharSequence inputFileName, long importId, int partitionBy, byte columnDelimiter, CharSequence timestampColumn, CharSequence timestampFormat, boolean forceHeader) {
        this.of(tableName, inputFileName, importId, partitionBy, columnDelimiter, timestampColumn, timestampFormat, forceHeader, null, 2);
    }

    public void parseStructure(int fd) throws TextImportException {
        block14: {
            this.phasePrologue((byte)9);
            CairoConfiguration configuration = this.cairoEngine.getConfiguration();
            int textAnalysisMaxLines = configuration.getTextConfiguration().getTextAnalysisMaxLines();
            int len = configuration.getSqlCopyBufferSize();
            long buf = Unsafe.malloc(len, 34);
            try (TextLexerWrapper tlw = new TextLexerWrapper(configuration.getTextConfiguration());){
                long n = this.ff.read(fd, buf, len, 0L);
                if (n > 0L) {
                    if (this.columnDelimiter < 0) {
                        this.columnDelimiter = this.textDelimiterScanner.scan(buf, buf + n);
                    }
                    AbstractTextLexer lexer = tlw.getLexer(this.columnDelimiter);
                    lexer.setSkipLinesWithExtraValues(false);
                    ObjList<CharSequence> names = new ObjList<CharSequence>();
                    ObjList<TypeAdapter> types = new ObjList<TypeAdapter>();
                    if (this.timestampColumn != null && this.timestampAdapter != null) {
                        names.add(this.timestampColumn);
                        types.add(this.timestampAdapter);
                    }
                    this.textMetadataDetector.of(this.tableName, names, types, this.forceHeader);
                    lexer.parse(buf, buf + n, textAnalysisMaxLines, this.textMetadataDetector);
                    this.textMetadataDetector.evaluateResults(lexer.getLineCount(), lexer.getErrorCount());
                    this.forceHeader = this.textMetadataDetector.isHeader();
                    this.prepareTable(this.textMetadataDetector.getColumnNames(), this.textMetadataDetector.getColumnTypes(), this.inputFilePath, this.typeManager);
                    this.phaseEpilogue((byte)9);
                    break block14;
                }
                throw TextException.$("could not read from file '").put(this.inputFilePath).put("' to analyze structure");
            }
            catch (CairoException e) {
                throw TextImportException.instance((byte)9, e.getFlyweightMessage(), e.getErrno());
            }
            catch (TextException e) {
                throw TextImportException.instance((byte)9, e.getFlyweightMessage());
            }
            finally {
                Unsafe.free(buf, len, 34);
            }
        }
    }

    public LongList phaseBoundaryCheck(long fileLength) throws TextImportException {
        this.phasePrologue((byte)1);
        assert (this.workerCount > 0 && this.minChunkSize > 0);
        if (this.workerCount == 1) {
            this.indexChunkStats.setPos(0);
            this.indexChunkStats.add(0L);
            this.indexChunkStats.add(0L);
            this.indexChunkStats.add(fileLength);
            this.indexChunkStats.add(0L);
            this.phaseEpilogue((byte)1);
            return this.indexChunkStats;
        }
        long chunkSize = Math.max((long)this.minChunkSize, (fileLength + (long)this.workerCount - 1L) / (long)this.workerCount);
        int chunks = (int)Math.max((fileLength + chunkSize - 1L) / chunkSize, 1L);
        int queuedCount = 0;
        int collectedCount = 0;
        this.chunkStats.setPos(chunks * 5);
        this.chunkStats.zero(0);
        block0: for (int i = 0; i < chunks; ++i) {
            long chunkLo = (long)i * chunkSize;
            long chunkHi = Long.min(chunkLo + chunkSize, fileLength);
            while (true) {
                long seq;
                if ((seq = this.pubSeq.next()) > -1L) {
                    CopyTask task = this.queue.get(seq);
                    task.setChunkIndex(i);
                    task.setCircuitBreaker(this.circuitBreaker);
                    task.ofPhaseBoundaryCheck(this.ff, this.inputFilePath, chunkLo, chunkHi);
                    this.pubSeq.done(seq);
                    ++queuedCount;
                    continue block0;
                }
                collectedCount += this.collect(queuedCount - collectedCount, this.collectChunkStatsRef);
            }
        }
        collectedCount += this.collect(queuedCount - collectedCount, this.collectChunkStatsRef);
        assert (collectedCount == queuedCount);
        this.processChunkStats(fileLength, chunks);
        this.phaseEpilogue((byte)1);
        return this.indexChunkStats;
    }

    public void phaseIndexing() throws TextException {
        this.phasePrologue((byte)2);
        int queuedCount = 0;
        int collectedCount = 0;
        this.createWorkDir();
        boolean forceHeader = this.forceHeader;
        int n = this.indexChunkStats.size() - 2;
        block0: for (int i = 0; i < n; i += 2) {
            int colIdx = i / 2;
            long chunkLo = this.indexChunkStats.get(i);
            long lineNumber = this.indexChunkStats.get(i + 1);
            long chunkHi = this.indexChunkStats.get(i + 2);
            while (true) {
                long seq;
                if ((seq = this.pubSeq.next()) > -1L) {
                    CopyTask task = this.queue.get(seq);
                    task.setChunkIndex(colIdx);
                    task.setCircuitBreaker(this.circuitBreaker);
                    task.ofPhaseIndexing(chunkLo, chunkHi, lineNumber, colIdx, this.inputFileName, this.importRoot, this.partitionBy, this.columnDelimiter, this.timestampIndex, this.timestampAdapter, forceHeader, this.atomicity);
                    if (forceHeader) {
                        forceHeader = false;
                    }
                    this.pubSeq.done(seq);
                    ++queuedCount;
                    continue block0;
                }
                collectedCount += this.collect(queuedCount - collectedCount, this.collectIndexStatsRef);
            }
        }
        collectedCount += this.collect(queuedCount - collectedCount, this.collectIndexStatsRef);
        assert (collectedCount == queuedCount);
        this.processIndexStats();
        this.phaseEpilogue((byte)2);
    }

    public void process() throws TextImportException {
        long startMs = this.getCurrentTimeMs();
        int fd = -1;
        try {
            try {
                this.updateImportStatus((byte)0, Long.MIN_VALUE, Long.MIN_VALUE, 0L);
                try {
                    fd = TableUtils.openRO(this.ff, this.inputFilePath, LOG);
                }
                catch (CairoException e) {
                    throw TextImportException.instance((byte)0, e.getFlyweightMessage(), e.getErrno());
                }
                long length = this.ff.length(fd);
                if (length < 1L) {
                    throw TextImportException.instance((byte)0, "ignored empty input file [file='").put(this.inputFilePath).put(']');
                }
                try {
                    this.parseStructure(fd);
                    this.phaseBoundaryCheck(length);
                    this.phaseIndexing();
                    this.phasePartitionImport();
                    this.phaseSymbolTableMerge();
                    this.phaseUpdateSymbolKeys();
                    this.phaseBuildSymbolIndex();
                    this.movePartitions();
                    this.attachPartitions();
                    this.updateImportStatus((byte)1, this.rowsHandled, this.rowsImported, this.errors);
                }
                catch (Throwable t) {
                    this.cleanUp();
                    throw t;
                }
                finally {
                    this.closeWriter();
                    if (this.createdWorkDir) {
                        this.removeWorkDir();
                    }
                }
            }
            catch (CairoException e) {
                throw TextImportException.instance((byte)10, e.getFlyweightMessage(), e.getErrno());
            }
            catch (TextException e) {
                throw TextImportException.instance((byte)10, e.getFlyweightMessage());
            }
            finally {
                this.ff.close(fd);
            }
        }
        catch (TextImportException e) {
            LOG.error().$("could not import [phase=").$(CopyTask.getPhaseName(e.getPhase())).$(", ex=").$(e.getFlyweightMessage()).I$();
            throw e;
        }
        long endMs = this.getCurrentTimeMs();
        LOG.info().$("import complete [importId=").$hexPadded(this.importId).$(", file=`").$(this.inputFilePath).$('`').$("', time=").$((endMs - startMs) / 1000L).$("s").I$();
    }

    public void setMinChunkSize(int minChunkSize) {
        this.minChunkSize = minChunkSize;
    }

    public void setStatusReporter(PhaseStatusReporter reporter) {
        this.statusReporter = reporter;
    }

    public void updateImportStatus(byte status, long rowsHandled, long rowsImported, long errors) {
        if (this.statusReporter != null) {
            this.statusReporter.report((byte)-1, status, null, rowsHandled, rowsImported, errors);
        }
    }

    public void updatePhaseStatus(byte phase, byte status, @Nullable CharSequence msg) {
        if (this.statusReporter != null) {
            this.statusReporter.report(phase, status, msg, Long.MIN_VALUE, Long.MIN_VALUE, this.phaseErrors);
        }
    }

    private void attachPartitions() throws TextImportException {
        this.phasePrologue((byte)8);
        for (int i = this.partitions.size() - 1; i > -1; --i) {
            PartitionInfo partition = this.partitions.getQuick(i);
            if (partition.importedRows == 0L) continue;
            CharSequence partitionDirName = partition.name;
            try {
                long timestamp = PartitionBy.parsePartitionDirName(partitionDirName, this.partitionBy);
                this.writer.attachPartition(timestamp, partition.importedRows);
                continue;
            }
            catch (CairoException e) {
                throw TextImportException.instance((byte)8, "could not attach [partition='").put(partitionDirName).put("', msg=").put('[').put(e.getErrno()).put("] ").put(e.getFlyweightMessage()).put(']');
            }
        }
        this.phaseEpilogue((byte)8);
    }

    private void cleanUp() {
        if (this.targetTableStatus == 0 && this.writer != null) {
            this.writer.truncate();
        }
        this.closeWriter();
        if (this.targetTableStatus == 1 && this.targetTableCreated) {
            this.cairoEngine.drop(this.tmpPath, this.tableToken);
        }
        if (this.tableToken != null) {
            this.cairoEngine.unlockTableName(this.tableToken);
        }
    }

    private void closeWriter() {
        this.writer = Misc.free(this.writer);
        this.metadata = null;
    }

    private int collect(int queuedCount, Consumer<CopyTask> consumer) {
        int collectedCount = 0;
        while (collectedCount < queuedCount) {
            long seq = this.collectSeq.next();
            if (seq > -1L) {
                CopyTask task = this.queue.get(seq);
                consumer.accept(task);
                task.clear();
                this.collectSeq.done(seq);
                ++collectedCount;
                continue;
            }
            this.stealWork();
        }
        return collectedCount;
    }

    private void collectChunkStats(CopyTask task) {
        this.updateStatus(task);
        CopyTask.PhaseBoundaryCheck phaseBoundaryCheck = task.getCountQuotesPhase();
        int chunkOffset = 5 * task.getChunkIndex();
        this.chunkStats.set(chunkOffset, phaseBoundaryCheck.getQuoteCount());
        this.chunkStats.set(chunkOffset + 1, phaseBoundaryCheck.getNewLineCountEven());
        this.chunkStats.set(chunkOffset + 2, phaseBoundaryCheck.getNewLineCountOdd());
        this.chunkStats.set(chunkOffset + 3, phaseBoundaryCheck.getNewLineOffsetEven());
        this.chunkStats.set(chunkOffset + 4, phaseBoundaryCheck.getNewLineOffsetOdd());
    }

    private void collectDataImportStats(CopyTask task) {
        this.updateStatus(task);
        CopyTask.PhasePartitionImport phase = task.getImportPartitionDataPhase();
        LongList rows = phase.getImportedRows();
        int n = rows.size();
        for (int i = 0; i < n; i += 2) {
            this.partitions.get((int)((int)rows.get((int)i))).importedRows = rows.get(i + 1);
        }
        this.rowsHandled += phase.getRowsHandled();
        this.rowsImported += phase.getRowsImported();
        this.phaseErrors += phase.getErrors();
        this.errors += phase.getErrors();
    }

    private void collectIndexStats(CopyTask task) {
        this.updateStatus(task);
        CopyTask.PhaseIndexing phaseIndexing = task.getBuildPartitionIndexPhase();
        LongList keys = phaseIndexing.getPartitionKeysAndSizes();
        this.partitionKeysAndSizes.add(keys);
        this.linesIndexed += phaseIndexing.getLineCount();
        this.phaseErrors += phaseIndexing.getErrorCount();
        this.errors += phaseIndexing.getErrorCount();
    }

    private void collectStub(CopyTask task) {
        this.updateStatus(task);
    }

    private void createWorkDir() {
        int result;
        Path workDirPath = this.tmpPath.of(this.inputWorkRoot).slash$();
        if (!this.ff.exists(workDirPath) && (result = this.ff.mkdir(workDirPath, this.configuration.getMkDirMode())) != 0) {
            throw CairoException.critical(this.ff.errno()).put("could not create import work root directory [path='").put(workDirPath).put("']");
        }
        this.removeWorkDir();
        workDirPath = this.tmpPath.of(this.importRoot).slash$();
        result = this.ff.mkdir(workDirPath, this.configuration.getMkDirMode());
        if (result != 0) {
            throw CairoException.critical(this.ff.errno()).put("could not create temporary import work directory [path='").put(workDirPath).put("']");
        }
        this.createdWorkDir = true;
        LOG.info().$("temporary import directory [path='").$(workDirPath).I$();
    }

    private long getCurrentTimeMs() {
        return this.configuration.getMillisecondClock().getTicks();
    }

    private int getTaskCount() {
        return this.taskDistribution.size() / 3;
    }

    private void initWriterAndOverrideImportMetadata(ObjList<CharSequence> names, ObjList<TypeAdapter> types, TypeManager typeManager) throws TextException {
        int columnIndex;
        int i;
        TableWriter writer = this.cairoEngine.getWriter(this.tableToken, LOCK_REASON);
        GenericRecordMetadata metadata = GenericRecordMetadata.copyDense(writer.getMetadata());
        if (metadata.getColumnCount() < types.size()) {
            writer.close();
            throw TextException.$("column count mismatch [textColumnCount=").put(types.size()).put(", tableColumnCount=").put(metadata.getColumnCount()).put(", table=").put(this.tableName).put(']');
        }
        IntList remapIndex = new IntList();
        remapIndex.ensureCapacity(types.size());
        int n = types.size();
        block5: for (i = 0; i < n; ++i) {
            columnIndex = metadata.getColumnIndexQuiet(names.getQuick(i));
            int idx = columnIndex > -1 ? columnIndex : i;
            remapIndex.set(i, idx);
            int columnType = metadata.getColumnType(idx);
            TypeAdapter detectedAdapter = types.getQuick(i);
            int detectedType = detectedAdapter.getType();
            if (detectedType == columnType) continue;
            switch (ColumnType.tagOf(columnType)) {
                case 7: {
                    this.logTypeError(i, detectedType);
                    types.setQuick(i, BadDateAdapter.INSTANCE);
                    continue block5;
                }
                case 8: {
                    if (detectedAdapter instanceof TimestampCompatibleAdapter) {
                        types.setQuick(i, this.otherToTimestampAdapterPool.next().of((TimestampCompatibleAdapter)detectedAdapter));
                        continue block5;
                    }
                    this.logTypeError(i, detectedType);
                    types.setQuick(i, BadTimestampAdapter.INSTANCE);
                    continue block5;
                }
                case 18: {
                    writer.close();
                    throw TextException.$("cannot import text into BINARY column [index=").put(i).put(']');
                }
                default: {
                    types.setQuick(i, typeManager.getTypeAdapter(columnType));
                }
            }
        }
        n = remapIndex.size();
        for (i = 0; i < n; ++i) {
            names.set(i, metadata.getColumnName(remapIndex.get(i)));
        }
        if (names.size() < metadata.getColumnCount()) {
            n = metadata.getColumnCount();
            for (i = 0; i < n; ++i) {
                boolean unused = true;
                int rn = remapIndex.size();
                for (int r = 0; r < rn; ++r) {
                    if (remapIndex.get(r) != i) continue;
                    unused = false;
                    break;
                }
                if (!unused) continue;
                names.add(metadata.getColumnName(i));
                types.add(typeManager.getTypeAdapter(metadata.getColumnType(i)));
                remapIndex.add(i);
            }
        }
        this.symbolCapacities.setAll(remapIndex.size(), -1);
        n = remapIndex.size();
        for (i = 0; i < n; ++i) {
            columnIndex = remapIndex.getQuick(i);
            if (!ColumnType.isSymbol(metadata.getColumnType(columnIndex))) continue;
            int columnWriterIndex = metadata.getWriterIndex(columnIndex);
            MapWriter symbolWriter = writer.getSymbolMapWriter(columnWriterIndex);
            this.symbolCapacities.set(i, symbolWriter.getSymbolCapacity());
        }
        this.writer = writer;
        this.metadata = metadata;
    }

    private boolean isOneOfMainDirectories(CharSequence p) {
        String path = this.normalize(p);
        if (path == null) {
            return false;
        }
        return path.equals(this.normalize(this.configuration.getConfRoot())) || path.equals(this.normalize(this.configuration.getRoot())) || path.equals(this.normalize(this.configuration.getDbDirectory())) || path.equals(this.normalize(this.configuration.getSnapshotRoot())) || path.equals(this.normalize(this.configuration.getBackupRoot()));
    }

    private void logTypeError(int i, int type) {
        LOG.info().$("mis-detected [table=").$(this.tableName).$(", column=").$(i).$(", type=").$(ColumnType.nameOf(type)).$(", workerCount=").$(this.workerCount).I$();
    }

    private void movePartitions() {
        this.phasePrologue((byte)7);
        int taskCount = this.getTaskCount();
        try {
            for (int i = 0; i < taskCount; ++i) {
                int index = this.taskDistribution.getQuick(i * 3);
                int lo = this.taskDistribution.getQuick(i * 3 + 1);
                int hi = this.taskDistribution.getQuick(i * 3 + 2);
                Path srcPath = this.localImportJob.getTmpPath1().of(this.importRoot).concat(this.tableName).put('_').put(index);
                Path dstPath = this.localImportJob.getTmpPath2().of(this.configuration.getRoot()).concat(this.tableToken);
                int srcPlen = srcPath.length();
                int dstPlen = dstPath.length();
                if (!this.ff.exists(dstPath.slash$()) && this.ff.mkdirs(dstPath, this.configuration.getMkDirMode()) != 0) {
                    throw TextException.$("could not create partition directory [path='").put(dstPath).put("', errno=").put(this.ff.errno()).put(']');
                }
                for (int j = lo; j < hi; ++j) {
                    PartitionInfo partition = this.partitions.get(j);
                    if (partition.importedRows == 0L) continue;
                    CharSequence partitionName = partition.name;
                    srcPath.trimTo(srcPlen).concat(partitionName);
                    dstPath.trimTo(dstPlen).concat(partitionName).put(this.configuration.getAttachPartitionSuffix());
                    int res = this.ff.rename(srcPath.slash$(), dstPath.slash$());
                    if (res == 1) {
                        LOG.info().$(srcPath).$(" and ").$(dstPath).$(" are not on the same mounted filesystem. Partitions will be copied.").$();
                        if (this.ff.mkdirs(dstPath, this.configuration.getMkDirMode()) != 0) {
                            throw TextException.$("could not create partition directory [path='").put(dstPath).put("', errno=").put(this.ff.errno()).put(']');
                        }
                        this.ff.iterateDir(srcPath, (name, type) -> {
                            if (type == 8) {
                                srcPath.trimTo(srcPlen).concat(partitionName).concat(name).$();
                                dstPath.trimTo(dstPlen).concat(partitionName).put(this.configuration.getAttachPartitionSuffix()).concat(name).$();
                                if (this.ff.copy(srcPath, dstPath) < 0) {
                                    throw TextException.$("could not copy partition file [to='").put(dstPath).put("', errno=").put(this.ff.errno()).put(']');
                                }
                            }
                        });
                        srcPath.parent();
                        continue;
                    }
                    if (res == 0) continue;
                    throw CairoException.critical(this.ff.errno()).put("could not copy partition file [to=").put(dstPath).put(']');
                }
            }
        }
        catch (CairoException e) {
            throw TextImportException.instance((byte)7, e.getFlyweightMessage(), e.getErrno());
        }
        catch (TextException e) {
            throw TextImportException.instance((byte)7, e.getFlyweightMessage());
        }
        this.phaseEpilogue((byte)7);
    }

    private String normalize(CharSequence c) {
        try {
            if (c == null) {
                return null;
            }
            return new File(c.toString()).getCanonicalPath().replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            LOG.error().$("could not normalize [path='").$(c).$("', message=").$(e.getMessage()).I$();
            return null;
        }
    }

    private void phaseBuildSymbolIndex() throws TextImportException {
        this.phasePrologue((byte)6);
        int columnCount = this.metadata.getColumnCount();
        int tmpTableCount = this.getTaskCount();
        boolean isAnyIndexed = false;
        for (int i = 0; i < columnCount; ++i) {
            isAnyIndexed |= this.metadata.isColumnIndexed(i);
        }
        if (isAnyIndexed) {
            int queuedCount = 0;
            int collectedCount = 0;
            block1: for (int t = 0; t < tmpTableCount; ++t) {
                while (true) {
                    long seq;
                    if ((seq = this.pubSeq.next()) > -1L) {
                        CopyTask task = this.queue.get(seq);
                        task.setChunkIndex(t);
                        task.setCircuitBreaker(this.circuitBreaker);
                        task.ofPhaseBuildSymbolIndex(this.cairoEngine, this.targetTableStructure, this.importRoot, t, this.metadata);
                        this.pubSeq.done(seq);
                        ++queuedCount;
                        continue block1;
                    }
                    collectedCount += this.collect(queuedCount - collectedCount, this.checkStatusRef);
                }
            }
            collectedCount += this.collect(queuedCount - collectedCount, this.checkStatusRef);
            assert (collectedCount == queuedCount);
        }
        this.phaseEpilogue((byte)6);
    }

    private void phaseEpilogue(byte phase) {
        this.throwErrorIfNotOk();
        long endMs = this.getCurrentTimeMs();
        LOG.info().$("finished [importId=").$hexPadded(this.importId).$(", phase=").$(CopyTask.getPhaseName(phase)).$(", file=`").$(this.inputFilePath).$("`, duration=").$((endMs - this.startMs) / 1000L).$('s').$(", errors=").$(this.phaseErrors).I$();
        this.updatePhaseStatus(phase, (byte)1, null);
    }

    private void phasePartitionImport() throws TextImportException {
        if (this.partitions.size() == 0) {
            if (this.linesIndexed > 0L) {
                throw TextImportException.instance((byte)3, "All rows were skipped. Possible reasons: timestamp format mismatch or rows exceed maximum line length (65k).");
            }
            throw TextImportException.instance((byte)3, "No rows in input file to import.");
        }
        this.phasePrologue((byte)3);
        this.taskCount = ParallelCsvFileImporter.assignPartitions(this.partitions, this.workerCount);
        int queuedCount = 0;
        int collectedCount = 0;
        this.taskDistribution.clear();
        for (int i = 0; i < this.taskCount; ++i) {
            int hi;
            int lo;
            for (lo = 0; lo < this.partitions.size() && this.partitions.getQuick((int)lo).taskId != i; ++lo) {
            }
            for (hi = lo + 1; hi < this.partitions.size() && this.partitions.getQuick((int)hi).taskId == i; ++hi) {
            }
            while (true) {
                long seq;
                if ((seq = this.pubSeq.next()) > -1L) {
                    CopyTask task = this.queue.get(seq);
                    task.setChunkIndex(i);
                    task.setCircuitBreaker(this.circuitBreaker);
                    task.ofPhasePartitionImport(this.cairoEngine, this.targetTableStructure, this.textMetadataDetector.getColumnTypes(), this.atomicity, this.columnDelimiter, this.importRoot, this.inputFileName, i, lo, hi, this.partitions);
                    this.pubSeq.done(seq);
                    ++queuedCount;
                    break;
                }
                collectedCount += this.collect(queuedCount - collectedCount, this.collectDataImportStatsRef);
            }
            this.taskDistribution.add(i);
            this.taskDistribution.add(lo);
            this.taskDistribution.add(hi);
        }
        collectedCount += this.collect(queuedCount - collectedCount, this.collectDataImportStatsRef);
        assert (collectedCount == queuedCount);
        this.phaseEpilogue((byte)3);
    }

    private void phasePrologue(byte phase) {
        this.phaseErrors = 0L;
        LOG.info().$("started [importId=").$hexPadded(this.importId).$(", phase=").$(CopyTask.getPhaseName(phase)).$(", file=`").$(this.inputFilePath).$("`, workerCount=").$(this.workerCount).I$();
        this.updatePhaseStatus(phase, (byte)0, null);
        this.startMs = this.getCurrentTimeMs();
    }

    private void phaseSymbolTableMerge() throws TextImportException {
        this.phasePrologue((byte)4);
        int tmpTableCount = this.getTaskCount();
        int queuedCount = 0;
        int collectedCount = 0;
        int size = this.metadata.getColumnCount();
        block0: for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            if (!ColumnType.isSymbol(this.metadata.getColumnType(columnIndex))) continue;
            String symbolColumnName = this.metadata.getColumnName(columnIndex);
            int tmpTableSymbolColumnIndex = this.targetTableStructure.getSymbolColumnIndex(symbolColumnName);
            while (true) {
                long seq;
                if ((seq = this.pubSeq.next()) > -1L) {
                    CopyTask task = this.queue.get(seq);
                    task.setChunkIndex(columnIndex);
                    task.ofPhaseSymbolTableMerge(this.configuration, this.importRoot, this.writer, this.tableToken, symbolColumnName, this.metadata.getWriterIndex(columnIndex), tmpTableSymbolColumnIndex, tmpTableCount, this.partitionBy);
                    this.pubSeq.done(seq);
                    ++queuedCount;
                    continue block0;
                }
                collectedCount += this.collect(queuedCount - collectedCount, this.collectStubRef);
            }
        }
        collectedCount += this.collect(queuedCount - collectedCount, this.collectStubRef);
        assert (collectedCount == queuedCount);
        this.phaseEpilogue((byte)4);
    }

    private void phaseUpdateSymbolKeys() throws TextImportException {
        this.phasePrologue((byte)5);
        int tmpTableCount = this.getTaskCount();
        int queuedCount = 0;
        int collectedCount = 0;
        for (int t = 0; t < tmpTableCount; ++t) {
            this.tmpPath.of(this.importRoot).concat(this.tableToken.getTableName()).put('_').put(t);
            try (TxReader txFile = new TxReader(this.ff).ofRO(this.tmpPath.concat("_txn").$(), this.partitionBy);){
                txFile.unsafeLoadAll();
                int partitionCount = txFile.getPartitionCount();
                for (int p = 0; p < partitionCount; ++p) {
                    long partitionSize = txFile.getPartitionSize(p);
                    long partitionTimestamp = txFile.getPartitionTimestampByIndex(p);
                    int symbolColumnIndex = 0;
                    if (partitionSize == 0L) continue;
                    int size = this.metadata.getColumnCount();
                    block7: for (int c = 0; c < size; ++c) {
                        if (!ColumnType.isSymbol(this.metadata.getColumnType(c))) continue;
                        String symbolColumnName = this.metadata.getColumnName(c);
                        int symbolCount = txFile.getSymbolValueCount(symbolColumnIndex++);
                        while (true) {
                            long seq;
                            if ((seq = this.pubSeq.next()) > -1L) {
                                CopyTask task = this.queue.get(seq);
                                task.setChunkIndex(t);
                                task.setCircuitBreaker(this.circuitBreaker);
                                task.ofPhaseUpdateSymbolKeys(this.cairoEngine, this.targetTableStructure, t, partitionSize, partitionTimestamp, this.importRoot, symbolColumnName, symbolCount);
                                this.pubSeq.done(seq);
                                ++queuedCount;
                                continue block7;
                            }
                            collectedCount += this.collect(queuedCount - collectedCount, this.collectStubRef);
                        }
                    }
                }
                continue;
            }
        }
        collectedCount += this.collect(queuedCount - collectedCount, this.collectStubRef);
        assert (collectedCount == queuedCount);
        this.phaseEpilogue((byte)5);
    }

    private void processChunkStats(long fileLength, int chunks) {
        long quotes = this.chunkStats.get(0);
        this.indexChunkStats.setPos(0);
        this.indexChunkStats.add(0L);
        this.indexChunkStats.add(0L);
        long totalLines = chunks > 0 ? this.chunkStats.get(1) + 1L : 1L;
        for (int i = 1; i < chunks; ++i) {
            long lines;
            long startPos;
            if ((quotes & 1L) == 1L) {
                startPos = this.chunkStats.get(5 * i + 4);
                lines = this.chunkStats.get(5 * i + 2);
            } else {
                startPos = this.chunkStats.get(5 * i + 3);
                lines = this.chunkStats.get(5 * i + 1);
            }
            if (startPos > -1L) {
                this.indexChunkStats.add(startPos);
                this.indexChunkStats.add(totalLines);
            }
            quotes += this.chunkStats.get(5 * i);
            totalLines += lines;
        }
        if (this.indexChunkStats.get(this.indexChunkStats.size() - 2) < fileLength) {
            this.indexChunkStats.add(fileLength);
            this.indexChunkStats.add(totalLines);
        }
    }

    private void processIndexStats() {
        LongHashSet set = new LongHashSet();
        int n = this.partitionKeysAndSizes.size();
        for (int i = 0; i < n; i += 2) {
            set.add(this.partitionKeysAndSizes.get(i));
        }
        LongList distinctKeys = new LongList();
        int n2 = set.size();
        for (int i = 0; i < n2; ++i) {
            distinctKeys.add(set.get(i));
        }
        distinctKeys.sort();
        LongList totalSizes = new LongList();
        int n3 = distinctKeys.size();
        for (int i = 0; i < n3; ++i) {
            long key = distinctKeys.getQuick(i);
            long size = 0L;
            int m = this.partitionKeysAndSizes.size();
            for (int j = 0; j < m; j += 2) {
                if (this.partitionKeysAndSizes.getQuick(j) != key) continue;
                size += this.partitionKeysAndSizes.get(j + 1);
            }
            totalSizes.add(size);
        }
        DateFormat dirFormat = PartitionBy.getPartitionDirFormatMethod(this.partitionBy);
        int n4 = distinctKeys.size();
        for (int i = 0; i < n4; ++i) {
            long key = distinctKeys.getQuick(i);
            long size = totalSizes.getQuick(i);
            this.partitionNameSink.clear();
            dirFormat.format(distinctKeys.get(i), null, null, this.partitionNameSink);
            String dirName = this.partitionNameSink.toString();
            this.partitions.add(new PartitionInfo(key, dirName, size));
        }
    }

    private void removeWorkDir() {
        Path workDirPath = this.tmpPath.of(this.importRoot).$();
        if (this.ff.exists(workDirPath)) {
            if (this.isOneOfMainDirectories(this.importRoot)) {
                throw TextException.$("could not remove import work directory because it points to one of main directories [path='").put(workDirPath).put("'] .");
            }
            LOG.info().$("removing import work directory [path='").$(workDirPath).$("']").$();
            int errno = this.ff.rmdir(workDirPath);
            if (errno != 0) {
                throw TextException.$("could not remove import work directory [path='").put(workDirPath).put("', errno=").put(errno).put(']');
            }
        }
    }

    private void stealWork() {
        if (this.localImportJob.run(0, Job.RUNNING_STATUS)) {
            return;
        }
        Os.pause();
    }

    private void throwErrorIfNotOk() {
        if (this.status == 2) {
            throw TextImportException.instance(this.phase, "import failed [phase=").put(CopyTask.getPhaseName(this.phase)).put(", msg=`").put(this.errorMessage).put("`]");
        }
        if (this.status == 3) {
            TextImportException ex = TextImportException.instance(this.phase, "import cancelled [phase=").put(CopyTask.getPhaseName(this.phase)).put(", msg=`").put(this.errorMessage).put("`]");
            ex.setCancelled(true);
            throw ex;
        }
    }

    private void updateStatus(CopyTask task) {
        boolean cancelledOrFailed;
        boolean bl = cancelledOrFailed = this.status == 2 || this.status == 3;
        if (!cancelledOrFailed && (task.isFailed() || task.isCancelled())) {
            this.status = task.getStatus();
            this.phase = task.getPhase();
            this.errorMessage = task.getErrorMessage();
        }
    }

    void prepareTable(ObjList<CharSequence> names, ObjList<TypeAdapter> types, Path path, TypeManager typeManager) throws TextException {
        if (types.size() == 0) {
            throw CairoException.nonCritical().put("cannot determine text structure");
        }
        if (this.partitionBy == 3) {
            throw CairoException.nonCritical().put("partition strategy for parallel import cannot be NONE");
        }
        if (this.partitionBy < 0) {
            this.partitionBy = 3;
        }
        if (this.timestampIndex == -1 && this.timestampColumn != null) {
            int n = names.size();
            for (int i = 0; i < n; ++i) {
                if (!Chars.equalsIgnoreCase(names.get(i), this.timestampColumn)) continue;
                this.timestampIndex = i;
                break;
            }
        }
        try {
            this.targetTableStatus = this.cairoEngine.getTableStatus(path, this.tableToken);
            switch (this.targetTableStatus) {
                case 1: {
                    if (this.partitionBy == 3) {
                        throw TextException.$("partition by unit must be set when importing to new table");
                    }
                    if (this.timestampColumn == null) {
                        throw TextException.$("timestamp column must be set when importing to new table");
                    }
                    if (this.timestampIndex == -1) {
                        throw TextException.$("timestamp column '").put(this.timestampColumn).put("' not found in file header");
                    }
                    this.validate(names, types, null, -1);
                    this.symbolCapacities.setAll(types.size(), -1);
                    this.targetTableStructure.of(this.tableName, names, types, this.symbolCapacities, this.timestampIndex, this.partitionBy);
                    ParallelCsvFileImporter.createTable(this.ff, this.configuration.getMkDirMode(), this.configuration.getRoot(), this.tableToken.getDirName(), this.targetTableStructure.getTableName(), this.targetTableStructure, this.tableToken.getTableId());
                    this.cairoEngine.registerTableToken(this.tableToken);
                    this.targetTableCreated = true;
                    this.writer = this.cairoEngine.getWriter(this.tableToken, LOCK_REASON);
                    this.metadata = GenericRecordMetadata.copyDense(this.writer.getMetadata());
                    this.partitionBy = this.writer.getPartitionBy();
                    break;
                }
                case 0: {
                    this.initWriterAndOverrideImportMetadata(names, types, typeManager);
                    if (this.writer.getRowCount() > 0L) {
                        throw TextException.$("target table must be empty [table=").put(this.tableName).put(']');
                    }
                    String designatedTimestampColumnName = this.writer.getDesignatedTimestampColumnName();
                    int designatedTimestampIndex = this.metadata.getTimestampIndex();
                    if (PartitionBy.isPartitioned(this.partitionBy) && this.partitionBy != this.writer.getPartitionBy()) {
                        throw TextException.$("declared partition by unit doesn't match table's");
                    }
                    this.partitionBy = this.writer.getPartitionBy();
                    if (!PartitionBy.isPartitioned(this.partitionBy)) {
                        throw TextException.$("target table is not partitioned");
                    }
                    this.validate(names, types, designatedTimestampColumnName, designatedTimestampIndex);
                    this.targetTableStructure.of(this.tableName, names, types, this.symbolCapacities, this.timestampIndex, this.partitionBy);
                    break;
                }
                default: {
                    throw TextException.$("name is reserved [table=").put(this.tableName).put(']');
                }
            }
            this.inputFilePath.of(this.inputRoot).concat(this.inputFileName).$();
            this.targetTableStructure.setIgnoreColumnIndexedFlag(true);
            if (this.timestampAdapter == null && ColumnType.isTimestamp(types.getQuick(this.timestampIndex).getType())) {
                this.timestampAdapter = (TimestampAdapter)types.getQuick(this.timestampIndex);
            }
        }
        catch (Throwable t) {
            this.closeWriter();
            throw t;
        }
    }

    void validate(ObjList<CharSequence> names, ObjList<TypeAdapter> types, CharSequence designatedTimestampColumnName, int designatedTimestampIndex) throws TextException {
        TypeAdapter timestampAdapter;
        short typeTag;
        if (this.timestampColumn == null && designatedTimestampColumnName == null) {
            this.timestampIndex = -1;
        } else if (this.timestampColumn != null) {
            this.timestampIndex = names.indexOf(this.timestampColumn);
            if (this.timestampIndex == -1) {
                throw TextException.$("invalid timestamp column [name='").put(this.timestampColumn).put("']");
            }
        } else {
            this.timestampIndex = names.indexOf(designatedTimestampColumnName);
            if (this.timestampIndex == -1) {
                this.timestampIndex = designatedTimestampIndex;
            }
        }
        if (this.timestampIndex != -1 && ((typeTag = ColumnType.tagOf((timestampAdapter = types.getQuick(this.timestampIndex)).getType())) != 6 && typeTag != 8 || timestampAdapter == BadTimestampAdapter.INSTANCE)) {
            throw TextException.$("column is not a timestamp [no=").put(this.timestampIndex).put(", name='").put(this.timestampColumn).put("']");
        }
    }

    public static class TableStructureAdapter
    implements TableStructure {
        private final LongList columnBits = new LongList();
        private final CairoConfiguration configuration;
        private ObjList<CharSequence> columnNames;
        private boolean ignoreColumnIndexedFlag;
        private int partitionBy;
        private IntList symbolCapacities;
        private CharSequence tableName;
        private int timestampColumnIndex;

        public TableStructureAdapter(CairoConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.columnNames.getQuick(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            return Numbers.decodeLowInt(this.columnBits.getQuick(columnIndex));
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return this.configuration.getIndexValueBlockSize();
        }

        @Override
        public int getMaxUncommittedRows() {
            return this.configuration.getMaxUncommittedRows();
        }

        @Override
        public long getO3MaxLag() {
            return this.configuration.getO3MaxLag();
        }

        @Override
        public int getPartitionBy() {
            return this.partitionBy;
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            return false;
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            int capacity = this.symbolCapacities.getQuick(columnIndex);
            return capacity != -1 ? capacity : this.configuration.getDefaultSymbolCapacity();
        }

        public int getSymbolColumnIndex(CharSequence symbolColumnName) {
            int index = -1;
            int n = this.columnNames.size();
            for (int i = 0; i < n; ++i) {
                if (this.getColumnType(i) == 12) {
                    ++index;
                }
                if (!symbolColumnName.equals(this.columnNames.get(i))) continue;
                return index;
            }
            return -1;
        }

        @Override
        public CharSequence getTableName() {
            return this.tableName;
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampColumnIndex;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return !this.ignoreColumnIndexedFlag && Numbers.decodeHighInt(this.columnBits.getQuick(columnIndex)) != 0;
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return false;
        }

        @Override
        public boolean isWalEnabled() {
            return this.configuration.getWalEnabledDefault() && PartitionBy.isPartitioned(this.partitionBy);
        }

        public void of(CharSequence tableName, ObjList<CharSequence> names, ObjList<TypeAdapter> types, IntList symbolCapacities, int timestampColumnIndex, int partitionBy) {
            this.tableName = tableName;
            this.columnNames = names;
            this.symbolCapacities = symbolCapacities;
            this.ignoreColumnIndexedFlag = false;
            this.columnBits.clear();
            int size = types.size();
            for (int i = 0; i < size; ++i) {
                TypeAdapter adapter = types.getQuick(i);
                this.columnBits.add(Numbers.encodeLowHighInts(adapter.getType(), adapter.isIndexed() ? 1 : 0));
            }
            this.timestampColumnIndex = timestampColumnIndex;
            this.partitionBy = partitionBy;
        }

        public void setIgnoreColumnIndexedFlag(boolean flag) {
            this.ignoreColumnIndexedFlag = flag;
        }
    }

    public static class PartitionInfo {
        final long bytes;
        final long key;
        final CharSequence name;
        long importedRows;
        int taskId;

        public PartitionInfo(long key, CharSequence name, long bytes) {
            this.key = key;
            this.name = name;
            this.bytes = bytes;
        }

        public PartitionInfo(long key, CharSequence name, long bytes, int taskId) {
            this.key = key;
            this.name = name;
            this.bytes = bytes;
            this.taskId = taskId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionInfo that = (PartitionInfo)o;
            return this.key == that.key && this.bytes == that.bytes && this.taskId == that.taskId && this.importedRows == that.importedRows && this.name.equals(that.name);
        }

        public String toString() {
            return "PartitionInfo{key=" + this.key + ", name=" + this.name + ", bytes=" + this.bytes + ", taskId=" + this.taskId + ", importedRows=" + this.importedRows + "}";
        }
    }

    @FunctionalInterface
    public static interface PhaseStatusReporter {
        public void report(byte var1, byte var2, @Nullable CharSequence var3, long var4, long var6, long var8);
    }
}

